/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.mixin.core.world.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.interfaces.IMixinSaveHandler;

@Mixin(value={SaveHandler.class})
public abstract class MixinSaveHandler
implements IMixinSaveHandler {
    @Redirect(method={"loadWorldInfo"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/storage/SaveFormatOld;getWorldData(Ljava/io/File;Lnet/minecraft/util/datafix/DataFixer;)Lnet/minecraft/world/storage/WorldInfo;"), require=2)
    private WorldInfo onGetOldWorldInfo(File file, DataFixer fixer) {
        try {
            NBTTagCompound root = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
            NBTTagCompound data = root.func_74775_l("Data");
            WorldInfo info = new WorldInfo(fixer.func_188257_a((IFixType)FixTypes.LEVEL, data));
            this.loadDimensionAndOtherData((SaveHandler)this, info, root);
            try {
                this.loadSpongeDatData(info);
            }
            catch (Exception ex) {
                SpongeImpl.getLogger().error("Exception reading Sponge level data", (Throwable)ex);
                return null;
            }
            return info;
        }
        catch (Exception exception) {
            SpongeImpl.getLogger().error("Exception reading " + file, (Throwable)exception);
            return null;
        }
    }
}

