/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import org.spongepowered.api.data.type.DoublePlantType;
import org.spongepowered.api.data.type.DoublePlantTypes;
import org.spongepowered.api.data.type.PlantTypes;
import org.spongepowered.api.data.type.ShrubTypes;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.WeightedObject;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.extent.ImmutableBiomeVolume;
import org.spongepowered.api.world.gen.Populator;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.populator.DoublePlant;
import org.spongepowered.api.world.gen.populator.Flower;
import org.spongepowered.api.world.gen.populator.Shrub;
import org.spongepowered.common.world.gen.InternalPopulatorTypes;

public class PlainsGrassPopulator
implements Populator {
    private NoiseGeneratorPerlin noise = new NoiseGeneratorPerlin(new Random(2345L), 1);
    private final boolean sunflowers;
    private Flower flowers;
    private Shrub grass;
    private DoublePlant plant;

    public PlainsGrassPopulator(boolean sunflowers) {
        this.sunflowers = sunflowers;
        this.flowers = Flower.builder().perChunk(15).type(PlantTypes.DANDELION, 2.0).type(PlantTypes.POPPY, 1.0).build();
        this.grass = Shrub.builder().perChunk(5).type(ShrubTypes.TALL_GRASS, 1).build();
        this.plant = DoublePlant.builder().type(DoublePlantTypes.GRASS, 1.0).build();
    }

    @Override
    public PopulatorType getType() {
        return InternalPopulatorTypes.PLAINS_GRASS;
    }

    @Override
    public void populate(World world, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        BlockPos chunkPos = new BlockPos(min.getX(), min.getY(), min.getZ());
        double d0 = this.noise.func_151601_a((double)(chunkPos.func_177958_n() + 8) / 200.0, (double)(chunkPos.func_177952_p() + 8) / 200.0);
        if (d0 < -0.8) {
            this.flowers.setFlowersPerChunk(960);
            this.grass.setShrubsPerChunk(320);
        } else {
            this.flowers.setFlowersPerChunk(256);
            this.grass.setShrubsPerChunk(640);
            this.plant.getPossibleTypes().clear();
            this.plant.getPossibleTypes().add((TableEntry<DoublePlantType>)new WeightedObject<DoublePlantType>(DoublePlantTypes.GRASS, 1.0));
            this.plant.setPlantsPerChunk(35);
            this.plant.populate(world, extent, random);
        }
        this.flowers.populate(world, extent, random);
        this.grass.populate(world, extent, random);
        if (this.sunflowers) {
            this.plant.getPossibleTypes().clear();
            this.plant.getPossibleTypes().add((TableEntry<DoublePlantType>)new WeightedObject<DoublePlantType>(DoublePlantTypes.SUNFLOWER, 1.0));
            this.plant.setPlantsPerChunk(50);
            this.plant.populate(world, extent, random);
        }
    }

    @Override
    public void populate(World world, Extent extent, Random random, ImmutableBiomeVolume virtualBiomes) {
        Vector3i min = extent.getBlockMin();
        BlockPos chunkPos = new BlockPos(min.getX(), min.getY(), min.getZ());
        double d0 = this.noise.func_151601_a((double)(chunkPos.func_177958_n() + 8) / 200.0, (double)(chunkPos.func_177952_p() + 8) / 200.0);
        if (d0 < -0.8) {
            this.flowers.setFlowersPerChunk(960);
            this.grass.setShrubsPerChunk(320);
        } else {
            this.flowers.setFlowersPerChunk(256);
            this.grass.setShrubsPerChunk(640);
            this.plant.getPossibleTypes().clear();
            this.plant.getPossibleTypes().add((TableEntry<DoublePlantType>)new WeightedObject<DoublePlantType>(DoublePlantTypes.GRASS, 1.0));
            this.plant.setPlantsPerChunk(35);
            this.plant.populate(world, extent, random, virtualBiomes);
        }
        this.flowers.populate(world, extent, random, virtualBiomes);
        this.grass.populate(world, extent, random, virtualBiomes);
        if (this.sunflowers) {
            this.plant.getPossibleTypes().clear();
            this.plant.getPossibleTypes().add((TableEntry<DoublePlantType>)new WeightedObject<DoublePlantType>(DoublePlantTypes.SUNFLOWER, 1.0));
            this.plant.setPlantsPerChunk(50);
            this.plant.populate(world, extent, random, virtualBiomes);
        }
    }
}

