/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedObject;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorObject;
import org.spongepowered.api.world.gen.populator.Forest;
import org.spongepowered.common.world.gen.populators.ForestPopulator;

public class ForestBuilder
implements Forest.Builder {
    private VariableAmount count;
    private WeightedTable<PopulatorObject> types;
    @Nullable
    private Function<Location<Extent>, PopulatorObject> override;

    public ForestBuilder() {
        this.reset();
    }

    @Override
    public Forest.Builder perChunk(VariableAmount count) {
        this.count = count;
        return this;
    }

    @Override
    public Forest.Builder types(WeightedTable<PopulatorObject> types) {
        Preconditions.checkNotNull(types, (Object)"types");
        this.types = types;
        return this;
    }

    @Override
    public Forest.Builder type(PopulatorObject type, double weight) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0);
        this.types.add((TableEntry<PopulatorObject>)new WeightedObject<PopulatorObject>(type, weight));
        return this;
    }

    @Override
    public Forest.Builder supplier(@Nullable Function<Location<Extent>, PopulatorObject> override) {
        this.override = override;
        return this;
    }

    @Override
    public Forest.Builder from(Forest value) {
        WeightedTable<PopulatorObject> table = new WeightedTable<PopulatorObject>();
        table.addAll((Collection<TableEntry<PopulatorObject>>)value.getTypes());
        return this.perChunk(value.getTreesPerChunk()).types(table).supplier(value.getSupplierOverride().orElse(null));
    }

    @Override
    public Forest.Builder reset() {
        this.types = new WeightedTable();
        this.count = VariableAmount.fixed(5.0);
        this.override = null;
        return this;
    }

    @Override
    public Forest build() throws IllegalStateException {
        ForestPopulator pop = new ForestPopulator();
        pop.setTreesPerChunk(this.count);
        pop.getTypes().addAll((Collection<TableEntry<PopulatorObject>>)this.types);
        pop.setSupplierOverride(this.override);
        return pop;
    }
}

