/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.permission.base;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.MemorySubjectData;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.util.Tristate;

public abstract class SpongeBaseSubject
implements Subject {
    public abstract PermissionService getService();

    @Override
    public abstract MemorySubjectData getTransientSubjectData();

    @Override
    public boolean isSubjectDataPersisted() {
        return false;
    }

    @Override
    public SubjectReference asSubjectReference() {
        return this.getService().newSubjectReference(this.getContainingCollection().getIdentifier(), this.getIdentifier());
    }

    @Override
    public boolean hasPermission(Set<Context> contexts, String permission) {
        return this.getPermissionValue(contexts, permission) == Tristate.TRUE;
    }

    @Override
    public Tristate getPermissionValue(Set<Context> contexts, String permission) {
        return this.getDataPermissionValue(this.getTransientSubjectData(), permission);
    }

    protected Tristate getDataPermissionValue(MemorySubjectData subject, String permission) {
        Tristate res = subject.getNodeTree(SubjectData.GLOBAL_CONTEXT).get(permission);
        if (res == Tristate.UNDEFINED) {
            for (SubjectReference parent : subject.getParents(SubjectData.GLOBAL_CONTEXT)) {
                res = parent.resolve().join().getPermissionValue(SubjectData.GLOBAL_CONTEXT, permission);
                if (res == Tristate.UNDEFINED) continue;
                return res;
            }
        }
        return res;
    }

    @Override
    public boolean isChildOf(Set<Context> contexts, SubjectReference parent) {
        return this.getSubjectData().getParents(contexts).contains(parent);
    }

    @Override
    public List<SubjectReference> getParents(Set<Context> contexts) {
        return this.getSubjectData().getParents(contexts);
    }

    protected Optional<String> getDataOptionValue(MemorySubjectData subject, String option) {
        Optional<String> res = Optional.ofNullable(subject.getOptions(SubjectData.GLOBAL_CONTEXT).get(option));
        if (!res.isPresent()) {
            for (SubjectReference parent : subject.getParents(SubjectData.GLOBAL_CONTEXT)) {
                res = parent.resolve().join().getOption(SubjectData.GLOBAL_CONTEXT, option);
                if (!res.isPresent()) continue;
                return res;
            }
        }
        return res;
    }

    @Override
    public Optional<String> getOption(Set<Context> contexts, String key) {
        return this.getDataOptionValue(this.getTransientSubjectData(), key);
    }

    @Override
    public Set<Context> getActiveContexts() {
        return SubjectData.GLOBAL_CONTEXT;
    }
}

