/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.biome;

import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeHills;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.util.weighted.SeededVariableAmount;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.biome.GroundCoverLayer;
import org.spongepowered.api.world.gen.populator.Forest;
import org.spongepowered.api.world.gen.populator.Ore;
import org.spongepowered.api.world.gen.populator.RandomBlock;
import org.spongepowered.api.world.gen.type.BiomeTreeTypes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.mixin.core.world.biome.MixinBiome;
import org.spongepowered.common.world.biome.SpongeBiomeGenerationSettings;
import org.spongepowered.common.world.gen.WorldGenConstants;

@Mixin(value={BiomeHills.class})
public abstract class MixinBiomeHills
extends MixinBiome {
    @Shadow
    @Final
    private BiomeHills.Type field_150638_aH;

    @Override
    public void buildPopulators(World world, SpongeBiomeGenerationSettings gensettings) {
        super.buildPopulators(world, gensettings);
        gensettings.getGroundCoverLayers().clear();
        gensettings.getGroundCoverLayers().add(new GroundCoverLayer(stoneNoise -> {
            IBlockState result = Blocks.field_150349_c.func_176223_P();
            if ((stoneNoise < -1.0 || stoneNoise > 2.0) && this.field_150638_aH == BiomeHills.Type.MUTATED) {
                result = Blocks.field_150351_n.func_176223_P();
            } else if (stoneNoise > 1.0 && this.field_150638_aH != BiomeHills.Type.EXTRA_TREES) {
                result = Blocks.field_150348_b.func_176223_P();
            }
            return (BlockState)result;
        }, SeededVariableAmount.fixed(1.0)));
        gensettings.getGroundCoverLayers().add(new GroundCoverLayer(stoneNoise -> {
            IBlockState result = Blocks.field_150346_d.func_176223_P();
            if ((stoneNoise < -1.0 || stoneNoise > 2.0) && this.field_150638_aH == BiomeHills.Type.MUTATED) {
                result = Blocks.field_150351_n.func_176223_P();
            } else if (stoneNoise > 1.0 && this.field_150638_aH != BiomeHills.Type.EXTRA_TREES) {
                result = Blocks.field_150348_b.func_176223_P();
            }
            return (BlockState)result;
        }, WorldGenConstants.GROUND_COVER_DEPTH));
        BiomeDecorator theBiomeDecorator = this.field_76760_I;
        RandomBlock emerald = RandomBlock.builder().block((BlockState)Blocks.field_150412_bA.func_176223_P()).placementTarget(WorldGenConstants.STONE_LOCATION).perChunk(VariableAmount.baseWithRandomAddition(3.0, 6.0)).height(VariableAmount.baseWithRandomAddition(4.0, 28.0)).build();
        gensettings.getPopulators().add(emerald);
        Ore silverfish = Ore.builder().ore((BlockState)Blocks.field_150418_aU.func_176223_P().func_177226_a((IProperty)BlockSilverfish.field_176378_a, (Comparable)BlockSilverfish.EnumType.STONE)).perChunk(7).height(VariableAmount.baseWithRandomAddition(0.0, 64.0)).size(9).build();
        gensettings.getPopulators().add(silverfish);
        gensettings.getPopulators().removeAll(gensettings.getPopulators(Forest.class));
        Forest.Builder forest = Forest.builder();
        forest.perChunk(VariableAmount.baseWithOptionalAddition((double)theBiomeDecorator.field_76832_z, 1.0, 0.1));
        forest.type(BiomeTreeTypes.TALL_TAIGA.getPopulatorObject(), 20.0);
        forest.type(BiomeTreeTypes.OAK.getPopulatorObject(), 9.0);
        forest.type(BiomeTreeTypes.OAK.getLargePopulatorObject().get(), 1.0);
        gensettings.getPopulators().add(0, forest.build());
    }
}

