/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item.inventory;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.world.World;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.item.inventory.CraftItemEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.interfaces.IMixinContainer;
import org.spongepowered.common.interfaces.world.IMixinWorld;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

@Mixin(value={SlotCrafting.class})
public abstract class MixinSlotCrafting
extends Slot {
    @Shadow
    @Final
    private EntityPlayer field_75238_b;
    @Shadow
    @Final
    private InventoryCrafting field_75239_a;
    @Nullable
    private CraftingRecipe lastRecipe;

    public MixinSlotCrafting(IInventory inventoryIn, int index, int xPosition, int yPosition) {
        super(inventoryIn, index, xPosition, yPosition);
    }

    public void func_75215_d(@Nullable ItemStack stack) {
        super.func_75215_d(stack);
        if (this.field_75238_b instanceof EntityPlayerMP) {
            ((EntityPlayerMP)this.field_75238_b).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(0, 0, stack));
        }
    }

    @Inject(method={"onTake"}, at={@At(value="HEAD")})
    private void beforeTake(EntityPlayer thePlayer, ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        this.lastRecipe = (CraftingRecipe)CraftingManager.func_192413_b((InventoryCrafting)this.field_75239_a, (World)thePlayer.field_70170_p);
        if (((IMixinContainer)thePlayer.field_71070_bA).isShiftCrafting()) {
            ((IMixinContainer)thePlayer.field_71070_bA).detectAndSendChanges(true);
            ((IMixinContainer)thePlayer.field_71070_bA).setShiftCrafting(false);
        }
    }

    @Inject(method={"onTake"}, cancellable=true, at={@At(value="RETURN")})
    private void afterTake(EntityPlayer thePlayer, ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        ItemStackSnapshot craftedItem;
        if (((IMixinWorld)thePlayer.field_70170_p).isFake()) {
            return;
        }
        ((IMixinContainer)thePlayer.field_71070_bA).setCaptureInventory(false);
        Container container = thePlayer.field_71070_bA;
        CraftingInventory craftInv = (CraftingInventory)((Inventory)container).query(QueryOperationTypes.INVENTORY_TYPE.of(CraftingInventory.class));
        Transaction last = null;
        List<SlotTransaction> capturedTransactions = ((IMixinContainer)container).getCapturedTransactions();
        Iterator<SlotTransaction> iterator = capturedTransactions.iterator();
        while (iterator.hasNext()) {
            SlotTransaction trans = iterator.next();
            Optional<SlotIndex> slotIndex = trans.getSlot().getInventoryProperty(SlotIndex.class);
            if (!slotIndex.isPresent() || (Integer)slotIndex.get().getValue() != 0) continue;
            iterator.remove();
            last = trans;
        }
        if (last != null) {
            capturedTransactions.add((SlotTransaction)last);
            craftedItem = (ItemStackSnapshot)((ItemStackSnapshot)last.getOriginal()).copy();
        } else {
            craftedItem = ItemStackUtil.snapshotOf(this.func_75211_c());
        }
        CraftItemEvent.Craft event = SpongeCommonEventFactory.callCraftEventPost(thePlayer, craftInv, craftedItem, this.lastRecipe, container, capturedTransactions);
        ((IMixinContainer)container).setLastCraft(event);
    }
}

