/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.util;

import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.AbstractChestHorse;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ContainerBeacon;
import net.minecraft.inventory.ContainerBrewingStand;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.ContainerDispenser;
import net.minecraft.inventory.ContainerEnchantment;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.ContainerHopper;
import net.minecraft.inventory.ContainerHorseInventory;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.item.inventory.BlockCarrier;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.InventoryArchetypes;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.slot.InputSlot;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.ItemDropData;
import org.spongepowered.common.interfaces.IMixinContainer;
import org.spongepowered.common.interfaces.IMixinSingleBlockCarrier;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.VanillaAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.slots.CraftingOutputAdapter;
import org.spongepowered.common.item.inventory.custom.CustomContainer;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.LensProvider;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.comp.CraftingInventoryLens;
import org.spongepowered.common.item.inventory.lens.comp.GridInventoryLens;
import org.spongepowered.common.item.inventory.lens.comp.Inventory2DLens;
import org.spongepowered.common.item.inventory.lens.impl.DefaultEmptyLens;
import org.spongepowered.common.item.inventory.lens.impl.DelegatingLens;
import org.spongepowered.common.item.inventory.lens.impl.MinecraftFabric;
import org.spongepowered.common.item.inventory.lens.impl.collections.SlotCollection;
import org.spongepowered.common.item.inventory.lens.impl.comp.CraftingInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.GridInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.Inventory2DLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.MainPlayerInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.OrderedInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.minecraft.BrewingStandInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.minecraft.FurnaceInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.minecraft.LargeChestInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.minecraft.PlayerInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.minecraft.container.ContainerLens;
import org.spongepowered.common.item.inventory.lens.impl.slots.CraftingOutputSlotLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.slots.SlotLensImpl;
import org.spongepowered.common.util.VecHelper;

public final class ContainerUtil {
    private static final Random RANDOM = new Random();

    private ContainerUtil() {
    }

    public static Container fromNative(net.minecraft.inventory.Container container) {
        return (Container)container;
    }

    public static net.minecraft.inventory.Container toNative(Container container) {
        return (net.minecraft.inventory.Container)container;
    }

    public static IMixinContainer toMixin(net.minecraft.inventory.Container container) {
        return (IMixinContainer)container;
    }

    public static net.minecraft.inventory.Container fromMixin(IMixinContainer container) {
        return (net.minecraft.inventory.Container)container;
    }

    public static void performBlockInventoryDrops(WorldServer worldServer, double x, double y, double z, IInventory inventory) {
        PhaseData currentPhase = PhaseTracker.getInstance().getCurrentPhaseData();
        IPhaseState<?> currentState = currentPhase.state;
        if (currentState.tracksBlockSpecificDrops()) {
            PhaseContext<?> context = currentPhase.context;
            if (!currentState.ignoresItemPreMerging() && SpongeImpl.getGlobalConfig().getConfig().getOptimizations().doDropsPreMergeItemDrops()) {
                ListMultimap<BlockPos, ItemDropData> multimap = context.getBlockDropSupplier().get();
                BlockPos pos = new BlockPos(x, y, z);
                Collection itemStacks = multimap.get((Object)pos);
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    ItemStack itemStack = inventory.func_70301_a(i);
                    if (itemStack.func_190926_b()) continue;
                    SpongeImplHooks.addItemStackToListForSpawning(itemStacks, ItemDropData.item(itemStack).position(VecHelper.toVector3d(pos)).build());
                }
            } else {
                ListMultimap<BlockPos, EntityItem> multimap = context.getBlockItemDropSupplier().get();
                BlockPos pos = new BlockPos(x, y, z);
                Collection itemStacks = multimap.get((Object)pos);
                for (int j = 0; j < inventory.func_70302_i_(); ++j) {
                    ItemStack itemStack = inventory.func_70301_a(j);
                    if (itemStack.func_190926_b()) continue;
                    float f = RANDOM.nextFloat() * 0.8f + 0.1f;
                    float f1 = RANDOM.nextFloat() * 0.8f + 0.1f;
                    float f2 = RANDOM.nextFloat() * 0.8f + 0.1f;
                    while (!itemStack.func_190926_b()) {
                        int i = RANDOM.nextInt(21) + 10;
                        EntityItem entityitem = new EntityItem((net.minecraft.world.World)worldServer, x + (double)f, y + (double)f1, z + (double)f2, itemStack.func_77979_a(i));
                        entityitem.field_70159_w = RANDOM.nextGaussian() * 0.05;
                        entityitem.field_70181_x = RANDOM.nextGaussian() * 0.05 + 0.2;
                        entityitem.field_70179_y = RANDOM.nextGaussian() * 0.05;
                        itemStacks.add(entityitem);
                    }
                }
            }
            return;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((net.minecraft.world.World)worldServer, (double)x, (double)y, (double)z, (ItemStack)itemStack);
        }
    }

    @Nullable
    public static Lens<IInventory, ItemStack> getLens(Fabric<IInventory> fabric, net.minecraft.inventory.Container container, SlotProvider<IInventory, ItemStack> slots) {
        Lens<IInventory, ItemStack> lens;
        if (container instanceof InventoryAdapter && (lens = ((InventoryAdapter)container).getRootLens()) != null) {
            return lens;
        }
        if (container instanceof LensProvider) {
            InventoryAdapter adapter = (InventoryAdapter)container;
            return ((LensProvider)container).rootLens(fabric, adapter);
        }
        if (container.func_75138_a().size() == 0) {
            return new DefaultEmptyLens<IInventory>((InventoryAdapter)container);
        }
        return ContainerUtil.generateLens(container, slots);
    }

    private static Lens<IInventory, ItemStack> generateLens(net.minecraft.inventory.Container container, SlotProvider<IInventory, ItemStack> slots) {
        Map viewed = container.field_75151_b.stream().collect(Collectors.groupingBy(i -> Optional.ofNullable(i.field_75224_c), LinkedHashMap::new, Collectors.toList()));
        int index = 0;
        Integer craftOutput = null;
        Integer craftGridBase = null;
        InventoryCrafting craftGrid = null;
        ArrayList<Lens<IInventory, ItemStack>> lenses = new ArrayList<Lens<IInventory, ItemStack>>();
        for (Map.Entry entry : viewed.entrySet()) {
            CraftingOutputSlotLensImpl adapterLens;
            IInventory subInventory = ((Optional)entry.getKey()).orElse(null);
            int slotCount = ((List)entry.getValue()).size();
            Lens<Object, ItemStack> lens = null;
            boolean playerLens = false;
            if (subInventory instanceof InventoryAdapter && (adapterLens = ((InventoryAdapter)subInventory).getRootLens()) != null) {
                if (adapterLens instanceof PlayerInventoryLens) {
                    playerLens = true;
                } else if (subInventory.func_70302_i_() == 0) {
                    lens = new DefaultEmptyLens((InventoryAdapter)subInventory);
                } else {
                    if (subInventory instanceof InventoryCraftResult) {
                        net.minecraft.inventory.Slot slot = (net.minecraft.inventory.Slot)((List)entry.getValue()).get(0);
                        adapterLens = new CraftingOutputSlotLensImpl(index, item -> slot.func_75214_a((ItemStack)item), itemType -> slot.func_75214_a((ItemStack)org.spongepowered.api.item.inventory.ItemStack.of(itemType, 1)));
                        craftOutput = index;
                    }
                    if (subInventory instanceof InventoryCrafting) {
                        craftGridBase = index;
                        craftGrid = (InventoryCrafting)subInventory;
                    }
                    lens = new DelegatingLens(index, adapterLens, slots);
                }
            }
            if (lens == null && subInventory instanceof LensProvider) {
                Fabric<IInventory> keyFabric = MinecraftFabric.of(subInventory);
                lens = ((LensProvider)subInventory).rootLens(keyFabric, new VanillaAdapter(keyFabric, container));
            }
            if (lens == null || lens.slotCount() != slotCount) {
                if (subInventory instanceof InventoryCraftResult) {
                    net.minecraft.inventory.Slot slot = (net.minecraft.inventory.Slot)((List)entry.getValue()).get(0);
                    lens = new CraftingOutputSlotLensImpl(index, item -> slot.func_75214_a((ItemStack)item), itemType -> slot.func_75214_a((ItemStack)org.spongepowered.api.item.inventory.ItemStack.of(itemType, 1)));
                } else if (subInventory instanceof InventoryCrafting) {
                    craftGrid = (InventoryCrafting)subInventory;
                    lens = new GridInventoryLensImpl(index, craftGrid.func_174922_i(), craftGrid.func_174923_h(), craftGrid.func_174922_i(), InputSlot.class, slots);
                } else if (slotCount == 1) {
                    lens = new SlotLensImpl(index);
                } else if ((lens instanceof PlayerInventoryLens || playerLens) && slotCount == 36) {
                    lenses.add(new DelegatingLens(index, new MainPlayerInventoryLensImpl(index, slots, true), slots));
                    lens = null;
                } else if (subInventory instanceof InventoryBasic && subInventory.getClass().isAnonymousClass()) {
                    switch (subInventory.func_70005_c_()) {
                        case "Enchant": 
                        case "Repair": {
                            lens = new OrderedInventoryLensImpl(index, slotCount, 1, InputSlot.class, slots);
                            break;
                        }
                        default: {
                            lens = new OrderedInventoryLensImpl(index, slotCount, 1, slots);
                            break;
                        }
                    }
                } else {
                    lens = new OrderedInventoryLensImpl(index, slotCount, 1, slots);
                }
            }
            if (lens != null) {
                lenses.add((Lens<IInventory, ItemStack>)lens);
            }
            index += slotCount;
        }
        ArrayList<Lens<IInventory, ItemStack>> additional = new ArrayList<Lens<IInventory, ItemStack>>();
        if (craftOutput != null && craftGridBase != null) {
            additional.add(new CraftingInventoryLensImpl((int)craftOutput, (int)craftGridBase, craftGrid.func_174922_i(), craftGrid.func_174923_h(), slots));
        }
        return new ContainerLens((InventoryAdapter)container, slots, lenses, additional);
    }

    private static Lens<IInventory, ItemStack> copyLens(int base, InventoryAdapter<IInventory, ItemStack> adapter, Lens<IInventory, ItemStack> lens, SlotCollection slots) {
        if (lens instanceof LargeChestInventoryLens) {
            return new LargeChestInventoryLens(base, adapter, slots);
        }
        if (lens instanceof FurnaceInventoryLens) {
            return new FurnaceInventoryLens(base, adapter, slots);
        }
        if (lens instanceof BrewingStandInventoryLens) {
            return new BrewingStandInventoryLens(base, adapter, slots);
        }
        if (lens instanceof CraftingInventoryLens) {
            return new CraftingInventoryLensImpl(0, base, ((GridInventoryLens)lens).getWidth(), ((GridInventoryLens)lens).getHeight(), (SlotProvider<IInventory, ItemStack>)slots);
        }
        if (lens instanceof GridInventoryLens) {
            return new GridInventoryLensImpl(base, ((GridInventoryLens)lens).getWidth(), ((GridInventoryLens)lens).getHeight(), ((GridInventoryLens)lens).getStride(), (SlotProvider<IInventory, ItemStack>)slots);
        }
        if (lens instanceof Inventory2DLens) {
            return new Inventory2DLensImpl(base, ((Inventory2DLens)lens).getWidth(), ((Inventory2DLens)lens).getHeight(), (SlotProvider<IInventory, ItemStack>)slots);
        }
        return null;
    }

    public static SlotProvider<IInventory, ItemStack> countSlots(net.minecraft.inventory.Container container, Fabric fabric) {
        if (container instanceof LensProvider) {
            return ((LensProvider)container).slotProvider(fabric, (InventoryAdapter)container);
        }
        SlotCollection.Builder builder = new SlotCollection.Builder();
        for (net.minecraft.inventory.Slot slot : container.field_75151_b) {
            if (slot instanceof SlotCrafting) {
                builder.add(1, CraftingOutputAdapter.class, i -> new CraftingOutputSlotLensImpl(i, item -> slot.func_75214_a((ItemStack)item), itemType -> slot.func_75214_a((ItemStack)org.spongepowered.api.item.inventory.ItemStack.of(itemType, 1))));
                continue;
            }
            builder.add(1);
        }
        return builder.build();
    }

    public static InventoryArchetype getArchetype(net.minecraft.inventory.Container container) {
        if (container instanceof ContainerChest) {
            IInventory inventory = ((ContainerChest)container).func_85151_d();
            if (inventory instanceof TileEntityChest) {
                return InventoryArchetypes.CHEST;
            }
            if (inventory instanceof InventoryLargeChest) {
                return InventoryArchetypes.DOUBLE_CHEST;
            }
            return InventoryArchetypes.UNKNOWN;
        }
        if (container instanceof ContainerHopper) {
            return InventoryArchetypes.HOPPER;
        }
        if (container instanceof ContainerDispenser) {
            return InventoryArchetypes.DISPENSER;
        }
        if (container instanceof ContainerWorkbench) {
            return InventoryArchetypes.WORKBENCH;
        }
        if (container instanceof ContainerFurnace) {
            return InventoryArchetypes.FURNACE;
        }
        if (container instanceof ContainerEnchantment) {
            return InventoryArchetypes.ENCHANTING_TABLE;
        }
        if (container instanceof ContainerRepair) {
            return InventoryArchetypes.ANVIL;
        }
        if (container instanceof ContainerBrewingStand) {
            return InventoryArchetypes.BREWING_STAND;
        }
        if (container instanceof ContainerBeacon) {
            return InventoryArchetypes.BEACON;
        }
        if (container instanceof ContainerHorseInventory) {
            AbstractHorse horse = ((ContainerHorseInventory)container).field_111242_f;
            if (horse instanceof AbstractChestHorse && ((AbstractChestHorse)horse).func_190695_dh()) {
                return InventoryArchetypes.HORSE_WITH_CHEST;
            }
            return InventoryArchetypes.HORSE;
        }
        if (container instanceof ContainerMerchant) {
            return InventoryArchetypes.VILLAGER;
        }
        if (container instanceof ContainerPlayer) {
            return InventoryArchetypes.PLAYER;
        }
        return InventoryArchetypes.UNKNOWN;
    }

    public static Carrier getCarrier(final Container container) {
        Iterator iterator;
        EntityPlayer player;
        if (container instanceof BlockCarrier) {
            return (BlockCarrier)((Object)container);
        }
        if (container instanceof CustomContainer) {
            return ((CustomContainer)((Object)container)).inv.getCarrier();
        }
        if (container instanceof ContainerChest) {
            IInventory inventory = ((ContainerChest)container).func_85151_d();
            if (inventory instanceof Carrier) {
                if (inventory instanceof TileEntityChest) {
                    return (Carrier)inventory;
                }
                if (inventory instanceof InventoryLargeChest) {
                    return (BlockCarrier)inventory;
                }
            }
            return ContainerUtil.carrierOrNull(inventory);
        }
        if (container instanceof ContainerHopper) {
            return ContainerUtil.carrierOrNull(((ContainerHopper)container).field_94538_a);
        }
        if (container instanceof ContainerDispenser) {
            return ContainerUtil.carrierOrNull(((ContainerDispenser)container).field_178146_a);
        }
        if (container instanceof ContainerFurnace) {
            return ContainerUtil.carrierOrNull(((ContainerFurnace)container).field_75158_e);
        }
        if (container instanceof ContainerBrewingStand) {
            return ContainerUtil.carrierOrNull(((ContainerBrewingStand)container).field_75188_e);
        }
        if (container instanceof ContainerBeacon) {
            return ContainerUtil.carrierOrNull(((ContainerBeacon)container).func_180611_e());
        }
        if (container instanceof ContainerHorseInventory) {
            return (Carrier)((ContainerHorseInventory)container).field_111242_f;
        }
        if (container instanceof ContainerMerchant && ((ContainerMerchant)container).field_75178_e instanceof Carrier) {
            return (Carrier)((ContainerMerchant)container).field_75178_e;
        }
        if (container instanceof ContainerPlayer && (player = ((ContainerPlayer)container).field_82862_h) instanceof EntityPlayerMP) {
            return (Carrier)player;
        }
        if (container instanceof net.minecraft.inventory.Container && (iterator = ((net.minecraft.inventory.Container)container).field_75151_b.iterator()).hasNext()) {
            final net.minecraft.inventory.Slot slot = (net.minecraft.inventory.Slot)iterator.next();
            if (slot.field_75224_c instanceof Carrier) {
                return (Carrier)slot.field_75224_c;
            }
            if (slot.field_75224_c instanceof TileEntity) {
                return new IMixinSingleBlockCarrier(){

                    @Override
                    public Location<World> getLocation() {
                        BlockPos pos = ((TileEntity)slot.field_75224_c).func_174877_v();
                        return new Location<World>((World)((TileEntity)slot.field_75224_c).func_145831_w(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    }

                    public CarriedInventory<?> getInventory() {
                        return (CarriedInventory)((Object)container);
                    }
                };
            }
            return null;
        }
        return null;
    }

    private static Carrier carrierOrNull(IInventory inventory) {
        if (inventory instanceof Carrier) {
            return (Carrier)inventory;
        }
        if (inventory instanceof CarriedInventory) {
            Optional carrier = ((CarriedInventory)inventory).getCarrier();
            return carrier.orElse(null);
        }
        return null;
    }

    public static Slot getSlot(net.minecraft.inventory.Container container, int slot) {
        return ((IMixinContainer)container).getContainerSlot(slot);
    }
}

