/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.collections;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.common.item.inventory.lens.DynamicLensCollection;
import org.spongepowered.common.item.inventory.lens.Lens;

public class DynamicLensCollectionImpl<TInventory, TStack>
extends AbstractList<Lens<TInventory, TStack>>
implements DynamicLensCollection<TInventory, TStack> {
    protected final Lens<TInventory, TStack>[] lenses;
    protected final Collection<InventoryProperty<?, ?>>[] properties;

    public DynamicLensCollectionImpl(int size) {
        this.lenses = new Lens[size];
        this.properties = new Collection[size];
    }

    @Override
    public void setProperty(Lens<TInventory, TStack> lens, InventoryProperty<?, ?> property) {
        this.setProperty(this.indexOf(lens), property);
    }

    @Override
    public void setProperty(int index, InventoryProperty<?, ?> property) {
        this.checkIndex(index);
        if (this.properties[index] == null) {
            this.properties[index] = new ArrayList();
        } else {
            this.removeMatchingProperties(index, property);
        }
        this.properties[index].add(property);
    }

    @Override
    public void removeProperty(Lens<TInventory, TStack> lens, InventoryProperty<?, ?> property) {
        this.removeProperty(this.indexOf(lens), property);
    }

    @Override
    public void removeProperty(int index, InventoryProperty<?, ?> property) {
        this.checkIndex(index);
        if (this.properties[index] != null) {
            this.removeMatchingProperties(index, property);
        }
    }

    private void removeMatchingProperties(int index, InventoryProperty<?, ?> property) {
        Iterator<InventoryProperty<?, ?>> iter = this.properties[index].iterator();
        while (iter.hasNext()) {
            InventoryProperty<?, ?> prop = iter.next();
            if (prop.getClass() != property.getClass() || !prop.getKey().equals(property.getKey())) continue;
            iter.remove();
        }
    }

    @Override
    public Lens<TInventory, TStack> get(int index) {
        return this.getLens(index);
    }

    @Override
    public Lens<TInventory, TStack> getLens(int index) {
        this.checkIndex(index);
        return this.lenses[index];
    }

    @Override
    public int size() {
        return this.lenses.length;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.lenses.length; ++i) {
                if (this.lenses[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.lenses.length; ++i) {
                if (!o.equals(this.lenses[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Collection<InventoryProperty<?, ?>> getProperties(int index) {
        this.checkIndex(index);
        if (this.properties[index] == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.properties[index]);
    }

    @Override
    public Collection<InventoryProperty<?, ?>> getProperties(Lens<TInventory, TStack> child) {
        int index = this.indexOf(child);
        if (index < 0) {
            return Collections.emptyList();
        }
        return this.getProperties(index);
    }

    @Override
    public boolean has(Lens<TInventory, TStack> lens) {
        return this.contains(lens);
    }

    @Override
    public boolean isSubsetOf(Collection<Lens<TInventory, TStack>> c) {
        return c.containsAll(this);
    }

    private void checkIndex(int index) {
        if (index >= this.lenses.length) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
    }
}

