/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;

public class ReusableLens<T extends Lens<IInventory, ItemStack>> {
    private static Map<Class<? extends InventoryAdapter>, Map<Class<? extends Lens<IInventory, ItemStack>>, Int2ObjectMap<ReusableLens>>> reusableLenses = new HashMap<Class<? extends InventoryAdapter>, Map<Class<? extends Lens<IInventory, ItemStack>>, Int2ObjectMap<ReusableLens>>>();
    private final SlotProvider<IInventory, ItemStack> slots;
    private final T lens;

    public ReusableLens(SlotProvider<IInventory, ItemStack> slots, T lens) {
        this.slots = slots;
        this.lens = lens;
    }

    public ReusableLens(SlotProvider<IInventory, ItemStack> slots, Function<SlotProvider<IInventory, ItemStack>, T> lensProvider) {
        this.slots = slots;
        this.lens = (Lens)lensProvider.apply(slots);
    }

    public static <T extends Lens<IInventory, ItemStack>> ReusableLens<T> getLens(Class<T> lensType, InventoryAdapter<IInventory, ItemStack> adapter, Supplier<SlotProvider<IInventory, ItemStack>> slots, Function<SlotProvider<IInventory, ItemStack>, T> lens) {
        Map adapterLenses = reusableLenses.computeIfAbsent(adapter.getClass(), k -> new HashMap());
        Int2ObjectMap lenses = adapterLenses.computeIfAbsent(lensType, k -> new Int2ObjectOpenHashMap());
        return (ReusableLens)lenses.computeIfAbsent((Object)adapter.getFabric().getSize(), k -> {
            SlotProvider sl = (SlotProvider)slots.get();
            return new ReusableLens((SlotProvider<IInventory, ItemStack>)sl, lens);
        });
    }

    public SlotProvider<IInventory, ItemStack> getSlots() {
        return this.slots;
    }

    public T getLens() {
        return this.lens;
    }
}

