/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.adapter.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.property.InventoryTitle;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TranslatableText;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.custom.CustomInventory;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public abstract class AdapterLogic {
    private AdapterLogic() {
    }

    public static <TInventory> Optional<ItemStack> pollSequential(InventoryAdapter<TInventory, net.minecraft.item.ItemStack> adapter) {
        return AdapterLogic.pollSequential(adapter.getFabric(), adapter.getRootLens());
    }

    public static <TInventory> Optional<ItemStack> pollSequential(Fabric<TInventory> inv, Lens<TInventory, net.minecraft.item.ItemStack> lens) {
        return AdapterLogic.findStack(inv, lens, true);
    }

    public static <TInventory> Optional<ItemStack> pollSequential(InventoryAdapter<TInventory, net.minecraft.item.ItemStack> adapter, int limit) {
        return AdapterLogic.pollSequential(adapter.getFabric(), adapter.getRootLens(), limit);
    }

    public static <TInventory> Optional<ItemStack> pollSequential(Fabric<TInventory> inv, Lens<TInventory, net.minecraft.item.ItemStack> lens, int limit) {
        return AdapterLogic.findStacks(inv, lens, limit, true);
    }

    public static <TInventory> Optional<ItemStack> peekSequential(InventoryAdapter<TInventory, net.minecraft.item.ItemStack> adapter) {
        return AdapterLogic.peekSequential(adapter.getFabric(), adapter.getRootLens());
    }

    public static <TInventory> Optional<ItemStack> peekSequential(Fabric<TInventory> inv, Lens<TInventory, net.minecraft.item.ItemStack> lens) {
        return AdapterLogic.findStack(inv, lens, false);
    }

    public static <TInventory> Optional<ItemStack> peekSequential(InventoryAdapter<TInventory, net.minecraft.item.ItemStack> adapter, int limit) {
        return AdapterLogic.peekSequential(adapter.getFabric(), adapter.getRootLens(), limit);
    }

    public static <TInventory> Optional<ItemStack> peekSequential(Fabric<TInventory> inv, Lens<TInventory, net.minecraft.item.ItemStack> lens, int limit) {
        return AdapterLogic.findStacks(inv, lens, limit, false);
    }

    private static <TInventory> Optional<ItemStack> findStack(Fabric<TInventory> inv, Lens<TInventory, net.minecraft.item.ItemStack> lens, boolean remove) {
        if (lens == null) {
            return Optional.empty();
        }
        for (int ord = 0; ord < lens.slotCount(); ++ord) {
            net.minecraft.item.ItemStack stack = lens.getStack(inv, ord);
            if (stack.func_190926_b() || remove && !lens.setStack(inv, ord, net.minecraft.item.ItemStack.field_190927_a)) continue;
            return ItemStackUtil.cloneDefensiveOptional(stack);
        }
        return Optional.empty();
    }

    private static <TInventory> Optional<ItemStack> findStacks(Fabric<TInventory> inv, Lens<TInventory, net.minecraft.item.ItemStack> lens, int limit, boolean remove) {
        if (lens == null) {
            return Optional.empty();
        }
        ItemStack result = null;
        for (int ord = 0; ord < lens.slotCount(); ++ord) {
            net.minecraft.item.ItemStack stack = lens.getStack(inv, ord);
            if (stack.func_190926_b() || stack.func_190916_E() < 1 || result != null && !result.getType().equals(stack.func_77973_b())) continue;
            if (result == null) {
                result = ItemStackUtil.cloneDefensive(stack, 0);
            }
            int pull = Math.min(stack.func_190916_E(), limit);
            result.setQuantity(result.getQuantity() + pull);
            limit -= pull;
            if (!remove) continue;
            if (pull >= stack.func_190916_E()) {
                lens.setStack(inv, ord, net.minecraft.item.ItemStack.field_190927_a);
                continue;
            }
            stack.func_190920_e(stack.func_190916_E() - pull);
        }
        return Optional.ofNullable(result);
    }

    public static <TInventory> InventoryTransactionResult insertSequential(InventoryAdapter<TInventory, net.minecraft.item.ItemStack> adapter, ItemStack stack) {
        return AdapterLogic.insertSequential(adapter.getFabric(), adapter.getRootLens(), stack);
    }

    public static <TInventory> InventoryTransactionResult insertSequential(Fabric<TInventory> inv, Lens<TInventory, net.minecraft.item.ItemStack> lens, ItemStack stack) {
        if (lens == null) {
            return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.FAILURE).reject(ItemStackUtil.cloneDefensive(stack)).build();
        }
        try {
            return AdapterLogic.insertStack(inv, lens, stack);
        }
        catch (Exception ex) {
            return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.ERROR).reject(ItemStackUtil.cloneDefensive(stack)).build();
        }
    }

    private static <TInventory> InventoryTransactionResult insertStack(Fabric<TInventory> inv, Lens<TInventory, net.minecraft.item.ItemStack> lens, ItemStack stack) {
        InventoryTransactionResult.Builder result = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS);
        net.minecraft.item.ItemStack nativeStack = ItemStackUtil.toNative(stack);
        int maxStackSize = Math.min(lens.getMaxStackSize(inv), nativeStack.func_77976_d());
        int remaining = stack.getQuantity();
        for (int ord = 0; ord < lens.slotCount() && remaining > 0; ++ord) {
            net.minecraft.item.ItemStack old = lens.getStack(inv, ord);
            int push = Math.min(remaining, maxStackSize);
            if (!lens.setStack(inv, ord, ItemStackUtil.cloneDefensiveNative(nativeStack, push))) continue;
            result.replace(ItemStackUtil.fromNative(old));
            remaining -= push;
        }
        if (remaining > 0) {
            result.reject(ItemStackUtil.cloneDefensive(nativeStack, remaining));
        }
        return result.build();
    }

    public static <TInventory> InventoryTransactionResult appendSequential(InventoryAdapter<TInventory, net.minecraft.item.ItemStack> adapter, ItemStack stack) {
        return AdapterLogic.appendSequential(adapter.getFabric(), adapter.getRootLens(), stack);
    }

    public static <TInventory> InventoryTransactionResult appendSequential(Fabric<TInventory> inv, Lens<TInventory, net.minecraft.item.ItemStack> lens, ItemStack stack) {
        InventoryTransactionResult.Builder result = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS);
        net.minecraft.item.ItemStack nativeStack = ItemStackUtil.toNative(stack);
        int maxStackSize = Math.min(lens.getMaxStackSize(inv), nativeStack.func_77976_d());
        int remaining = stack.getQuantity();
        for (int ord = 0; ord < lens.slotCount() && remaining > 0; ++ord) {
            net.minecraft.item.ItemStack old = lens.getStack(inv, ord);
            int push = Math.min(remaining, maxStackSize);
            if (old.func_190926_b() && lens.setStack(inv, ord, ItemStackUtil.cloneDefensiveNative(nativeStack, push))) {
                remaining -= push;
                continue;
            }
            if (old.func_190926_b() || !ItemStackUtil.compareIgnoreQuantity(old, stack)) continue;
            push = Math.max(Math.min(maxStackSize - old.func_190916_E(), remaining), 0);
            old.func_190920_e(old.func_190916_E() + push);
            remaining -= push;
        }
        if (remaining == stack.getQuantity()) {
            result.type(InventoryTransactionResult.Type.FAILURE).reject(ItemStackUtil.cloneDefensive(nativeStack));
        } else {
            stack.setQuantity(remaining);
        }
        return result.build();
    }

    public static <TInventory> int countStacks(InventoryAdapter<TInventory, net.minecraft.item.ItemStack> adapter) {
        return AdapterLogic.countStacks(adapter.getFabric(), adapter.getRootLens());
    }

    public static <TInventory> int countStacks(Fabric<TInventory> inv, Lens<TInventory, net.minecraft.item.ItemStack> lens) {
        int stacks = 0;
        for (int ord = 0; ord < lens.slotCount(); ++ord) {
            stacks += !lens.getStack(inv, ord).func_190926_b() ? 1 : 0;
        }
        return stacks;
    }

    public static <TInventory> int countItems(InventoryAdapter<TInventory, net.minecraft.item.ItemStack> adapter) {
        return AdapterLogic.countItems(adapter.getFabric(), adapter.getRootLens());
    }

    public static <TInventory> int countItems(Fabric<TInventory> inv, Lens<TInventory, net.minecraft.item.ItemStack> lens) {
        int items = 0;
        for (int ord = 0; ord < lens.slotCount(); ++ord) {
            net.minecraft.item.ItemStack stack = lens.getStack(inv, ord);
            items += !stack.func_190926_b() ? stack.func_190916_E() : 0;
        }
        return items;
    }

    public static <TInventory> int getCapacity(InventoryAdapter<TInventory, net.minecraft.item.ItemStack> adapter) {
        return AdapterLogic.getCapacity(adapter.getFabric(), adapter.getRootLens());
    }

    public static <TInventory> int getCapacity(Fabric<TInventory> inv, Lens<TInventory, net.minecraft.item.ItemStack> lens) {
        return lens.getSlots().size();
    }

    public static <TInventory> Collection<InventoryProperty<?, ?>> getProperties(InventoryAdapter<TInventory, net.minecraft.item.ItemStack> adapter, Inventory child, Class<? extends InventoryProperty<?, ?>> property) {
        return AdapterLogic.getProperties(adapter.getFabric(), adapter.getRootLens(), child, property);
    }

    public static <TInventory> Collection<InventoryProperty<?, ?>> getProperties(Fabric<TInventory> inv, Lens<TInventory, net.minecraft.item.ItemStack> lens, Inventory child, Class<? extends InventoryProperty<?, ?>> property) {
        if (child instanceof InventoryAdapter) {
            Preconditions.checkNotNull(property, (Object)"property");
            int index = lens.getChildren().indexOf(((InventoryAdapter)child).getRootLens());
            if (index > -1) {
                return lens.getProperties(index).stream().filter(prop -> property.equals(prop.getClass())).collect(Collectors.toCollection(ArrayList::new));
            }
        }
        return Collections.emptyList();
    }

    static <TInventory, T extends InventoryProperty<?, ?>> Collection<T> getRootProperties(InventoryAdapter<TInventory, net.minecraft.item.ItemStack> adapter, Class<T> property) {
        if ((adapter = AdapterLogic.inventoryRoot(adapter)) instanceof CustomInventory) {
            return ((CustomInventory)((Object)adapter)).getProperties().values().stream().filter(p -> property.equals(p.getClass())).map(property::cast).collect(Collectors.toList());
        }
        return Streams.stream(AdapterLogic.findRootProperty(adapter, property)).collect(Collectors.toList());
    }

    static <TInventory, T extends InventoryProperty<?, ?>> Optional<T> getRootProperty(InventoryAdapter<TInventory, net.minecraft.item.ItemStack> adapter, Class<T> property, Object key) {
        InventoryProperty<?, ?> forKey;
        if ((adapter = AdapterLogic.inventoryRoot(adapter)) instanceof CustomInventory && (forKey = ((CustomInventory)((Object)adapter)).getProperties().get(key)) != null && property.equals(forKey.getClass())) {
            return Optional.of(forKey);
        }
        return AdapterLogic.findRootProperty(adapter, property);
    }

    private static <TInventory, T extends InventoryProperty<?, ?>> Optional<T> findRootProperty(InventoryAdapter<TInventory, net.minecraft.item.ItemStack> adapter, Class<T> property) {
        if (property == InventoryTitle.class) {
            TranslatableText text = Text.of(adapter.getFabric().getDisplayName(), new Object[0]);
            return Optional.of(InventoryTitle.of(text));
        }
        return Optional.empty();
    }

    private static <TInventory> InventoryAdapter<TInventory, net.minecraft.item.ItemStack> inventoryRoot(InventoryAdapter<TInventory, net.minecraft.item.ItemStack> adapter) {
        Object first;
        if ((adapter = (InventoryAdapter)adapter.root()) instanceof Container && (first = adapter.getFabric().allInventories().iterator().next()) instanceof CustomInventory) {
            adapter = (InventoryAdapter)first;
        }
        return adapter;
    }

    public static <TInventory> boolean contains(InventoryAdapter<TInventory, net.minecraft.item.ItemStack> adapter, ItemStack stack) {
        return AdapterLogic.contains(adapter.getFabric(), adapter.getRootLens(), stack, stack.getQuantity());
    }

    public static <TInventory> boolean contains(InventoryAdapter<TInventory, net.minecraft.item.ItemStack> adapter, ItemStack stack, int quantity) {
        return AdapterLogic.contains(adapter.getFabric(), adapter.getRootLens(), stack, quantity);
    }

    public static <TInventory> boolean contains(Fabric<TInventory> inv, Lens<TInventory, net.minecraft.item.ItemStack> lens, ItemStack stack, int quantity) {
        net.minecraft.item.ItemStack nonNullStack = ItemStackUtil.toNative(stack);
        int found = 0;
        for (int ord = 0; ord < lens.slotCount(); ++ord) {
            net.minecraft.item.ItemStack slotStack = lens.getStack(inv, ord);
            if (!(slotStack.func_190926_b() ? nonNullStack.func_190926_b() && ++found >= quantity : ItemStackUtil.compareIgnoreQuantity(slotStack, stack) && (found += slotStack.func_190916_E()) >= quantity)) continue;
            return true;
        }
        return false;
    }

    public static <TInventory> boolean contains(InventoryAdapter<TInventory, net.minecraft.item.ItemStack> adapter, ItemType type) {
        return AdapterLogic.contains(adapter.getFabric(), adapter.getRootLens(), type);
    }

    public static <TInventory> boolean contains(Fabric<TInventory> inv, Lens<TInventory, net.minecraft.item.ItemStack> lens, ItemType type) {
        for (int ord = 0; ord < lens.slotCount(); ++ord) {
            net.minecraft.item.ItemStack slotStack = lens.getStack(inv, ord);
            if (!(slotStack.func_190926_b() ? type == null || type == ItemTypes.NONE : slotStack.func_77973_b() == type)) continue;
            return true;
        }
        return false;
    }
}

