/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.adapter.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.item.inventory.EmptyInventory;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.item.inventory.EmptyInventoryImpl;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.MinecraftInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.LensProvider;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.DefaultEmptyLens;
import org.spongepowered.common.item.inventory.lens.impl.DefaultIndexedLens;
import org.spongepowered.common.item.inventory.lens.impl.collections.SlotCollection;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;
import org.spongepowered.common.item.inventory.observer.InventoryEventArgs;
import org.spongepowered.common.text.translation.SpongeTranslation;

public class AbstractInventoryAdapter<TInventory>
implements MinecraftInventoryAdapter<TInventory> {
    public static final Translation DEFAULT_NAME = new SpongeTranslation("inventory.default.title");
    private EmptyInventory empty;
    @Nullable
    protected Inventory parent;
    protected Inventory next;
    protected final Fabric<TInventory> inventory;
    protected final SlotCollection<TInventory> slots;
    protected final Lens<TInventory, ItemStack> lens;
    protected final List<Inventory> children = new ArrayList<Inventory>();
    protected Iterable<Slot> slotIterator;

    public AbstractInventoryAdapter(Fabric<TInventory> inventory) {
        this(inventory, null, null);
    }

    public AbstractInventoryAdapter(Fabric<TInventory> inventory, @Nullable Lens<TInventory, ItemStack> root, @Nullable Inventory parent) {
        this.inventory = inventory;
        this.parent = parent == null ? this : parent;
        this.slots = this.initSlots(inventory, parent);
        this.lens = root != null ? root : (Lens)Preconditions.checkNotNull(this.initRootLens(), (Object)"root lens");
    }

    protected SlotCollection<TInventory> initSlots(Fabric<TInventory> inventory, @Nullable Inventory parent) {
        SlotProvider sp;
        if (parent instanceof MinecraftInventoryAdapter && (sp = ((MinecraftInventoryAdapter)parent).getSlotProvider()) instanceof SlotCollection) {
            return (SlotCollection)sp;
        }
        return new SlotCollection(inventory.getSize());
    }

    @Override
    public Inventory parent() {
        return this.parent;
    }

    @Override
    public <T extends Inventory> T first() {
        return (T)this.iterator().next();
    }

    @Override
    public <T extends Inventory> T next() {
        return (T)this.emptyInventory();
    }

    protected Lens<TInventory, ItemStack> initRootLens() {
        if (this instanceof LensProvider) {
            return ((LensProvider)((Object)this)).rootLens(this.inventory, this);
        }
        int size = this.inventory.getSize();
        if (size == 0) {
            return new DefaultEmptyLens(this);
        }
        return new DefaultIndexedLens<TInventory>(0, size, this, this.slots);
    }

    @Override
    public SlotProvider<TInventory, ItemStack> getSlotProvider() {
        return this.slots;
    }

    @Override
    public Lens<TInventory, ItemStack> getRootLens() {
        return this.lens;
    }

    @Override
    public Fabric<TInventory> getFabric() {
        return this.inventory;
    }

    @Override
    public Inventory getChild(int index) {
        if (index < 0 || index >= this.lens.getChildren().size()) {
            throw new IndexOutOfBoundsException("No child at index: " + index);
        }
        while (index >= this.children.size()) {
            this.children.add(null);
        }
        InventoryAdapter<TInventory, ItemStack> child = this.children.get(index);
        if (child == null) {
            child = this.lens.getChildren().get(index).getAdapter(this.inventory, this);
            this.children.set(index, child);
        }
        return child;
    }

    @Override
    public Inventory getChild(Lens<TInventory, ItemStack> lens) {
        return null;
    }

    @Override
    public void notify(Object source, InventoryEventArgs eventArgs) {
    }

    protected final EmptyInventory emptyInventory() {
        if (this.empty == null) {
            this.empty = new EmptyInventoryImpl(this);
        }
        return this.empty;
    }

    @Override
    public <T extends Inventory> Iterable<T> slots() {
        if (this.slotIterator == null) {
            this.slotIterator = this.slots.getIterator(this);
        }
        return this.slotIterator;
    }

    @Override
    public void clear() {
        this.slots().forEach(Inventory::clear);
    }

    public static Optional<Slot> forSlot(Fabric<IInventory> inv, SlotLens<IInventory, ItemStack> slotLens, Inventory parent) {
        return slotLens == null ? Optional.empty() : Optional.ofNullable((Slot)((Object)slotLens.getAdapter(inv, parent)));
    }

    @Override
    public PluginContainer getPlugin() {
        if (this.parent != this) {
            return this.parent.getPlugin();
        }
        return null;
    }
}

