/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.network.Packet;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.event.item.inventory.InteractInventoryEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

final class CloseWindowState
extends BasicPacketState {
    CloseWindowState() {
    }

    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, BasicPacketContext context) {
        context.openContainer(playerMP.field_71070_bA);
    }

    @Override
    public void unwind(BasicPacketContext context) {
        EntityPlayerMP player = context.getSource(EntityPlayerMP.class).get();
        Container container = context.getOpenContainer();
        ItemStackSnapshot lastCursor = context.getCursor();
        ItemStackSnapshot newCursor = ItemStackUtil.snapshotOf(player.field_71071_by.func_70445_o());
        if (lastCursor != null) {
            Sponge.getCauseStackManager().pushCause(player);
            InteractInventoryEvent.Close event = SpongeCommonEventFactory.callInteractInventoryCloseEvent(container, player, lastCursor, newCursor, true);
            if (event.isCancelled()) {
                Sponge.getCauseStackManager().popCause();
                return;
            }
            Sponge.getCauseStackManager().popCause();
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(player);
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
            context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
                List entities = items.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
                if (!entities.isEmpty()) {
                    DropItemEvent.Custom drop = SpongeEventFactory.createDropItemEventCustom(Sponge.getCauseStackManager().getCurrentCause(), entities);
                    SpongeImpl.postEvent(drop);
                    if (!drop.isCancelled()) {
                        for (Entity droppedItem : drop.getEntities()) {
                            droppedItem.setCreator(player.func_110124_au());
                            ((IMixinWorldServer)player.func_71121_q()).forceSpawnEntity(droppedItem);
                        }
                    }
                }
            });
            context.getCapturedItemStackSupplier().acceptAndClearIfNotEmpty(stacks -> {
                List items = stacks.stream().map(drop -> drop.create(player.func_71121_q())).collect(Collectors.toList());
                List entities = items.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
                if (!entities.isEmpty()) {
                    DropItemEvent.Custom drop2 = SpongeEventFactory.createDropItemEventCustom(Sponge.getCauseStackManager().getCurrentCause(), entities);
                    SpongeImpl.postEvent(drop2);
                    if (!drop2.isCancelled()) {
                        for (Entity droppedItem : drop2.getEntities()) {
                            droppedItem.setCreator(player.func_110124_au());
                            ((IMixinWorldServer)player.func_71121_q()).forceSpawnEntity(droppedItem);
                        }
                    }
                }
            });
        }
        context.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, this, context));
    }

    @Override
    public boolean doesCaptureEntityDrops() {
        return true;
    }
}

