/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.TrackingPhases;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.event.tracking.phase.general.GeneralState;
import org.spongepowered.common.event.tracking.phase.general.UnwindingPhaseContext;

final class PostState
extends GeneralState<UnwindingPhaseContext> {
    PostState() {
    }

    @Override
    public UnwindingPhaseContext createPhaseContext() {
        throw new UnsupportedOperationException("Use UnwindingPhaseContext#unwind(IPhaseState, PhaseContext)! Cannot create a context based on Post state!");
    }

    @Override
    public boolean canSwitchTo(IPhaseState state) {
        return state.getPhase() == TrackingPhases.GENERATION || state.getPhase() == TrackingPhases.PLUGIN || state == BlockPhase.State.RESTORING_BLOCKS || state == GeneralPhase.State.COMMAND || state == BlockPhase.State.BLOCK_DECAY;
    }

    @Override
    public boolean requiresPost() {
        return false;
    }

    @Override
    public boolean ignoresBlockUpdateTick(PhaseData phaseData) {
        return true;
    }

    @Override
    public boolean ignoresScheduledUpdates() {
        return true;
    }

    @Override
    public boolean alreadyCapturingEntitySpawns() {
        return true;
    }

    @Override
    public boolean alreadyCapturingEntityTicks() {
        return true;
    }

    @Override
    public boolean alreadyCapturingTileTicks() {
        return true;
    }

    @Override
    public boolean alreadyCapturingItemSpawns() {
        return true;
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, UnwindingPhaseContext context) {
        IPhaseState<?> phaseState = context.getUnwindingState();
        Object unwinding = context.getUnwindingContext();
        phaseState.appendContextPreExplosion(explosionContext, unwinding);
    }

    @Override
    public void associateNeighborStateNotifier(UnwindingPhaseContext context, BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
        IPhaseState<?> unwindingState = context.getUnwindingState();
        Object unwindingContext = context.getUnwindingContext();
        unwindingState.associateNeighborStateNotifier(unwindingContext, sourcePos, block, notifyPos, minecraftWorld, notifier);
    }

    @Override
    public void unwind(UnwindingPhaseContext context) {
        IPhaseState<?> unwindingState = context.getUnwindingState();
        Object unwindingContext = context.getUnwindingContext();
        this.postDispatch(unwindingState, (PhaseContext<?>)unwindingContext, context);
    }

    @Override
    public void postDispatch(IPhaseState<?> unwindingState, PhaseContext<?> unwindingContext, UnwindingPhaseContext postContext) {
        List<BlockSnapshot> contextBlocks = postContext.getCapturedBlocksOrEmptyList();
        List<Entity> contextEntities = postContext.getCapturedEntitiesOrEmptyList();
        List<EntityItem> contextItems = postContext.getCapturedItemsOrEmptyList();
        if (contextBlocks.isEmpty() && contextEntities.isEmpty() && contextItems.isEmpty()) {
            return;
        }
        if (!contextBlocks.isEmpty()) {
            ArrayList<BlockSnapshot> blockSnapshots = new ArrayList<BlockSnapshot>(contextBlocks);
            contextBlocks.clear();
            GeneralPhase.processBlockTransactionListsPost(postContext, blockSnapshots, this, unwindingContext);
        }
        if (!contextEntities.isEmpty()) {
            ArrayList<Entity> entities = new ArrayList<Entity>(contextEntities);
            contextEntities.clear();
            unwindingState.postProcessSpawns(unwindingContext, entities);
        }
        if (!contextItems.isEmpty()) {
            ArrayList<EntityItem> items = new ArrayList<EntityItem>(contextItems);
            contextItems.clear();
            TrackingUtil.splitAndSpawnEntities(items);
        }
    }

    @Override
    public boolean spawnEntityOrCapture(UnwindingPhaseContext context, Entity entity, int chunkX, int chunkZ) {
        return context.getCapturedEntities().add(entity);
    }
}

