/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.block.BlockPhaseState;
import org.spongepowered.common.event.tracking.phase.general.CommandPhaseContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralState;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;
import org.spongepowered.common.world.WorldManager;

final class CommandState
extends GeneralState<CommandPhaseContext> {
    CommandState() {
    }

    @Override
    public CommandPhaseContext createPhaseContext() {
        return new CommandPhaseContext(this);
    }

    @Override
    public boolean canSwitchTo(IPhaseState<?> state) {
        return state instanceof BlockPhaseState;
    }

    @Override
    public boolean tracksEntitySpecificDrops() {
        return true;
    }

    @Override
    public boolean ignoresItemPreMerging() {
        return true;
    }

    @Override
    public void associateNeighborStateNotifier(CommandPhaseContext context, BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
        context.getSource(Player.class).ifPresent(player -> ((IMixinChunk)minecraftWorld.func_175726_f(notifyPos)).setBlockNotifier(notifyPos, player.getUniqueId()));
    }

    @Override
    public void unwind(CommandPhaseContext phaseContext) {
        CommandSource sender = phaseContext.getSource(CommandSource.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be capturing a Command Sender, but none found!", phaseContext));
        phaseContext.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(list -> TrackingUtil.processBlockCaptures(list, this, phaseContext));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(sender);
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.PLACEMENT);
            phaseContext.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
                SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), entities);
                SpongeImpl.postEvent(spawnEntityEvent);
                if (!spawnEntityEvent.isCancelled()) {
                    boolean isPlayer = sender instanceof Player;
                    Player player = isPlayer ? (Player)sender : null;
                    for (org.spongepowered.api.entity.Entity entity : spawnEntityEvent.getEntities()) {
                        if (isPlayer) {
                            EntityUtil.toMixin(entity).setCreator(player.getUniqueId());
                        }
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                    }
                }
            });
        }
        frame = Sponge.getCauseStackManager().pushCauseFrame();
        var4_4 = null;
        try {
            Sponge.getCauseStackManager().pushCause(sender);
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.DROPPED_ITEM);
            phaseContext.getCapturedEntityDropSupplier().acceptIfNotEmpty(uuidItemStackMultimap -> {
                for (Map.Entry entry : uuidItemStackMultimap.asMap().entrySet()) {
                    Optional<org.spongepowered.api.entity.Entity> affectedEntity;
                    UUID key = (UUID)entry.getKey();
                    Entity foundEntity = null;
                    for (WorldServer worldServer : WorldManager.getWorlds()) {
                        Entity entityFromUuid = worldServer.func_175733_a(key);
                        if (entityFromUuid == null) continue;
                        foundEntity = entityFromUuid;
                        break;
                    }
                    if (!(affectedEntity = Optional.ofNullable((org.spongepowered.api.entity.Entity)foundEntity)).isPresent()) continue;
                    Collection itemStacks = (Collection)entry.getValue();
                    if (itemStacks.isEmpty()) {
                        return;
                    }
                    ArrayList items = new ArrayList();
                    items.addAll(itemStacks);
                    itemStacks.clear();
                    WorldServer minecraftWorld = EntityUtil.getMinecraftWorld(affectedEntity.get());
                    if (items.isEmpty()) continue;
                    List itemEntities = items.stream().map(data -> data.create(minecraftWorld)).map(EntityUtil::fromNative).collect(Collectors.toList());
                    Sponge.getCauseStackManager().pushCause(affectedEntity.get());
                    DropItemEvent.Destruct destruct = SpongeEventFactory.createDropItemEventDestruct(Sponge.getCauseStackManager().getCurrentCause(), itemEntities);
                    SpongeImpl.postEvent(destruct);
                    Sponge.getCauseStackManager().popCause();
                    if (destruct.isCancelled()) continue;
                    boolean isPlayer = sender instanceof Player;
                    Player player = isPlayer ? (Player)sender : null;
                    for (org.spongepowered.api.entity.Entity entity : destruct.getEntities()) {
                        if (isPlayer) {
                            EntityUtil.toMixin(entity).setCreator(player.getUniqueId());
                        }
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (frame != null) {
                if (var4_4 != null) {
                    try {
                        frame.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    frame.close();
                }
            }
        }
    }

    @Override
    public boolean spawnEntityOrCapture(CommandPhaseContext context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        return context.getCapturedEntities().add(entity);
    }
}

