/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.PhaseStack;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.TrackingPhase;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.event.tracking.phase.general.UnwindingPhaseContext;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;
import org.spongepowered.common.registry.type.world.BlockChangeFlagRegistryModule;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class PhaseTracker {
    private static final PhaseTracker INSTANCE = new PhaseTracker();
    private static final CopyOnWriteArrayList<net.minecraft.entity.Entity> ASYNC_CAPTURED_ENTITIES = new CopyOnWriteArrayList();
    private static final boolean CAPTURE_ENTITIES_ASYNC = SpongeImpl.getGlobalConfig().getConfig().getCauseTracker().captureEntitiesAsync();
    private static final Task ASYNC_TO_SYNC_SPAWNER = Task.builder().name("Sponge Async To Sync Entity Spawn Task").intervalTicks(1L).execute(() -> {
        if (ASYNC_CAPTURED_ENTITIES.isEmpty()) {
            return;
        }
        ArrayList<net.minecraft.entity.Entity> entities = new ArrayList<net.minecraft.entity.Entity>(ASYNC_CAPTURED_ENTITIES);
        ASYNC_CAPTURED_ENTITIES.removeAll(entities);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.FORCED);
            for (net.minecraft.entity.Entity entity : entities) {
                PhaseTracker.getInstance().spawnEntityWithCause((World)entity.func_130014_f_(), (Entity)entity);
            }
        }
    }).submit(SpongeImpl.getPlugin());
    public static final BiConsumer<PrettyPrinter, PhaseContext<?>> CONTEXT_PRINTER = (printer, context) -> context.printCustom((PrettyPrinter)printer);
    private static final BiConsumer<PrettyPrinter, PhaseData> PHASE_PRINTER = (printer, data) -> {
        printer.add("  - Phase: %s", data.state);
        printer.add("    Context:");
        data.context.printCustom((PrettyPrinter)printer);
    };
    private final PhaseStack stack = new PhaseStack();
    public final boolean isVerbose = SpongeImpl.getGlobalConfig().getConfig().getCauseTracker().isVerbose();
    public final boolean verboseErrors = SpongeImpl.getGlobalConfig().getConfig().getCauseTracker().verboseErrors();
    private boolean hasPrintedEmptyOnce = false;
    private boolean hasPrintedAboutRunnawayPhases = false;
    private boolean hasPrintedAsyncEntities = false;
    private final List<IPhaseState<?>> printedExceptionsForBlocks = new ArrayList();
    private final List<IPhaseState<?>> printedExceptionsForEntities = new ArrayList();
    private final List<Tuple<IPhaseState<?>, IPhaseState<?>>> completedIncorrectStates = new ArrayList();
    private final List<IPhaseState<?>> printedExceptionsForState = new ArrayList();

    public static PhaseTracker getInstance() {
        return (PhaseTracker)Preconditions.checkNotNull((Object)INSTANCE, (Object)"PhaseTracker instance was illegally set to null!");
    }

    void switchToPhase(IPhaseState<?> state, PhaseContext<?> phaseContext) {
        Preconditions.checkNotNull(state, (Object)"State cannot be null!");
        Preconditions.checkNotNull((Object)state.getPhase(), (Object)"Phase cannot be null!");
        Preconditions.checkNotNull(phaseContext, (Object)"PhaseContext cannot be null!");
        Preconditions.checkArgument((boolean)phaseContext.isComplete(), (Object)"PhaseContext must be complete!");
        IPhaseState<?> currentState = this.stack.peek().state;
        if (this.isVerbose) {
            if (this.stack.size() > 6 && !currentState.isExpectedForReEntrance()) {
                this.printRunawayPhase(state, phaseContext);
            }
            if (!currentState.canSwitchTo(state) && state != GeneralPhase.Post.UNWINDING && currentState == GeneralPhase.Post.UNWINDING) {
                this.printPhaseIncompatibility(currentState, state);
            }
        }
        this.stack.push(state, phaseContext);
    }

    public void printExceptionFromPhase(Throwable t) {
        this.printMessageWithCaughtException("Exception during phase body", "Something happened trying to run the main body of a phase", t);
    }

    public void completePhase(IPhaseState<?> prevState) {
        PhaseData currentPhaseData = this.stack.peek();
        IPhaseState<?> state = currentPhaseData.state;
        boolean isEmpty = this.stack.isEmpty();
        if (isEmpty) {
            this.printEmptyStackOnCompletion();
            return;
        }
        if (prevState != state) {
            this.printIncorrectPhaseCompletion(prevState, state);
            this.stack.pop();
        }
        if (this.isVerbose && this.stack.size() > 6 && state != GeneralPhase.Post.UNWINDING && !state.isExpectedForReEntrance()) {
            this.printRunnawayPhaseCompletion(state);
        }
        this.stack.pop();
        TrackingPhase phase = state.getPhase();
        PhaseContext<?> context = currentPhaseData.context;
        try (UnwindingPhaseContext unwinding = UnwindingPhaseContext.unwind(state, context);){
            try {
                state.unwind(context);
            }
            catch (Exception e) {
                this.printMessageWithCaughtException("Exception Exiting Phase", "Something happened when trying to unwind", state, context, e);
            }
        }
        catch (Exception e) {
            this.printMessageWithCaughtException("Exception Post Dispatching Phase", "Something happened when trying to post dispatch state", state, context, e);
        }
    }

    private void printRunnawayPhaseCompletion(IPhaseState<?> state) {
        if (!this.isVerbose && !this.hasPrintedAboutRunnawayPhases) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60);
        printer.add("Completing Phase").centre().hr();
        printer.addWrapped(60, "Detecting a runaway phase! Potentially a problem where something isn't completing a phase!!!", new Object[0]);
        printer.add();
        printer.addWrapped(60, "%s : %s", "Completing phase", state);
        printer.add(" Phases Remaining:");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        printer.add("Stacktrace:");
        printer.add(new Exception("Stack trace"));
        printer.add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        if (!this.isVerbose) {
            this.hasPrintedAboutRunnawayPhases = true;
        }
    }

    public void generateVersionInfo(PrettyPrinter printer) {
        for (PluginContainer pluginContainer : SpongeImpl.getInternalPlugins()) {
            pluginContainer.getVersion().ifPresent(version -> printer.add("%s : %s", pluginContainer.getName(), version));
        }
    }

    private void printIncorrectPhaseCompletion(IPhaseState<?> prevState, IPhaseState<?> state) {
        if (!this.isVerbose && !this.completedIncorrectStates.isEmpty()) {
            for (Tuple<IPhaseState<?>, IPhaseState<?>> tuple : this.completedIncorrectStates) {
                if (!tuple.getFirst().equals(prevState) || !tuple.getSecond().equals(state)) continue;
                return;
            }
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Completing incorrect phase").centre().hr().addWrapped("Sponge's tracking system is very dependent on knowing when a change to any world takes place, however, we are attempting to complete a \"phase\" other than the one we most recently entered. This is an error usually on Sponge's part, so a report is required on the issue tracker on GitHub.", new Object[0]).hr().add("Expected to exit phase: %s", prevState).add("But instead found phase: %s", state).add("StackTrace:").add(new Exception());
        printer.add(" Phases Remaining:");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        printer.add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        if (!this.isVerbose) {
            this.completedIncorrectStates.add(new Tuple(prevState, state));
        }
    }

    private void printEmptyStackOnCompletion() {
        if (!this.isVerbose && this.hasPrintedEmptyOnce) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Unexpectedly Completing An Empty Stack").centre().hr().addWrapped(60, "Sponge's tracking system is very dependent on knowing when a change to any world takes place, however, we have been told to complete a \"phase\" without having entered any phases. This is an error usually on Sponge's part, so a report is required on the issue tracker on GitHub.", new Object[0]).hr().add("StackTrace:").add(new Exception()).add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        if (!this.isVerbose) {
            this.hasPrintedEmptyOnce = true;
        }
    }

    private void printRunawayPhase(IPhaseState<?> state, PhaseContext<?> context) {
        if (!this.isVerbose && !this.hasPrintedAboutRunnawayPhases) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60);
        printer.add("Switching Phase").centre().hr();
        printer.addWrapped(60, "Detecting a runaway phase! Potentially a problem where something isn't completing a phase!!!", new Object[0]);
        printer.add("  %s : %s", "Entering Phase", state.getPhase());
        printer.add("  %s : %s", "Entering State", state);
        CONTEXT_PRINTER.accept(printer, context);
        printer.addWrapped(60, "%s :", "Phases remaining");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        printer.add("  %s :", "Printing stack trace").add(new Exception("Stack trace"));
        printer.add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        if (!this.isVerbose) {
            this.hasPrintedAboutRunnawayPhases = true;
        }
    }

    private void printPhaseIncompatibility(IPhaseState<?> currentState, IPhaseState<?> incompatibleState) {
        if (!this.isVerbose && !this.completedIncorrectStates.isEmpty()) {
            for (Tuple<IPhaseState<?>, IPhaseState<?>> tuple : this.completedIncorrectStates) {
                if (!tuple.getFirst().equals(currentState) || !tuple.getSecond().equals(incompatibleState)) continue;
                return;
            }
        }
        PrettyPrinter printer = new PrettyPrinter(60);
        printer.add("Switching Phase").centre().hr();
        printer.add("Phase incompatibility detected! Attempting to switch to an invalid phase!");
        printer.add("  %s : %s", "Current Phase", currentState.getPhase());
        printer.add("  %s : %s", "Current State", currentState);
        printer.add("  %s : %s", "Entering incompatible Phase", incompatibleState.getPhase());
        printer.add("  %s : %s", "Entering incompatible State", incompatibleState);
        printer.add("%s :", "Current phases");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        printer.add("  %s :", "Printing stack trace");
        printer.add(new Exception("Stack trace"));
        printer.add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        if (!this.isVerbose) {
            this.completedIncorrectStates.add(Tuple.of(currentState, incompatibleState));
        }
    }

    public void printMessageWithCaughtException(String header, String subHeader, Throwable e) {
        this.printMessageWithCaughtException(header, subHeader, this.getCurrentState(), this.getCurrentContext(), e);
    }

    private void printMessageWithCaughtException(String header, String subHeader, IPhaseState<?> state, PhaseContext<?> context, Throwable t) {
        PrettyPrinter printer = new PrettyPrinter(60);
        printer.add(header).centre().hr().add("%s %s", subHeader, state).addWrapped(60, "%s :", "PhaseContext");
        CONTEXT_PRINTER.accept(printer, context);
        printer.addWrapped(60, "%s :", "Phases remaining");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        printer.add("Stacktrace:").add(t);
        printer.add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
    }

    public void printExceptionFromPhase(Throwable e, PhaseContext<?> context) {
        if (!this.isVerbose && !this.printedExceptionsForState.isEmpty()) {
            for (IPhaseState<?> iPhaseState : this.printedExceptionsForState) {
                if (context.state != iPhaseState) continue;
                return;
            }
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Exception occurred during a PhaseState").centre().hr().addWrapped("Sponge's tracking system makes a best effort to not throw exceptions randomly but sometimes it is inevitable. In most cases, something else triggered this exception and Sponge prevented a crash by catching it. The following stacktrace can be used to help pinpoint the cause.", new Object[0]).hr().add("The PhaseState having an exception: %s", context.state).add("The PhaseContext:");
        printer.add(context.printCustom(printer));
        printer.hr().add("StackTrace:").add(e);
        printer.add(" Phases Remaining:");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        printer.add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        if (!this.isVerbose) {
            this.printedExceptionsForState.add(context.state);
        }
    }

    private void printBlockTrackingException(PhaseData phaseData, IPhaseState<?> phaseState, Throwable e) {
        if (!this.isVerbose && !this.printedExceptionsForBlocks.isEmpty() && this.printedExceptionsForBlocks.contains(phaseState)) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Exception attempting to capture a block change!").centre().hr();
        printer.addWrapped(60, "%s :", "PhaseContext");
        CONTEXT_PRINTER.accept(printer, phaseData.context);
        printer.addWrapped(60, "%s :", "Phases remaining");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        printer.add("Stacktrace:");
        printer.add(e);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        if (!this.isVerbose) {
            this.printedExceptionsForBlocks.add(phaseState);
        }
    }

    private void printUnexpectedBlockChange() {
        if (!this.isVerbose) {
            return;
        }
        new PrettyPrinter(60).add("Unexpected World Change Detected!").centre().hr().add("Sponge's tracking system is very dependent on knowing when\na change to any world takes place, however there are chances\nwhere Sponge does not know of changes that mods may perform.\nIn cases like this, it is best to report to Sponge to get this\nchange tracked correctly and accurately.").hr().add("StackTrace:").add(new Exception()).trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
    }

    private void printExceptionSpawningEntity(PhaseContext<?> context, Throwable e) {
        if (!this.isVerbose && !this.printedExceptionsForEntities.isEmpty() && this.printedExceptionsForEntities.contains(context.state)) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Exception attempting to capture or spawn an Entity!").centre().hr();
        printer.addWrapped(60, "%s :", "PhaseContext");
        CONTEXT_PRINTER.accept(printer, context);
        printer.addWrapped(60, "%s :", "Phases remaining");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        printer.add("Stacktrace:");
        printer.add(e);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        if (!this.isVerbose) {
            this.printedExceptionsForEntities.add(context.state);
        }
    }

    String dumpStack() {
        if (this.stack.isEmpty()) {
            return "[Empty stack]";
        }
        PrettyPrinter printer = new PrettyPrinter(40);
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        printer.print(new PrintStream(stream));
        return stream.toString();
    }

    public PhaseData getCurrentPhaseData() {
        return this.stack.peek();
    }

    public IPhaseState<?> getCurrentState() {
        return this.stack.peekState();
    }

    public PhaseContext<?> getCurrentContext() {
        return this.stack.peekContext();
    }

    public void notifyBlockOfStateChange(IMixinWorldServer mixinWorld, BlockPos notifyPos, Block sourceBlock, @Nullable BlockPos sourcePos) {
        IBlockState iblockstate = ((WorldServer)mixinWorld).func_180495_p(notifyPos);
        try {
            PhaseData peek = this.stack.peek();
            IPhaseState<?> state = peek.state;
            state.associateNeighborStateNotifier(peek.context, sourcePos, iblockstate.func_177230_c(), notifyPos, (WorldServer)mixinWorld, PlayerTracker.Type.NOTIFIER);
            iblockstate.func_189546_a((net.minecraft.world.World)((WorldServer)mixinWorld), notifyPos, sourceBlock, sourcePos);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Exception while updating neighbours");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being updated");
            crashreportcategory.func_189529_a("Source block type", () -> {
                try {
                    return String.format("ID #%d (%s // %s)", Block.func_149682_b((Block)sourceBlock), sourceBlock.func_149739_a(), sourceBlock.getClass().getCanonicalName());
                }
                catch (Throwable var2) {
                    return "ID #" + Block.func_149682_b((Block)sourceBlock);
                }
            });
            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)notifyPos, (IBlockState)iblockstate);
            throw new ReportedException(crashreport);
        }
    }

    public boolean setBlockState(IMixinWorldServer mixinWorld, BlockPos pos, IBlockState newState, int flags) {
        return this.setBlockState(mixinWorld, pos, newState, BlockChangeFlagRegistryModule.fromNativeInt(flags));
    }

    public boolean setBlockState(IMixinWorldServer mixinWorld, BlockPos pos, IBlockState newState, BlockChangeFlag flag) {
        boolean isComplete;
        SpongeBlockChangeFlag spongeFlag = (SpongeBlockChangeFlag)flag;
        WorldServer minecraftWorld = mixinWorld.asMinecraftWorld();
        Chunk chunk = minecraftWorld.func_175726_f(pos);
        if (chunk.func_76621_g()) {
            return false;
        }
        Block block = newState.func_177230_c();
        IBlockState currentState = chunk.func_177435_g(pos);
        if (currentState == newState) {
            return false;
        }
        PhaseData phaseData = this.stack.peek();
        IPhaseState<?> phaseState = phaseData.state;
        boolean bl = isComplete = phaseState == GeneralPhase.State.COMPLETE;
        if (this.isVerbose && isComplete) {
            this.printUnexpectedBlockChange();
        }
        if (phaseState.requiresBlockCapturing()) {
            try {
                return TrackingUtil.trackBlockChange(this, mixinWorld, chunk, currentState, newState, pos, flag, phaseData.context, phaseState);
            }
            catch (Exception | NoClassDefFoundError e) {
                this.printBlockTrackingException(phaseData, phaseState, e);
                return false;
            }
        }
        IBlockState iblockstate = chunk.func_177436_a(pos, newState);
        if (iblockstate == null) {
            return false;
        }
        if (newState.func_185891_c() != iblockstate.func_185891_c() || newState.func_185906_d() != iblockstate.func_185906_d()) {
            minecraftWorld.func_175664_x(pos);
        }
        if (spongeFlag.isNotifyClients() && chunk.func_150802_k()) {
            minecraftWorld.func_184138_a(pos, iblockstate, newState, spongeFlag.getRawFlag());
        }
        if (spongeFlag.updateNeighbors()) {
            minecraftWorld.func_175722_b(pos, iblockstate.func_177230_c(), true);
            if (newState.func_185912_n()) {
                minecraftWorld.func_175666_e(pos, block);
            }
        } else if (!minecraftWorld.field_72995_K && spongeFlag.notifyObservers()) {
            minecraftWorld.func_190522_c(pos, block);
        }
        return true;
    }

    public boolean spawnEntity(World world, Entity entity) {
        EntityThrowable throwable;
        EntityLivingBase thrower;
        boolean isForced;
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null!");
        if (((IMixinEntity)entity).isInConstructPhase()) {
            ((IMixinEntity)entity).firePostConstructEvents();
        }
        net.minecraft.entity.Entity minecraftEntity = EntityUtil.toNative(entity);
        WorldServer minecraftWorld = (WorldServer)world;
        IMixinWorldServer mixinWorldServer = (IMixinWorldServer)minecraftWorld;
        PhaseData phaseData = this.stack.peek();
        IPhaseState<?> phaseState = phaseData.state;
        PhaseContext<?> context = phaseData.context;
        boolean bl = isForced = minecraftEntity.field_98038_p || minecraftEntity instanceof EntityPlayer;
        if (!isForced && !phaseState.allowEntitySpawns()) {
            return false;
        }
        int chunkX = MathHelper.func_76128_c((double)(minecraftEntity.field_70165_t / 16.0));
        int chunkZ = MathHelper.func_76128_c((double)(minecraftEntity.field_70161_v / 16.0));
        if (!isForced && !mixinWorldServer.isMinecraftChunkLoaded(chunkX, chunkZ, true)) {
            return false;
        }
        if (minecraftEntity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)minecraftEntity;
            minecraftWorld.field_73010_i.add(entityplayer);
            minecraftWorld.func_72854_c();
            SpongeImplHooks.firePlayerJoinSpawnEvent((EntityPlayerMP)entityplayer);
        } else if (minecraftEntity instanceof IEntityOwnable) {
            IEntityOwnable ownable = (IEntityOwnable)entity;
            net.minecraft.entity.Entity owner = ownable.func_70902_q();
            if (owner != null && owner instanceof EntityPlayer) {
                context.owner = (User)owner;
                entity.setCreator(ownable.func_184753_b());
            }
        } else if (minecraftEntity instanceof EntityThrowable && (thrower = (throwable = (EntityThrowable)minecraftEntity).func_85052_h()) != null) {
            User user = null;
            user = !(thrower instanceof EntityPlayer) ? (User)((IMixinEntity)thrower).getCreatorUser().orElse(null) : (User)thrower;
            if (user != null) {
                context.owner = user;
                entity.setCreator(user.getUniqueId());
            }
        }
        if (!isForced) {
            try {
                return phaseState.spawnEntityOrCapture(context, entity, chunkX, chunkZ);
            }
            catch (Exception | NoClassDefFoundError e) {
                this.printExceptionSpawningEntity(context, e);
                return false;
            }
        }
        minecraftWorld.func_72964_e(chunkX, chunkZ).func_76612_a(minecraftEntity);
        minecraftWorld.field_72996_f.add(minecraftEntity);
        mixinWorldServer.onSpongeEntityAdded(minecraftEntity);
        return true;
    }

    public boolean spawnEntityWithCause(World world, Entity entity) {
        boolean isForced;
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null!");
        if (((IMixinEntity)entity).isInConstructPhase()) {
            ((IMixinEntity)entity).firePostConstructEvents();
        }
        net.minecraft.entity.Entity minecraftEntity = EntityUtil.toNative(entity);
        WorldServer worldServer = (WorldServer)world;
        IMixinWorldServer mixinWorldServer = (IMixinWorldServer)worldServer;
        int chunkX = MathHelper.func_76128_c((double)(minecraftEntity.field_70165_t / 16.0));
        int chunkZ = MathHelper.func_76128_c((double)(minecraftEntity.field_70161_v / 16.0));
        boolean bl = isForced = minecraftEntity.field_98038_p || minecraftEntity instanceof EntityPlayer;
        if (!isForced && !mixinWorldServer.isMinecraftChunkLoaded(chunkX, chunkZ, true)) {
            return false;
        }
        ArrayList<Entity> entities = new ArrayList<Entity>(1);
        entities.add(entity);
        SpawnEntityEvent.Custom event = SpongeEventFactory.createSpawnEntityEventCustom(Sponge.getCauseStackManager().getCurrentCause(), entities);
        SpongeImpl.postEvent(event);
        if (entity instanceof EntityPlayer || !event.isCancelled()) {
            mixinWorldServer.forceSpawnEntity(entity);
        }
        return true;
    }

    public static boolean validateEntitySpawn(IMixinWorldServer mixinWorldServer, Entity entity) {
        if (Sponge.isServerAvailable() && Sponge.getServer().isMainThread()) {
            return true;
        }
        if (!CAPTURE_ENTITIES_ASYNC) {
            if (!PhaseTracker.getInstance().isVerbose) {
                return false;
            }
            if (!PhaseTracker.getInstance().verboseErrors && PhaseTracker.getInstance().hasPrintedAsyncEntities) {
                return false;
            }
            new PrettyPrinter(60).add("Async Entity Spawn Warning").centre().hr().add("An entity was attempting to spawn off the \"main\" server thread").add().add("Details of the spawning are disabled according to the Sponge").add("configuration file. A stack trace of the attempted spawn should").add("provide information about how it was being spawned. Sponge is").add("currently configured to NOT attempt to capture this spawn and").add("spawn the entity at an appropriate time, while on the main server").add("thread.").add().add("Details of the spawn:").add("%s : %s", "Entity", entity).add("Stacktrace").add(new Exception("Async entity spawn attempt")).trace(SpongeImpl.getLogger(), Level.WARN);
            PhaseTracker.getInstance().hasPrintedAsyncEntities = true;
            return false;
        }
        ASYNC_CAPTURED_ENTITIES.add((net.minecraft.entity.Entity)entity);
        if (!PhaseTracker.getInstance().isVerbose) {
            return false;
        }
        if (!PhaseTracker.getInstance().verboseErrors && PhaseTracker.getInstance().hasPrintedAsyncEntities) {
            return false;
        }
        new PrettyPrinter(60).add("Async Entity Spawn Warning").centre().hr().add("An entity was attempting to spawn off the \"main\" server thread").add().add("Delayed spawning is ENABLED for Sponge.").add("The entity is safely captured by Sponge while off the main").add("server thread, and therefore will be spawned the next tick.").add("Some cases where a mod is expecting the entity back while").add("async can cause issues with said mod.").add().add("Details of the spawn:").add("%s : %s", "Entity", entity).add("Stacktrace").add(new Exception("Async entity spawn attempt")).trace(SpongeImpl.getLogger(), Level.WARN);
        PhaseTracker.getInstance().hasPrintedAsyncEntities = true;
        return false;
    }
}

