/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.TrackingPhase;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.BlockTickContext;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.block.IMixinBlockEventData;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.world.BlockChange;

public interface IPhaseState<C extends PhaseContext<C>> {
    public TrackingPhase getPhase();

    public C createPhaseContext();

    default public boolean canSwitchTo(IPhaseState<?> state) {
        return false;
    }

    public void unwind(C var1);

    default public void postDispatch(IPhaseState<?> unwindingState, PhaseContext<?> unwindingContext, C postContext) {
    }

    default public boolean spawnEntityOrCapture(C context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        User user = ((PhaseContext)context).getNotifier().orElseGet(() -> context.getOwner().orElse(null));
        if (user != null) {
            entity.setCreator(user.getUniqueId());
        }
        ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
        entities.add(entity);
        SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), entities);
        SpongeImpl.postEvent(event);
        if (!event.isCancelled() && event.getEntities().size() > 0) {
            for (org.spongepowered.api.entity.Entity item : event.getEntities()) {
                ((IMixinWorldServer)((Object)item.getWorld())).forceSpawnEntity(item);
            }
            return true;
        }
        return false;
    }

    default public boolean ignoresBlockTracking() {
        return false;
    }

    default public void handleBlockChangeWithUser(@Nullable BlockChange blockChange, Transaction<BlockSnapshot> snapshotTransaction, C context) {
    }

    default public boolean tracksBlockSpecificDrops() {
        return false;
    }

    default public boolean tracksEntitySpecificDrops() {
        return false;
    }

    default public boolean ignoresEntityCollisions() {
        return false;
    }

    default public boolean isExpectedForReEntrance() {
        return false;
    }

    default public boolean tracksEntityDeaths() {
        return false;
    }

    default public boolean shouldCaptureBlockChangeOrSkip(C phaseContext, BlockPos pos) {
        return true;
    }

    default public boolean isInteraction() {
        return false;
    }

    default public void postTrackBlock(BlockSnapshot snapshot, PhaseTracker tracker, C context) {
    }

    default public boolean requiresBlockPosTracking() {
        return false;
    }

    default public boolean isTicking() {
        return false;
    }

    default public boolean handlesOwnStateCompletion() {
        return false;
    }

    default public Optional<DamageSource> createDestructionDamageSource(PhaseContext<?> context, Entity entity) {
        return Optional.empty();
    }

    default public void associateAdditionalCauses(IPhaseState<?> state, PhaseContext<?> context) {
    }

    default public boolean doesCaptureEntityDrops() {
        return false;
    }

    default public boolean requiresPost() {
        return true;
    }

    default public boolean ignoresBlockUpdateTick(PhaseData phaseData) {
        return false;
    }

    default public boolean allowEntitySpawns() {
        return true;
    }

    default public boolean ignoresBlockEvent() {
        return false;
    }

    default public boolean ignoresScheduledUpdates() {
        return false;
    }

    default public boolean alreadyCapturingBlockTicks(C context) {
        return false;
    }

    default public boolean requiresBlockCapturing() {
        return true;
    }

    default public void postProcessSpawns(C unwindingContext, ArrayList<org.spongepowered.api.entity.Entity> entities) {
        User creator = ((PhaseContext)unwindingContext).getNotifier().orElseGet(() -> unwindingContext.getOwner().orElse(null));
        TrackingUtil.splitAndSpawnEntities(entities, entity -> {
            if (creator != null) {
                entity.setCreator(creator.getUniqueId());
            }
        });
    }

    default public boolean alreadyCapturingEntitySpawns() {
        return false;
    }

    default public boolean alreadyCapturingEntityTicks() {
        return false;
    }

    default public boolean alreadyCapturingTileTicks() {
        return false;
    }

    default public boolean isWorldGeneration() {
        return false;
    }

    default public boolean alreadyCapturingItemSpawns() {
        return false;
    }

    default public boolean ignoresItemPreMerging() {
        return false;
    }

    default public void appendNotifierPreBlockTick(IMixinWorldServer mixinWorld, BlockPos pos, C context, BlockTickContext phaseContext) {
        Chunk chunk = mixinWorld.asMinecraftWorld().func_175726_f(pos);
        IMixinChunk mixinChunk = (IMixinChunk)chunk;
        if (chunk != null && !chunk.func_76621_g()) {
            mixinChunk.getBlockOwner(pos).ifPresent(phaseContext::owner);
            mixinChunk.getBlockNotifier(pos).ifPresent(phaseContext::notifier);
        }
    }

    default public void capturePlayerUsingStackToBreakBlock(ItemStack itemStack, EntityPlayerMP playerIn, C context) {
    }

    default public void addNotifierToBlockEvent(C context, IMixinWorldServer mixinWorldServer, BlockPos pos, IMixinBlockEventData blockEvent) {
    }

    default public void associateNeighborStateNotifier(C unwindingContext, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
    }

    default public void appendContextPreExplosion(ExplosionContext explosionContext, C currentPhaseData) {
    }
}

