/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableJoinData;
import org.spongepowered.api.data.manipulator.mutable.entity.JoinData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeJoinData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.world.storage.SpongePlayerDataHandler;

public class JoinDataProcessor
extends AbstractEntityDataProcessor<EntityPlayer, JoinData, ImmutableJoinData> {
    public JoinDataProcessor() {
        super(EntityPlayer.class);
    }

    @Override
    protected boolean doesDataExist(EntityPlayer dataHolder) {
        return true;
    }

    @Override
    protected boolean set(EntityPlayer dataHolder, Map<Key<?>, Object> keyValues) {
        UUID uuid = dataHolder.func_110124_au();
        Instant instant = (Instant)keyValues.get(Keys.FIRST_DATE_PLAYED);
        Instant played = (Instant)keyValues.get(Keys.LAST_DATE_PLAYED);
        SpongePlayerDataHandler.setPlayerInfo(uuid, instant, played);
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityPlayer dataHolder) {
        UUID uuid = dataHolder.func_110124_au();
        Instant first = SpongePlayerDataHandler.getFirstJoined(uuid).get();
        Instant played = SpongePlayerDataHandler.getLastPlayed(uuid).get();
        return ImmutableMap.of(Keys.FIRST_DATE_PLAYED, (Object)first, Keys.LAST_DATE_PLAYED, (Object)played);
    }

    @Override
    protected JoinData createManipulator() {
        return new SpongeJoinData();
    }

    @Override
    public Optional<JoinData> fill(DataContainer container, JoinData joinData) {
        if (!container.contains(Keys.FIRST_DATE_PLAYED, Keys.LAST_DATE_PLAYED)) {
            return Optional.empty();
        }
        long joined = container.getLong(Keys.FIRST_DATE_PLAYED.getQuery()).get();
        long played = container.getLong(Keys.LAST_DATE_PLAYED.getQuery()).get();
        joinData.set(Keys.FIRST_DATE_PLAYED, Instant.ofEpochMilli(joined));
        joinData.set(Keys.LAST_DATE_PLAYED, Instant.ofEpochMilli(played));
        return Optional.of(joinData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

