/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.tileentity;

import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.tileentity.ImmutableBeaconData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.BeaconData;
import org.spongepowered.api.data.value.immutable.ImmutableOptionalValue;
import org.spongepowered.api.effect.potion.PotionEffectType;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.tileentity.SpongeBeaconData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeOptionalValue;

public class ImmutableSpongeBeaconData
extends AbstractImmutableData<ImmutableBeaconData, BeaconData>
implements ImmutableBeaconData {
    @Nullable
    private final PotionEffectType primaryEffect;
    @Nullable
    private final PotionEffectType secondaryEffect;
    private final ImmutableOptionalValue<PotionEffectType> primaryEffectValue;
    private final ImmutableOptionalValue<PotionEffectType> secondaryEffectValue;

    public ImmutableSpongeBeaconData(@Nullable PotionEffectType primaryEffect, @Nullable PotionEffectType secondaryEffect) {
        super(ImmutableBeaconData.class);
        this.primaryEffect = primaryEffect;
        this.secondaryEffect = secondaryEffect;
        this.primaryEffectValue = new ImmutableSpongeOptionalValue<PotionEffectType>(Keys.BEACON_PRIMARY_EFFECT, Optional.ofNullable(this.primaryEffect));
        this.secondaryEffectValue = new ImmutableSpongeOptionalValue<PotionEffectType>(Keys.BEACON_SECONDARY_EFFECT, Optional.ofNullable(this.secondaryEffect));
        this.registerGetters();
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.BEACON_PRIMARY_EFFECT, this::getPrimaryEffect);
        this.registerKeyValue(Keys.BEACON_PRIMARY_EFFECT, this::primaryEffect);
        this.registerFieldGetter(Keys.BEACON_SECONDARY_EFFECT, this::getSecondaryEffect);
        this.registerKeyValue(Keys.BEACON_SECONDARY_EFFECT, this::secondaryEffect);
    }

    public Optional<PotionEffectType> getPrimaryEffect() {
        return Optional.ofNullable(this.primaryEffect);
    }

    @Override
    public ImmutableOptionalValue<PotionEffectType> primaryEffect() {
        return this.primaryEffectValue;
    }

    public Optional<PotionEffectType> getSecondaryEffect() {
        return Optional.ofNullable(this.secondaryEffect);
    }

    @Override
    public ImmutableOptionalValue<PotionEffectType> secondaryEffect() {
        return this.secondaryEffectValue;
    }

    @Override
    public ImmutableBeaconData clearEffects() {
        return new ImmutableSpongeBeaconData(null, null);
    }

    @Override
    public BeaconData asMutable() {
        return new SpongeBeaconData(this.primaryEffect, this.secondaryEffect);
    }

    @Override
    public DataContainer toContainer() {
        DataContainer dataContainer = super.toContainer();
        if (this.primaryEffect != null) {
            dataContainer = dataContainer.set(Keys.BEACON_PRIMARY_EFFECT.getQuery(), (Object)this.primaryEffect.getId());
        }
        if (this.secondaryEffect != null) {
            dataContainer = dataContainer.set(Keys.BEACON_SECONDARY_EFFECT.getQuery(), (Object)this.secondaryEffect.getId());
        }
        return dataContainer;
    }
}

