/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableInvisibilityData;
import org.spongepowered.api.data.manipulator.mutable.entity.InvisibilityData;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeInvisibilityData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public class ImmutableSpongeInvisibilityData
extends AbstractImmutableData<ImmutableInvisibilityData, InvisibilityData>
implements ImmutableInvisibilityData {
    private final boolean vanish;
    private final boolean collision;
    private final boolean untargetable;
    private final boolean invisible;
    private ImmutableValue<Boolean> invisibleValue;
    private ImmutableValue<Boolean> vanishValue;
    private ImmutableValue<Boolean> collisionValue;
    private ImmutableValue<Boolean> untargetableValue;

    public ImmutableSpongeInvisibilityData(boolean vanish, boolean collision, boolean untargetable, boolean invisible) {
        super(ImmutableInvisibilityData.class);
        this.vanish = vanish;
        this.collision = collision;
        this.untargetable = untargetable;
        this.invisible = invisible;
        this.invisibleValue = ImmutableSpongeValue.cachedOf(Keys.INVISIBLE, false, this.invisible);
        this.vanishValue = ImmutableSpongeValue.cachedOf(Keys.VANISH, false, this.vanish);
        this.collisionValue = ImmutableSpongeValue.cachedOf(Keys.VANISH_IGNORES_COLLISION, false, this.collision);
        this.untargetableValue = ImmutableSpongeValue.cachedOf(Keys.VANISH_PREVENTS_TARGETING, false, this.untargetable);
    }

    @Override
    public ImmutableValue<Boolean> invisible() {
        return this.invisibleValue;
    }

    @Override
    public ImmutableValue<Boolean> vanish() {
        return this.vanishValue;
    }

    @Override
    public ImmutableValue<Boolean> ignoresCollisionDetection() {
        return this.collisionValue;
    }

    @Override
    public ImmutableValue<Boolean> untargetable() {
        return this.untargetableValue;
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.VANISH, this::isVanish);
        this.registerKeyValue(Keys.VANISH, this::vanish);
        this.registerFieldGetter(Keys.VANISH_IGNORES_COLLISION, this::isCollision);
        this.registerKeyValue(Keys.VANISH_IGNORES_COLLISION, this::ignoresCollisionDetection);
        this.registerFieldGetter(Keys.VANISH_PREVENTS_TARGETING, this::isUntargetable);
        this.registerKeyValue(Keys.VANISH_PREVENTS_TARGETING, this::untargetable);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.INVISIBLE, (Object)this.invisible).set(Keys.VANISH, (Object)this.vanish).set(Keys.VANISH_IGNORES_COLLISION, (Object)this.collision).set(Keys.VANISH_PREVENTS_TARGETING, (Object)this.untargetable);
    }

    @Override
    public int getContentVersion() {
        return 2;
    }

    private boolean isVanish() {
        return this.vanish;
    }

    private boolean isCollision() {
        return this.collision;
    }

    private boolean isUntargetable() {
        return this.untargetable;
    }

    @Override
    public InvisibilityData asMutable() {
        return new SpongeInvisibilityData(this.vanish, this.collision, this.untargetable, this.invisible);
    }
}

