/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.block.tileentity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.BlockJukebox;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntityComparator;
import net.minecraft.tileentity.TileEntityDaylightDetector;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityDropper;
import net.minecraft.tileentity.TileEntityEnchantmentTable;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.common.data.util.DataQueries;

public abstract class AbstractTileBuilder<T extends org.spongepowered.api.block.tileentity.TileEntity>
extends AbstractDataBuilder<T>
implements DataBuilder<T> {
    private static final Map<Class<? extends TileEntity>, BlockType> classToTypeMap = Maps.newHashMap();

    protected AbstractTileBuilder(Class<T> clazz, int version) {
        super(clazz, version);
    }

    @Override
    protected Optional<T> buildContent(DataView container) throws InvalidDataException {
        Preconditions.checkNotNull((Object)container);
        if (!container.contains(DataQueries.TILE_TYPE, DataQueries.WORLD, Queries.POSITION_X, Queries.POSITION_Y, Queries.POSITION_Z)) {
            return Optional.empty();
        }
        String worldName = container.getString(DataQueries.WORLD).get();
        Optional<org.spongepowered.api.world.World> worldOptional = Sponge.getGame().getServer().getWorld(worldName);
        if (!worldOptional.isPresent()) {
            throw new InvalidDataException("The provided container references a world that does not exist!");
        }
        Class clazz = (Class)TileEntity.field_190562_f.func_82594_a((Object)new ResourceLocation(container.getString(DataQueries.TILE_TYPE).get()));
        if (clazz == null) {
            return Optional.empty();
        }
        BlockType type = classToTypeMap.get(clazz);
        if (type == null) {
            return Optional.empty();
        }
        int x = container.getInt(DataQueries.X_POS).get();
        int y = container.getInt(DataQueries.Y_POS).get();
        int z = container.getInt(DataQueries.Z_POS).get();
        worldOptional.get().getLocation(x, y, z).setBlockType(type);
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity tileEntity = ((World)worldOptional.get()).func_175625_s(pos);
        if (tileEntity == null) {
            return Optional.empty();
        }
        tileEntity.func_145843_s();
        return Optional.of((org.spongepowered.api.block.tileentity.TileEntity)tileEntity);
    }

    private static void addBlockMapping(Class<? extends TileEntity> tileClass, BlockType blocktype) {
        classToTypeMap.put(tileClass, blocktype);
    }

    static {
        AbstractTileBuilder.addBlockMapping(TileEntityDropper.class, BlockTypes.DROPPER);
        AbstractTileBuilder.addBlockMapping(TileEntityChest.class, BlockTypes.CHEST);
        AbstractTileBuilder.addBlockMapping(TileEntityEnderChest.class, BlockTypes.ENDER_CHEST);
        AbstractTileBuilder.addBlockMapping(BlockJukebox.TileEntityJukebox.class, BlockTypes.JUKEBOX);
        AbstractTileBuilder.addBlockMapping(TileEntityDispenser.class, BlockTypes.DISPENSER);
        AbstractTileBuilder.addBlockMapping(TileEntityDropper.class, BlockTypes.DROPPER);
        AbstractTileBuilder.addBlockMapping(TileEntitySign.class, BlockTypes.STANDING_SIGN);
        AbstractTileBuilder.addBlockMapping(TileEntityMobSpawner.class, BlockTypes.MOB_SPAWNER);
        AbstractTileBuilder.addBlockMapping(TileEntityNote.class, BlockTypes.NOTEBLOCK);
        AbstractTileBuilder.addBlockMapping(TileEntityPiston.class, BlockTypes.PISTON);
        AbstractTileBuilder.addBlockMapping(TileEntityFurnace.class, BlockTypes.FURNACE);
        AbstractTileBuilder.addBlockMapping(TileEntityBrewingStand.class, BlockTypes.BREWING_STAND);
        AbstractTileBuilder.addBlockMapping(TileEntityEnchantmentTable.class, BlockTypes.ENCHANTING_TABLE);
        AbstractTileBuilder.addBlockMapping(TileEntityEndPortal.class, BlockTypes.END_PORTAL);
        AbstractTileBuilder.addBlockMapping(TileEntityCommandBlock.class, BlockTypes.COMMAND_BLOCK);
        AbstractTileBuilder.addBlockMapping(TileEntityBeacon.class, BlockTypes.BEACON);
        AbstractTileBuilder.addBlockMapping(TileEntitySkull.class, BlockTypes.SKULL);
        AbstractTileBuilder.addBlockMapping(TileEntityDaylightDetector.class, BlockTypes.DAYLIGHT_DETECTOR);
        AbstractTileBuilder.addBlockMapping(TileEntityHopper.class, BlockTypes.HOPPER);
        AbstractTileBuilder.addBlockMapping(TileEntityComparator.class, BlockTypes.UNPOWERED_COMPARATOR);
        AbstractTileBuilder.addBlockMapping(TileEntityFlowerPot.class, BlockTypes.FLOWER_POT);
        AbstractTileBuilder.addBlockMapping(TileEntityBanner.class, BlockTypes.STANDING_BANNER);
    }
}

