/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.inventory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.item.inventory.ItemStack;

public final class ItemStackComparators {
    public static final Comparator<ItemStack> TYPE = new Type();
    public static final Comparator<ItemStack> SIZE = new Size();
    public static final Comparator<ItemStack> TYPE_SIZE = Ordering.compound((Iterable)ImmutableList.of(TYPE, SIZE));
    public static final Comparator<ItemStack> DEFAULT = TYPE_SIZE;
    public static final Comparator<ItemStack> PROPERTIES = new Properties();
    public static final Comparator<ItemStack> ITEM_DATA = new ItemDataComparator();
    public static final Comparator<ItemStack> ALL = Ordering.compound((Iterable)ImmutableList.of(TYPE, SIZE, PROPERTIES, ITEM_DATA));

    private ItemStackComparators() {
        throw new AssertionError((Object)"You should not be attempting to instantiate this class.");
    }

    static final class ItemDataComparator
    implements Comparator<ItemStack> {
        ItemDataComparator() {
        }

        @Override
        public int compare(@Nullable ItemStack o1, @Nullable ItemStack o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            ArrayList manipulators = Lists.newArrayList(o2.getContainers());
            for (DataManipulator manipulator : o1.getContainers()) {
                if (manipulators.contains(manipulator)) {
                    manipulators.remove(manipulator);
                    continue;
                }
                return -1;
            }
            return manipulators.size();
        }
    }

    static final class Properties
    implements Comparator<ItemStack> {
        Properties() {
        }

        @Override
        public int compare(@Nullable ItemStack o1, @Nullable ItemStack o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            ArrayList properties = Lists.newArrayList(o2.getApplicableProperties());
            for (Property<?, ?> property : o1.getApplicableProperties()) {
                if (properties.contains(property)) {
                    properties.remove(property);
                    continue;
                }
                return -1;
            }
            return properties.size();
        }
    }

    static final class Size
    implements Comparator<ItemStack> {
        Size() {
        }

        @Override
        public int compare(@Nullable ItemStack o1, @Nullable ItemStack o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.getQuantity() - o2.getQuantity();
        }
    }

    static final class Type
    implements Comparator<ItemStack> {
        Type() {
        }

        @Override
        public int compare(@Nullable ItemStack o1, @Nullable ItemStack o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.getType().getName().compareTo(o2.getType().getName());
        }
    }
}

