/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.args;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.parsing.SingleArg;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.SpongeApiTranslationHelper;

public final class CommandArgs {
    private final String rawInput;
    private List<SingleArg> args;
    private int index = -1;

    public CommandArgs(String rawInput, List<SingleArg> args) {
        this.rawInput = rawInput;
        this.args = new ArrayList<SingleArg>(args);
    }

    public boolean hasNext() {
        return this.index + 1 < this.args.size();
    }

    public String peek() throws ArgumentParseException {
        if (!this.hasNext()) {
            throw this.createError(SpongeApiTranslationHelper.t("Not enough arguments", new Object[0]));
        }
        return this.args.get(this.index + 1).getValue();
    }

    public String next() throws ArgumentParseException {
        if (!this.hasNext()) {
            throw this.createError(SpongeApiTranslationHelper.t("Not enough arguments!", new Object[0]));
        }
        return this.args.get(++this.index).getValue();
    }

    public Optional<String> nextIfPresent() {
        return this.hasNext() ? Optional.of(this.args.get(++this.index).getValue()) : Optional.empty();
    }

    public ArgumentParseException createError(Text message) {
        return new ArgumentParseException(message, this.rawInput, this.index < 0 ? 0 : this.args.get(this.index).getStartIdx());
    }

    public List<String> getAll() {
        return Collections.unmodifiableList(this.args.stream().map(SingleArg::getValue).collect(Collectors.toList()));
    }

    List<SingleArg> getArgs() {
        return this.args;
    }

    public Object getState() {
        return this.index;
    }

    public void setState(Object state) {
        if (!(state instanceof Integer)) {
            throw new IllegalArgumentException("Provided state was not of appropriate format returned by getState!");
        }
        this.index = (Integer)state;
    }

    public String getRaw() {
        return this.rawInput;
    }

    public void insertArg(String value) {
        int index = this.index < 0 ? 0 : this.args.get(this.index).getEndIdx();
        this.args.add(this.index + 1, new SingleArg(value, index, index));
    }

    public void removeArgs(Object startState, Object endState) {
        if (!(startState instanceof Integer) || !(endState instanceof Integer)) {
            throw new IllegalArgumentException("One of the states provided was not of the correct type!");
        }
        int startIdx = (Integer)startState;
        int endIdx = (Integer)endState;
        if (this.index >= startIdx) {
            this.index = this.index < endIdx ? startIdx - 1 : (this.index -= endIdx - startIdx + 1);
        }
        for (int i = startIdx; i <= endIdx; ++i) {
            this.args.remove(startIdx);
        }
    }

    void previous() {
        if (this.index > -1) {
            --this.index;
        }
    }

    public int getRawPosition() {
        return this.index < 0 ? 0 : this.args.get(this.index).getStartIdx();
    }
}

