/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.item.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.spongepowered.api.item.inventory.EmptyInventory;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.interfaces.IMixinInventory;
import org.spongepowered.common.item.inventory.EmptyInventoryImpl;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.MinecraftInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.collections.SlotCollection;
import org.spongepowered.common.item.inventory.lens.impl.comp.OrderedInventoryLensImpl;
import org.spongepowered.mod.item.inventory.fabric.IItemHandlerFabric;

@Mixin(value={ItemStackHandler.class})
@Implements(value={@Interface(iface=Inventory.class, prefix="inventory$")})
public abstract class MixinItemStackHandler
implements MinecraftInventoryAdapter<IInventory>,
IMixinInventory {
    protected EmptyInventory empty;
    protected Inventory parent;
    protected Inventory next;
    protected SlotCollection slots;
    protected List<Inventory> children = new ArrayList<Inventory>();
    protected Iterable<Slot> slotIterator;
    private Fabric<IItemHandler> fabric;
    protected Lens<IInventory, ItemStack> lens = null;
    private List<SlotTransaction> capturedTransactions = new ArrayList<SlotTransaction>();
    private boolean initalized = false;

    private void init() {
        if (!this.initalized) {
            this.initalized = true;
            this.fabric = new IItemHandlerFabric((IItemHandler)((ItemStackHandler)this));
            this.slots = new SlotCollection.Builder().add(this.fabric.getSize()).build();
            this.lens = new OrderedInventoryLensImpl(0, this.fabric.getSize(), 1, (SlotProvider<IInventory, ItemStack>)this.slots);
        }
    }

    @Override
    public Inventory parent() {
        return this.parent == null ? this : this.parent;
    }

    @Override
    public <T extends Inventory> T first() {
        return (T)this.iterator().next();
    }

    @Override
    public <T extends Inventory> T next() {
        return (T)this.emptyInventory();
    }

    protected final EmptyInventory emptyInventory() {
        if (this.empty == null) {
            this.empty = new EmptyInventoryImpl(this);
        }
        return this.empty;
    }

    @Override
    public SlotProvider<IInventory, ItemStack> getSlotProvider() {
        this.init();
        return this.slots;
    }

    @Override
    public Inventory getChild(int index) {
        if (index < 0 || index >= this.getRootLens().getChildren().size()) {
            throw new IndexOutOfBoundsException("No child at index: " + index);
        }
        while (index >= this.children.size()) {
            this.children.add(null);
        }
        InventoryAdapter<IInventory, ItemStack> child = this.children.get(index);
        if (child == null) {
            child = this.getRootLens().getChildren().get(index).getAdapter(this.getFabric(), this);
            this.children.set(index, child);
        }
        return child;
    }

    @Override
    public <T extends Inventory> Iterable<T> slots() {
        this.init();
        if (this.slotIterator == null) {
            this.slotIterator = this.slots.getIterator(this);
        }
        return this.slotIterator;
    }

    @Intrinsic
    public void inventory$clear() {
        this.getFabric().clear();
    }

    @Override
    public Lens<IInventory, ItemStack> getRootLens() {
        this.init();
        return this.lens;
    }

    @Override
    public Fabric<IInventory> getFabric() {
        this.init();
        return this.fabric;
    }

    @Override
    public List<SlotTransaction> getCapturedTransactions() {
        return this.capturedTransactions;
    }
}

