/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.forge;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLLog;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.WorldArchetype;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.interfaces.world.IMixinWorldInfo;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.interfaces.world.IMixinWorldSettings;
import org.spongepowered.common.world.WorldManager;
import org.spongepowered.mod.util.StaticMixinForgeHelper;

@Mixin(value={DimensionManager.class}, remap=false)
public abstract class MixinDimensionManager {
    @Shadow
    static Multiset<Integer> leakedWorlds = HashMultiset.create();

    @Overwrite
    public static int[] getDimensions(net.minecraft.world.DimensionType type) {
        return WorldManager.getRegisteredDimensionIdsFor(type);
    }

    @Overwrite
    public static void init() {
        WorldManager.registerVanillaTypesAndDimensions();
    }

    @Overwrite
    public static void registerDimension(int id, net.minecraft.world.DimensionType type) {
        WorldManager.registerDimension(id, type);
    }

    @Overwrite
    public static void unregisterDimension(int id) {
        WorldManager.unregisterDimension(id);
    }

    @Overwrite
    public static boolean isDimensionRegistered(int dim) {
        return WorldManager.isDimensionRegistered(dim);
    }

    @Overwrite
    public static net.minecraft.world.DimensionType getProviderType(int dim) {
        return WorldManager.getDimensionType(dim).orElse(null);
    }

    @Overwrite
    public static WorldProvider getProvider(int dim) {
        Optional<WorldServer> optWorldServer = WorldManager.getWorldByDimensionId(dim);
        if (optWorldServer.isPresent()) {
            return optWorldServer.get().field_73011_w;
        }
        SpongeImpl.getLogger().error("Attempt made to get a provider for dimension id [{}] but it has no provider!");
        throw new RuntimeException();
    }

    @Overwrite
    public static Integer[] getIDs(boolean check) {
        if (check) {
            ArrayList<WorldServer> candidateLeakedWorlds = new ArrayList<WorldServer>(WorldManager.getWeakWorldMap().values());
            candidateLeakedWorlds.removeAll(WorldManager.getWorlds());
            leakedWorlds.addAll((Collection)candidateLeakedWorlds.stream().map(System::identityHashCode).collect(Collectors.toList()));
            for (WorldServer worldServer : WorldManager.getWorlds()) {
                int hashCode = System.identityHashCode(worldServer);
                int leakCount = leakedWorlds.count((Object)hashCode);
                if (leakCount <= 0 || leakCount % 5 != 0) continue;
                SpongeImpl.getLogger().warn("World [{}] (DIM{}) (HASH: {}) may have leaked. Encountered [{}] times", (Object)worldServer.func_72912_H().func_76065_j(), (Object)((IMixinWorldServer)worldServer).getDimensionId(), (Object)hashCode, (Object)leakCount);
            }
        }
        return MixinDimensionManager.getIDs();
    }

    @Overwrite
    public static Integer[] getIDs() {
        int[] spongeDimIds = WorldManager.getLoadedWorldDimensionIds();
        Integer[] forgeDimIds = new Integer[spongeDimIds.length];
        for (int i = 0; i < spongeDimIds.length; ++i) {
            forgeDimIds[i] = spongeDimIds[i];
        }
        return forgeDimIds;
    }

    @Overwrite
    public static void setWorld(int id, WorldServer world, MinecraftServer server) {
        if (world != null) {
            WorldManager.forceAddWorld(id, world);
            server.worldTickTimes.put(id, new long[100]);
            FMLLog.info((String)"Loading dimension %d (%s) (%s)", (Object[])new Object[]{id, world.func_72912_H().func_76065_j(), world.func_73046_m()});
        } else {
            WorldManager.unloadWorld(WorldManager.getWorldByDimensionId(id).orElseThrow(() -> new RuntimeException("Attempt made to unload a world with dimension id [" + id + "].")), false);
            server.worldTickTimes.remove(id);
        }
        WorldManager.reorderWorldsVanillaFirst();
    }

    @Overwrite
    public static void initDimension(int dim) {
        if (WorldManager.getWorldByDimensionId(dim).isPresent()) {
            return;
        }
        if (dim == 0) {
            throw new RuntimeException("Attempt made to initialize overworld!");
        }
        WorldManager.getWorldByDimensionId(0).orElseThrow(() -> new RuntimeException("Attempt made to initialize dimension before overworld is loaded!"));
        net.minecraft.world.DimensionType dimensionType = WorldManager.getDimensionType(dim).orElse(null);
        if (dimensionType == null) {
            SpongeImpl.getLogger().warn("Attempt made to initialize dimension id {} which isn't registered!, falling back to overworld.", (Object)dim);
            return;
        }
        WorldProvider provider = dimensionType.func_186070_d();
        provider.setDimension(dim);
        String worldFolder = WorldManager.getWorldFolderByDimensionId(dim).orElse(provider.getSaveFolder());
        WorldProperties properties = WorldManager.getWorldProperties(worldFolder).orElse(null);
        Path worldPath = WorldManager.getCurrentSavesDirectory().get().resolve(worldFolder);
        if (properties == null || !Files.isDirectory(worldPath, new LinkOption[0])) {
            if (properties != null) {
                WorldManager.unregisterWorldProperties(properties, false);
            }
            String modId = StaticMixinForgeHelper.getModIdFromClass(provider.getClass());
            WorldArchetype archetype = Sponge.getRegistry().getType(WorldArchetype.class, modId + ":" + dimensionType.func_186065_b().toLowerCase()).orElse(null);
            if (archetype == null) {
                WorldArchetype.Builder builder = WorldArchetype.builder().dimension((DimensionType)dimensionType).keepsSpawnLoaded(dimensionType.shouldLoadSpawn());
                archetype = builder.build(modId + ":" + dimensionType.func_186065_b().toLowerCase(), dimensionType.func_186065_b());
            }
            IMixinWorldSettings worldSettings = (IMixinWorldSettings)((Object)archetype);
            worldSettings.setDimensionType((DimensionType)dimensionType);
            worldSettings.setLoadOnStartup(false);
            properties = WorldManager.createWorldProperties(worldFolder, archetype, dim);
            ((IMixinWorldInfo)((Object)properties)).setDimensionId(dim);
            ((IMixinWorldInfo)((Object)properties)).setIsMod(true);
        }
        if (!properties.isEnabled()) {
            return;
        }
        Optional<WorldServer> optWorld = WorldManager.loadWorld(properties);
        if (!optWorld.isPresent()) {
            SpongeImpl.getLogger().error("Could not load world [{}]!", (Object)properties.getWorldName());
        }
    }

    @Overwrite
    public static WorldServer getWorld(int id) {
        return WorldManager.getWorldByDimensionId(id).orElse(null);
    }

    @Overwrite
    public static WorldServer[] getWorlds() {
        Collection<WorldServer> worlds = WorldManager.getWorlds();
        return worlds.toArray(new WorldServer[worlds.size()]);
    }

    @Overwrite
    public static Integer[] getStaticDimensionIDs() {
        int[] spongeDimIds = WorldManager.getRegisteredDimensionIds();
        Integer[] forgeDimIds = new Integer[spongeDimIds.length];
        for (int i = 0; i < spongeDimIds.length; ++i) {
            forgeDimIds[i] = spongeDimIds[i];
        }
        return forgeDimIds;
    }

    @Overwrite
    public static WorldProvider createProviderFor(int dim) {
        net.minecraft.world.DimensionType dimensionType = WorldManager.getDimensionType(dim).orElseThrow(() -> new RuntimeException("Attempt to create provider for dimension id [" + dim + "] failed because it has not been registered!"));
        try {
            WorldProvider provider = dimensionType.func_186070_d();
            provider.setDimension(dim);
            return provider;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create provider for dimension id [" + dim + "]!");
        }
    }

    @Overwrite
    public static void unloadWorld(int id) {
        WorldManager.getWorldByDimensionId(id).ifPresent(WorldManager::queueWorldToUnload);
    }

    @Overwrite
    public static void unloadWorlds(Hashtable<Integer, long[]> worldTickTimes) {
        WorldManager.unloadQueuedWorlds();
    }

    @Overwrite
    public static int getNextFreeDimId() {
        return WorldManager.getNextFreeDimensionId();
    }

    @Overwrite
    public static NBTTagCompound saveDimensionDataMap() {
        return WorldManager.saveDimensionDataMap();
    }

    @Overwrite
    public static void loadDimensionDataMap(NBTTagCompound compoundTag) {
        WorldManager.loadDimensionDataMap(compoundTag);
    }

    @Overwrite
    @Nullable
    public static File getCurrentSaveRootDirectory() {
        Optional<Path> optCurrentSavesDir = WorldManager.getCurrentSavesDirectory();
        return optCurrentSavesDir.isPresent() ? optCurrentSavesDir.get().toFile() : null;
    }
}

