/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.fml.common.eventhandler;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.IEventExceptionHandler;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.ListenerList;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.mod.event.SpongeForgeEventFactory;
import org.spongepowered.mod.event.SpongeForgeEventHooks;
import org.spongepowered.mod.event.SpongeModEventManager;
import org.spongepowered.mod.interfaces.IMixinASMEventHandler;
import org.spongepowered.mod.interfaces.IMixinEventBus;

@NonnullByDefault
@Mixin(value={EventBus.class}, remap=false)
public abstract class MixinEventBus
implements IMixinEventBus {
    private Map<IEventListener, Class<? extends Event>> forgeListenerRegistry = new HashMap<IEventListener, Class<? extends Event>>();
    @Shadow
    @Final
    private int busID;
    @Shadow
    private IEventExceptionHandler exceptionHandler;
    private static boolean isSpongeSetUp = false;

    private boolean isEventAllowed(Event event) {
        if (event instanceof LivingDropsEvent) {
            return false;
        }
        if (event instanceof WorldEvent.Save) {
            return false;
        }
        if (event instanceof WorldEvent.Unload) {
            return false;
        }
        return !(event instanceof AttackEntityEvent);
    }

    @Overwrite
    public boolean post(Event event) {
        return this.post(event, false);
    }

    @Override
    public org.spongepowered.api.event.Event postForgeAndCreateSpongeEvent(Event forgeEvent) {
        org.spongepowered.api.event.Event spongeEvent;
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            spongeEvent = SpongeForgeEventFactory.createSpongeEvent(forgeEvent);
            IEventListener[] listeners = forgeEvent.getListenerList().getListeners(this.busID);
            boolean cancelled = ((SpongeModEventManager)SpongeImpl.getGame().getEventManager()).post(spongeEvent, forgeEvent, listeners, true);
            if (!cancelled) {
                SpongeForgeEventFactory.onForgePost(forgeEvent);
            }
        }
        return spongeEvent;
    }

    @Override
    public boolean post(Event event, boolean forced) {
        org.spongepowered.api.event.Event spongeEvent = null;
        if (!isSpongeSetUp) {
            try {
                Sponge.getCauseStackManager();
            }
            catch (Exception e) {
                return false;
            }
        }
        isSpongeSetUp = true;
        boolean isMainThread = Sponge.isServerAvailable() && Sponge.getServer().isMainThread();
        try (CauseStackManager.StackFrame frame = isMainThread ? Sponge.getCauseStackManager().pushCauseFrame() : null;){
            int index;
            if (!forced) {
                if (!this.isEventAllowed(event)) {
                    boolean bl = false;
                    return bl;
                }
                spongeEvent = SpongeForgeEventFactory.createSpongeEvent(event);
            }
            IEventListener[] listeners = event.getListenerList().getListeners(this.busID);
            if (!(forced || !(event instanceof org.spongepowered.api.event.Event) && spongeEvent == null || Sponge.getGame().getPlatform().getExecutionType().isClient())) {
                boolean cancelled = ((SpongeModEventManager)SpongeImpl.getGame().getEventManager()).post(spongeEvent, event, listeners, SpongeModEventManager.shouldUseCauseStackManager(false));
                if (!cancelled) {
                    SpongeForgeEventFactory.onForgePost(event);
                }
                boolean bl = cancelled;
                return bl;
            }
            listeners = event.getListenerList().getListeners(this.busID);
            IMixinASMEventHandler modListener = null;
            try {
                for (index = 0; index < listeners.length; ++index) {
                    IEventListener listener = listeners[index];
                    if (listener instanceof IMixinASMEventHandler) {
                        modListener = (IMixinASMEventHandler)listener;
                        modListener.getTimingsHandler().startTimingIfSync();
                        try (PhaseContext<?> context = SpongeForgeEventHooks.preEventPhaseCheck(listener, event);){
                            listener.invoke(event);
                        }
                        modListener.getTimingsHandler().stopTimingIfSync();
                        continue;
                    }
                    listener.invoke(event);
                }
            }
            catch (Throwable throwable) {
                if (modListener != null) {
                    modListener.getTimingsHandler().stopTimingIfSync();
                }
                this.exceptionHandler.handleException((EventBus)this, event, listeners, index, throwable);
                throw new RuntimeException(throwable);
            }
            boolean bl = event.isCancelable() ? event.isCanceled() : false;
            return bl;
        }
    }

    @Redirect(method={"register(Ljava/lang/Class;Ljava/lang/Object;Ljava/lang/reflect/Method;Lnet/minecraftforge/fml/common/ModContainer;)V"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/fml/common/eventhandler/ListenerList;register(ILnet/minecraftforge/fml/common/eventhandler/EventPriority;Lnet/minecraftforge/fml/common/eventhandler/IEventListener;)V", remap=false))
    public void onRegister(ListenerList list, int id, EventPriority priority, IEventListener listener, Class<? extends Event> eventType, Object target, Method method, ModContainer owner) {
        list.register(id, priority, listener);
        SpongeModEventManager manager = (SpongeModEventManager)SpongeImpl.getGame().getEventManager();
        for (Class clazz : TypeToken.of(eventType).getTypes().rawTypes()) {
            ImmutableCollection spongeEvents = manager.forgeToSpongeEventMapping.get((Object)clazz);
            if (spongeEvents == null) continue;
            for (Class event : spongeEvents) {
                manager.checker.registerListenerFor(event);
            }
        }
        this.forgeListenerRegistry.put(listener, eventType);
    }

    @Redirect(method={"unregister"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/fml/common/eventhandler/ListenerList;unregisterAll(ILnet/minecraftforge/fml/common/eventhandler/IEventListener;)V", remap=false))
    public void onUnregisterListener(int id, IEventListener listener) {
        ListenerList.unregisterAll((int)id, (IEventListener)listener);
        SpongeModEventManager manager = (SpongeModEventManager)SpongeImpl.getGame().getEventManager();
        for (Class clazz : TypeToken.of((Class)((Class)Preconditions.checkNotNull(this.forgeListenerRegistry.remove(listener)))).getTypes().rawTypes()) {
            ImmutableCollection spongeEvents = manager.forgeToSpongeEventMapping.get((Object)clazz);
            if (spongeEvents == null) continue;
            for (Class event : spongeEvents) {
                manager.checker.unregisterListenerFor(event);
            }
        }
    }

    @Override
    public int getBusID() {
        return this.busID;
    }
}

