/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.fml.common;

import java.io.File;
import java.math.BigInteger;
import java.util.List;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ModDiscoverer;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionRange;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.util.PathTokens;
import org.spongepowered.plugin.meta.version.ComparableVersion;

@Mixin(value={Loader.class}, remap=false)
public abstract class MixinLoader {
    private ModContainer mod;

    @Redirect(method={"identifyMods"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/fml/common/discovery/ModDiscoverer;findModDirMods(Ljava/io/File;[Ljava/io/File;)V", remap=false))
    private void discoverMods(ModDiscoverer modDiscoverer, File modsDir, File[] additionalMods) {
        modDiscoverer.findModDirMods(modsDir, additionalMods);
        File pluginsDir = this.getPluginsDir();
        if (pluginsDir.isDirectory() && !pluginsDir.equals(modsDir)) {
            FMLLog.info((String)"Searching %s for plugins", (Object[])new Object[]{pluginsDir.getAbsolutePath()});
            this.discoverPlugins(modDiscoverer, pluginsDir);
        }
    }

    @Unique
    private void discoverPlugins(ModDiscoverer modDiscoverer, File pluginsDir) {
        modDiscoverer.findModDirMods(pluginsDir, new File[0]);
    }

    @Unique
    private File getPluginsDir() {
        return new File(PathTokens.replace(SpongeImpl.getGlobalConfig().getConfig().getGeneral().pluginsDir()));
    }

    @Redirect(method={"sortModList"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/fml/common/ModContainer;getDependencies()Ljava/util/List;", remap=false))
    private List<ArtifactVersion> onGetDependencies(ModContainer mod) {
        this.mod = mod;
        return mod.getDependencies();
    }

    @Redirect(method={"sortModList"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/fml/common/versioning/ArtifactVersion;containsVersion(Lnet/minecraftforge/fml/common/versioning/ArtifactVersion;)Z", remap=false))
    private boolean onCheckContainsVersion(ArtifactVersion expected, ArtifactVersion installed) {
        BigInteger majorInstalled;
        BigInteger majorExpected;
        VersionRange range;
        String installedVersion = installed.getVersionString();
        if (!(installedVersion.equals("unknown") || !(expected instanceof DefaultArtifactVersion) || (range = ((DefaultArtifactVersion)expected).getRange()) == null || range.getRecommendedVersion() == null || installedVersion.equals(range.getRecommendedVersion().getVersionString()) || (majorExpected = new ComparableVersion(range.getRecommendedVersion().getVersionString()).getFirstInteger()) == null || (majorInstalled = new ComparableVersion(installedVersion).getFirstInteger()) == null || majorExpected.equals(majorInstalled) && installed.compareTo((Object)range.getRecommendedVersion()) >= 0)) {
            SpongeImpl.getLogger().warn("The mod {} was designed for {} {} but version {} is in use. It may not work properly.", (Object)this.mod.getModId(), (Object)expected.getLabel(), (Object)expected.getRangeString(), (Object)installed.getVersionString());
        }
        return expected.containsVersion(installed);
    }
}

