/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.common.fluid;

import com.google.common.base.Preconditions;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.extra.fluid.FluidType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.extra.fluid.SpongeFluidStackBuilder;

@Mixin(value={SpongeFluidStackBuilder.class}, remap=false)
public abstract class MixinSpongeFluidStackBuilder
extends AbstractDataBuilder<org.spongepowered.api.extra.fluid.FluidStack> {
    @Shadow
    FluidType fluidType;
    @Shadow
    int volume;
    @Shadow
    DataContainer extra;

    public MixinSpongeFluidStackBuilder(Class<org.spongepowered.api.extra.fluid.FluidStack> requiredClass, int supportedVersion) {
        super(requiredClass, supportedVersion);
    }

    @Overwrite
    public org.spongepowered.api.extra.fluid.FluidStack build() {
        Preconditions.checkNotNull((Object)this.fluidType, (Object)"Fluidtype cannot be null!");
        Preconditions.checkState((this.volume >= 0 ? 1 : 0) != 0, (Object)"Volume must be at least zero!");
        NBTTagCompound compound = this.extra == null ? null : NbtTranslator.getInstance().translateData(this.extra);
        FluidStack fluidStack = new FluidStack((Fluid)this.fluidType, this.volume, compound);
        return (org.spongepowered.api.extra.fluid.FluidStack)fluidStack;
    }
}

