/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.TrackingPhases;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.mixin.core.block.MixinBlock;

@NonnullByDefault
@Mixin(value={BlockLeaves.class}, priority=1001)
public abstract class MixinBlockLeaves
extends MixinBlock {
    @Redirect(method={"breakBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;beginLeavesDecay(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V", remap=false))
    public void onBreakBlock(Block block, IBlockState state, World worldIn, BlockPos pos) {
        block33: {
            if (!worldIn.field_72995_K) {
                PhaseTracker phaseTracker = PhaseTracker.getInstance();
                IPhaseState<?> currentState = phaseTracker.getCurrentState();
                boolean isBlockAlready = currentState.getPhase() != TrackingPhases.BLOCK;
                PhaseContext blockDecay = null;
                boolean isWorldGen = currentState.isWorldGeneration();
                if (isBlockAlready && !isWorldGen) {
                    LocatableBlock locatable = LocatableBlock.builder().location(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).state((BlockState)state).build();
                    blockDecay = ((PhaseContext)BlockPhase.State.BLOCK_DECAY.createPhaseContext()).source(locatable);
                }
                try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();
                     PhaseContext context = blockDecay != null ? (PhaseContext)blockDecay.buildAndSwitch() : null;){
                    frame.addContext(EventContextKeys.LEAVES_DECAY, (org.spongepowered.api.world.World)worldIn);
                    if (SpongeCommonEventFactory.callChangeBlockEventPre((IMixinWorldServer)worldIn, pos).isCancelled()) {
                        return;
                    }
                    block.beginLeavesDecay(state, worldIn, pos);
                    break block33;
                }
            }
            block.beginLeavesDecay(state, worldIn, pos);
        }
    }
}

