/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.common.config.category.LoggingCategory;

public enum BlockChange {
    BREAK("BreakEvent"){

        @Override
        public ChangeBlockEvent createEvent(Cause cause, ImmutableList<Transaction<BlockSnapshot>> transactions) {
            return SpongeEventFactory.createChangeBlockEventBreak(cause, transactions);
        }

        @Override
        public boolean allowsLogging(LoggingCategory category) {
            return category.blockBreakLogging();
        }
    }
    ,
    DECAY{

        @Override
        @Nullable
        public ChangeBlockEvent createEvent(Cause cause, ImmutableList<Transaction<BlockSnapshot>> transactions) {
            return SpongeEventFactory.createChangeBlockEventDecay(cause, transactions);
        }
    }
    ,
    MODIFY("ModifyEvent"){

        @Override
        public ChangeBlockEvent createEvent(Cause cause, ImmutableList<Transaction<BlockSnapshot>> transactions) {
            return SpongeEventFactory.createChangeBlockEventModify(cause, transactions);
        }

        @Override
        public boolean allowsLogging(LoggingCategory category) {
            return category.blockModifyLogging();
        }
    }
    ,
    PLACE("PlaceEvent"){

        @Override
        public ChangeBlockEvent createEvent(Cause cause, ImmutableList<Transaction<BlockSnapshot>> transactions) {
            return SpongeEventFactory.createChangeBlockEventPlace(cause, transactions);
        }

        @Override
        public boolean allowsLogging(LoggingCategory category) {
            return category.blockPlaceLogging();
        }
    };

    private final String eventName;

    public static BlockChange forEvent(ChangeBlockEvent event) {
        if (event instanceof ChangeBlockEvent.Break) {
            return BREAK;
        }
        if (event instanceof ChangeBlockEvent.Decay) {
            return DECAY;
        }
        if (event instanceof ChangeBlockEvent.Modify) {
            return MODIFY;
        }
        if (event instanceof ChangeBlockEvent.Place) {
            return PLACE;
        }
        return null;
    }

    private BlockChange() {
        this("");
    }

    private BlockChange(String eventName) {
        this.eventName = eventName;
    }

    public String getEventSuggestedName() {
        return this.eventName;
    }

    public boolean allowsLogging(LoggingCategory category) {
        return false;
    }

    @Nullable
    public ChangeBlockEvent createEvent(Cause cause, ImmutableList<Transaction<BlockSnapshot>> transactions) {
        return null;
    }
}

