/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.gen;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import net.minecraft.world.biome.Biome;
import org.spongepowered.api.util.DiscreteTransform3;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.biome.BiomeTypes;
import org.spongepowered.api.world.biome.VirtualBiomeType;
import org.spongepowered.api.world.extent.ImmutableBiomeVolume;
import org.spongepowered.api.world.extent.MutableBiomeVolume;
import org.spongepowered.api.world.extent.StorageType;
import org.spongepowered.api.world.extent.UnmodifiableBiomeVolume;
import org.spongepowered.api.world.extent.worker.MutableBiomeVolumeWorker;
import org.spongepowered.common.util.gen.AbstractBiomeBuffer;
import org.spongepowered.common.util.gen.ObjectArrayImmutableBiomeBuffer;
import org.spongepowered.common.world.extent.MutableBiomeViewDownsize;
import org.spongepowered.common.world.extent.MutableBiomeViewTransform;
import org.spongepowered.common.world.extent.UnmodifiableBiomeVolumeWrapper;
import org.spongepowered.common.world.extent.worker.SpongeMutableBiomeVolumeWorker;

public final class ObjectArrayMutableBiomeBuffer
extends AbstractBiomeBuffer
implements MutableBiomeVolume {
    private final BiomeType[] biomes;

    public ObjectArrayMutableBiomeBuffer(Vector3i start, Vector3i size) {
        super(start, size);
        this.biomes = new BiomeType[size.getX() * size.getZ()];
        Arrays.fill(this.biomes, BiomeTypes.OCEAN);
    }

    public ObjectArrayMutableBiomeBuffer(BiomeType[] biomes, Vector3i start, Vector3i size) {
        super(start, size);
        this.biomes = biomes;
    }

    @Override
    public BiomeType getBiome(int x, int y, int z) {
        this.checkRange(x, y, z);
        return this.biomes[this.getIndex(x, z)];
    }

    public Biome getNativeBiome(int x, int y, int z) {
        this.checkRange(x, y, z);
        BiomeType type = this.biomes[this.getIndex(x, z)];
        if (type instanceof VirtualBiomeType) {
            type = ((VirtualBiomeType)type).getPersistedType();
        }
        return (Biome)type;
    }

    @Override
    public void setBiome(int x, int y, int z, BiomeType biome) {
        Preconditions.checkNotNull((Object)biome, (Object)"biome");
        this.checkRange(x, y, z);
        this.biomes[this.getIndex((int)x, (int)z)] = biome;
    }

    public void reuse(Vector3i start) {
        this.start = (Vector3i)Preconditions.checkNotNull((Object)start, (Object)"start");
        this.end = this.start.add(this.size).sub(Vector3i.ONE);
        Arrays.fill(this.biomes, BiomeTypes.OCEAN);
    }

    public void fill(byte[] biomes) {
        for (int x = 0; x < this.size.getX(); ++x) {
            for (int z = 0; z < this.size.getZ(); ++z) {
                BiomeType type = this.biomes[x + z * this.size.getX()];
                if (type instanceof VirtualBiomeType) {
                    type = ((VirtualBiomeType)type).getPersistedType();
                }
                biomes[x + z * this.size.getX()] = (byte)Biome.func_185362_a((Biome)((Biome)type));
            }
        }
    }

    public void fill(Biome[] biomes) {
        for (int x = 0; x < this.size.getX(); ++x) {
            for (int z = 0; z < this.size.getZ(); ++z) {
                BiomeType type = this.biomes[x + z * this.size.getX()];
                if (type instanceof VirtualBiomeType) {
                    type = ((VirtualBiomeType)type).getPersistedType();
                }
                biomes[x + z * this.size.getX()] = (Biome)type;
            }
        }
    }

    @Override
    public MutableBiomeVolume getBiomeView(Vector3i newMin, Vector3i newMax) {
        this.checkRange(newMin.getX(), newMin.getY(), newMin.getZ());
        this.checkRange(newMax.getX(), newMax.getY(), newMax.getZ());
        return new MutableBiomeViewDownsize(this, newMin, newMax);
    }

    @Override
    public MutableBiomeVolume getBiomeView(DiscreteTransform3 transform) {
        return new MutableBiomeViewTransform(this, transform);
    }

    @Override
    public MutableBiomeVolumeWorker<? extends MutableBiomeVolume> getBiomeWorker() {
        return new SpongeMutableBiomeVolumeWorker<ObjectArrayMutableBiomeBuffer>(this);
    }

    @Override
    public UnmodifiableBiomeVolume getUnmodifiableBiomeView() {
        return new UnmodifiableBiomeVolumeWrapper(this);
    }

    @Override
    public MutableBiomeVolume getBiomeCopy(StorageType type) {
        switch (type) {
            case STANDARD: {
                return new ObjectArrayMutableBiomeBuffer((BiomeType[])this.biomes.clone(), this.start, this.size);
            }
        }
        throw new UnsupportedOperationException(type.name());
    }

    @Override
    public ImmutableBiomeVolume getImmutableBiomeCopy() {
        return new ObjectArrayImmutableBiomeBuffer(this.biomes, this.start, this.size);
    }
}

