/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.registry.CatalogRegistryModule;

public final class BlockStateRegistryModule
implements CatalogRegistryModule<BlockState> {
    private final Map<String, BlockState> blockStateMap = new LinkedHashMap<String, BlockState>();

    public static BlockStateRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public Optional<BlockState> getById(String id) {
        return Optional.ofNullable(this.blockStateMap.get(((String)Preconditions.checkNotNull((Object)id, (Object)"Id cannot be null!")).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<BlockState> getAll() {
        return ImmutableList.copyOf(this.blockStateMap.values());
    }

    void registerBlockState(BlockState blockState) {
        Preconditions.checkNotNull((Object)blockState, (Object)"BlockState cannot be null!");
        if (!this.blockStateMap.containsKey(blockState.getId().toLowerCase(Locale.ENGLISH))) {
            this.blockStateMap.put(blockState.getId().toLowerCase(Locale.ENGLISH), blockState);
        }
    }

    BlockStateRegistryModule() {
    }

    private static final class Holder {
        static final BlockStateRegistryModule INSTANCE = new BlockStateRegistryModule();

        private Holder() {
        }
    }
}

