/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import co.aikar.timings.TimingHistory;
import co.aikar.timings.WorldTimingsHandler;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketExplosion;
import net.minecraft.profiler.Profiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.ScoreboardSaveData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.ITickable;
import net.minecraft.util.ReportedException;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkGeneratorEnd;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.ScheduledBlockUpdate;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.sound.SoundCategory;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.effect.sound.record.RecordType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.NotifyNeighborBlockEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.world.ChangeWorldWeatherEvent;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.GeneratorType;
import org.spongepowered.api.world.GeneratorTypes;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.PortalAgent;
import org.spongepowered.api.world.PortalAgentType;
import org.spongepowered.api.world.PortalAgentTypes;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.gen.BiomeGenerator;
import org.spongepowered.api.world.gen.WorldGenerator;
import org.spongepowered.api.world.gen.WorldGeneratorModifier;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.api.world.storage.WorldStorage;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.api.world.weather.Weathers;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.type.GeneralConfigBase;
import org.spongepowered.common.config.type.WorldConfig;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.effect.particle.SpongeParticleEffect;
import org.spongepowered.common.effect.particle.SpongeParticleHelper;
import org.spongepowered.common.effect.record.SpongeRecordType;
import org.spongepowered.common.effect.sound.SoundEffectHelper;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.entity.BasicEntityContext;
import org.spongepowered.common.event.tracking.phase.entity.EntityPhase;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.event.tracking.phase.generation.GenericGenerationContext;
import org.spongepowered.common.event.tracking.phase.plugin.BasicPluginContext;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.IMixinNextTickListEntry;
import org.spongepowered.common.interfaces.block.IMixinBlock;
import org.spongepowered.common.interfaces.block.IMixinBlockEventData;
import org.spongepowered.common.interfaces.block.tile.IMixinTileEntity;
import org.spongepowered.common.interfaces.data.IMixinCustomDataHolder;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.server.management.IMixinPlayerChunkMap;
import org.spongepowered.common.interfaces.util.math.IMixinBlockPos;
import org.spongepowered.common.interfaces.world.IMixinServerWorldEventHandler;
import org.spongepowered.common.interfaces.world.IMixinWorldInfo;
import org.spongepowered.common.interfaces.world.IMixinWorldProvider;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.interfaces.world.gen.IMixinChunkProviderServer;
import org.spongepowered.common.interfaces.world.gen.IPopulatorProvider;
import org.spongepowered.common.mixin.core.world.MixinWorld;
import org.spongepowered.common.mixin.plugin.entityactivation.interfaces.IModData_Activation;
import org.spongepowered.common.mixin.plugin.entitycollisions.interfaces.IModData_Collisions;
import org.spongepowered.common.registry.provider.DirectionFacingProvider;
import org.spongepowered.common.util.NonNullArrayList;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.common.world.WorldManager;
import org.spongepowered.common.world.border.PlayerBorderListener;
import org.spongepowered.common.world.gen.SpongeChunkGenerator;
import org.spongepowered.common.world.gen.SpongeGenerationPopulator;
import org.spongepowered.common.world.gen.SpongeWorldGenerator;
import org.spongepowered.common.world.gen.WorldGenConstants;
import org.spongepowered.common.world.type.SpongeWorldType;

@Mixin(value={WorldServer.class})
@Implements(value={@Interface(iface=IMixinWorldServer.class, prefix="worldServer$", unique=true)})
public abstract class MixinWorldServer
extends MixinWorld
implements IMixinWorldServer {
    private static final String PROFILER_SS = "Lnet/minecraft/profiler/Profiler;startSection(Ljava/lang/String;)V";
    private static final String PROFILER_ESS = "Lnet/minecraft/profiler/Profiler;endStartSection(Ljava/lang/String;)V";
    private static final Vector3i BLOCK_MIN = new Vector3i(-30000000, 0, -30000000);
    private static final Vector3i BLOCK_MAX = new Vector3i(30000000, 256, 30000000).sub(1, 1, 1);
    private static final EnumSet<EnumFacing> NOTIFY_DIRECTIONS = EnumSet.of(EnumFacing.WEST, new EnumFacing[]{EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH});
    private final Map<net.minecraft.entity.Entity, Vector3d> rotationUpdates = new HashMap<net.minecraft.entity.Entity, Vector3d>();
    private SpongeChunkGenerator spongegen;
    private SpongeConfig<? extends GeneralConfigBase> activeConfig;
    private long weatherStartTime;
    private Weather prevWeather;
    protected WorldTimingsHandler timings;
    private int chunkGCTickCount = 0;
    private int chunkGCLoadThreshold = 0;
    private int chunkGCTickInterval = 600;
    private long chunkUnloadDelay = 30000L;
    private boolean weatherThunderEnabled = true;
    private boolean weatherIceAndSnowEnabled = true;
    private int dimensionId;
    private IMixinChunkProviderServer mixinChunkProviderServer;
    @Shadow
    @Final
    private MinecraftServer field_73061_a;
    @Shadow
    @Final
    private Set<NextTickListEntry> field_73064_N;
    @Shadow
    @Final
    private TreeSet<NextTickListEntry> field_73065_O;
    @Shadow
    @Final
    private PlayerChunkMap field_73063_M;
    @Shadow
    @Final
    @Mutable
    private Teleporter field_85177_Q;
    @Shadow
    @Final
    private WorldServer.ServerBlockEventList[] field_147490_S;
    @Shadow
    private int field_147489_T;
    @Shadow
    private int field_80004_Q;
    @Nullable
    private NextTickListEntry tmpScheduledObj;

    @Shadow
    public abstract boolean func_147485_a(BlockEventData var1);

    @Shadow
    public abstract void func_73047_i();

    @Shadow
    @Nullable
    public abstract net.minecraft.entity.Entity func_175733_a(UUID var1);

    @Shadow
    public abstract PlayerChunkMap func_184164_w();

    @Shadow
    public abstract ChunkProviderServer func_72863_F();

    @Shadow
    public abstract void func_184162_i();

    @Shadow
    public abstract BlockPos func_175736_a(BlockPos var1);

    @Shadow
    public boolean func_184165_i(net.minecraft.entity.Entity entityIn) {
        return false;
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldProvider;setWorld(Lnet/minecraft/world/World;)V"))
    private void onSetWorld(WorldProvider worldProvider, net.minecraft.world.World worldIn) {
        WorldInfo originalWorldInfo = worldIn.func_72912_H();
        worldProvider.func_76558_a(worldIn);
        this.field_72986_A = originalWorldInfo;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstruct(MinecraftServer server, ISaveHandler saveHandlerIn, WorldInfo info, int dimensionId, Profiler profilerIn, CallbackInfo callbackInfo) {
        if (info == null) {
            SpongeImpl.getLogger().warn("World constructed without a WorldInfo! This will likely cause problems. Subsituting dummy info.", (Throwable)new RuntimeException("Stack trace:"));
            this.field_72986_A = new WorldInfo(new WorldSettings(0L, GameType.NOT_SET, false, false, WorldType.field_77137_b), "sponge$dummy_world");
        }
        this.field_72986_A = info;
        this.timings = new WorldTimingsHandler((net.minecraft.world.World)((WorldServer)this));
        this.dimensionId = dimensionId;
        this.prevWeather = this.getWeather();
        this.weatherStartTime = this.field_72986_A.func_82573_f();
        ((net.minecraft.world.World)this).func_175723_af().func_177737_a((IBorderListener)new PlayerBorderListener(this.func_73046_m(), dimensionId));
        PortalAgentType portalAgentType = ((WorldProperties)this.field_72986_A).getPortalAgentType();
        if (!portalAgentType.equals(PortalAgentTypes.DEFAULT)) {
            try {
                this.field_85177_Q = (Teleporter)portalAgentType.getPortalAgentClass().getConstructor(WorldServer.class).newInstance(this);
            }
            catch (Exception e) {
                SpongeImpl.getLogger().log(Level.ERROR, "Could not create PortalAgent of type " + portalAgentType.getId() + " for world " + this.getName() + ": " + e.getMessage() + ". Falling back to default...");
            }
        }
        this.updateWorldGenerator();
        this.chunkGCLoadThreshold = SpongeHooks.getActiveConfig((WorldServer)this).getConfig().getWorld().getChunkLoadThreadhold();
        this.chunkGCTickInterval = this.getActiveConfig().getConfig().getWorld().getTickInterval();
        this.weatherIceAndSnowEnabled = this.getActiveConfig().getConfig().getWorld().getWeatherIceAndSnow();
        this.weatherThunderEnabled = this.getActiveConfig().getConfig().getWorld().getWeatherThunder();
        this.field_80004_Q = 0;
        this.mixinChunkProviderServer = (IMixinChunkProviderServer)this.func_72863_F();
        this.setMemoryViewDistance(this.chooseViewDistanceValue(this.getActiveConfig().getConfig().getWorld().getViewDistance()));
    }

    @Redirect(method={"init"}, at=@At(value="NEW", target="net/minecraft/world/storage/MapStorage"))
    private MapStorage onCreateMapStorage(ISaveHandler saveHandler) {
        WorldServer overWorld = WorldManager.getWorldByDimensionId(0).orElse(null);
        if (this.dimensionId != 0 && overWorld != null) {
            return overWorld.func_175693_T();
        }
        return new MapStorage(saveHandler);
    }

    @Redirect(method={"init"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/storage/MapStorage;setData(Ljava/lang/String;Lnet/minecraft/world/storage/WorldSavedData;)V"))
    private void onMapStorageSetData(MapStorage storage, String name, WorldSavedData data) {
        if (name.equals("scoreboard") && this.dimensionId != 0) {
            return;
        }
        storage.func_75745_a(name, data);
    }

    @Redirect(method={"init"}, at=@At(value="INVOKE", target="Lnet/minecraft/scoreboard/ScoreboardSaveData;setScoreboard(Lnet/minecraft/scoreboard/Scoreboard;)V"))
    private void onSetSaveDataScoreboard(ScoreboardSaveData scoreboardSaveData, Scoreboard scoreboard) {
        if (this.dimensionId != 0) {
            return;
        }
        scoreboardSaveData.func_96499_a(scoreboard);
    }

    @Inject(method={"createSpawnPosition"}, at={@At(value="HEAD")})
    private void onCreateBonusChest(CallbackInfo ci) {
        ((GenericGenerationContext)GenerationPhase.State.TERRAIN_GENERATION.createPhaseContext().source(this)).buildAndSwitch();
    }

    @Inject(method={"createSpawnPosition"}, at={@At(value="RETURN")})
    private void onCreateBonusChestEnd(CallbackInfo ci) {
        PhaseTracker.getInstance().completePhase(GenerationPhase.State.TERRAIN_GENERATION);
    }

    @Inject(method={"createSpawnPosition(Lnet/minecraft/world/WorldSettings;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCreateSpawnPosition(WorldSettings settings, CallbackInfo ci) {
        GeneratorType generatorType = (GeneratorType)settings.func_77165_h();
        if (!this.field_73011_w.func_76567_e() && this.getProperties().doesGenerateBonusChest()) {
            this.func_73047_i();
        }
        if (generatorType != null && generatorType.equals(GeneratorTypes.THE_END) || ((WorldServer)this).func_72863_F().field_186029_c instanceof ChunkGeneratorEnd) {
            this.field_72986_A.func_176143_a(new BlockPos(100, 50, 0));
            ci.cancel();
        }
    }

    @Redirect(method={"createSpawnPosition"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldSettings;isBonusChestEnabled()Z"))
    private boolean onIsBonusChestEnabled(WorldSettings settings) {
        return this.getProperties().doesGenerateBonusChest();
    }

    @Override
    public boolean isProcessingExplosion() {
        return this.processingExplosion;
    }

    @Override
    public boolean isMinecraftChunkLoaded(int x, int z, boolean allowEmpty) {
        return this.func_175680_a(x, z, allowEmpty);
    }

    @Override
    public SpongeConfig<WorldConfig> getWorldConfig() {
        return ((IMixinWorldInfo)this.field_72986_A).getOrCreateWorldConfig();
    }

    @Override
    public SpongeConfig<? extends GeneralConfigBase> getActiveConfig() {
        return this.activeConfig;
    }

    @Override
    public void setActiveConfig(SpongeConfig<? extends GeneralConfigBase> config) {
        this.activeConfig = config;
        this.chunkGCLoadThreshold = this.activeConfig.getConfig().getWorld().getChunkLoadThreadhold();
        this.chunkGCTickInterval = this.activeConfig.getConfig().getWorld().getTickInterval();
        this.weatherIceAndSnowEnabled = this.activeConfig.getConfig().getWorld().getWeatherIceAndSnow();
        this.weatherThunderEnabled = this.activeConfig.getConfig().getWorld().getWeatherThunder();
        this.chunkUnloadDelay = this.activeConfig.getConfig().getWorld().getChunkUnloadDelay() * 1000L;
        if (this.func_72863_F() != null) {
            int maxChunkUnloads = this.activeConfig.getConfig().getWorld().getMaxChunkUnloads();
            this.mixinChunkProviderServer.setMaxChunkUnloads(maxChunkUnloads < 1 ? 1 : maxChunkUnloads);
            this.mixinChunkProviderServer.setDenyChunkRequests(this.activeConfig.getConfig().getWorld().getDenyChunkRequests());
            for (net.minecraft.entity.Entity entity : this.field_72996_f) {
                if (entity instanceof IModData_Activation) {
                    ((IModData_Activation)entity).requiresActivationCacheRefresh(true);
                }
                if (!(entity instanceof IModData_Collisions)) continue;
                ((IModData_Collisions)entity).requiresCollisionsCacheRefresh(true);
            }
        }
    }

    @Override
    public boolean isLoaded() {
        return WorldManager.getWorldByDimensionId(this.getDimensionId()).isPresent();
    }

    @Override
    public UUID getUniqueId() {
        return (UUID)Preconditions.checkNotNull((Object)this.getProperties().getUniqueId(), (Object)"World Properties has a null UUID");
    }

    @Override
    public Path getDirectory() {
        File worldDirectory = this.field_73019_z.func_75765_b();
        if (worldDirectory == null) {
            new PrettyPrinter(60).add("A Server World has a null save directory!").centre().hr().add("%s : %s", "World Name", this.getName()).add("%s : %s", "Dimension", this.getProperties().getDimensionType()).add("Please report this to sponge developers so they may potentially fix this").trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
            return null;
        }
        return worldDirectory.toPath();
    }

    @Override
    public void updateWorldGenerator() {
        DataContainer generatorSettings = this.getProperties().getGeneratorSettings();
        SpongeWorldGenerator newGenerator = this.createWorldGenerator(generatorSettings);
        if (newGenerator.getBaseGenerationPopulator() instanceof IChunkGenerator) {
            if (WorldGenConstants.isValid((IChunkGenerator)newGenerator.getBaseGenerationPopulator(), IPopulatorProvider.class)) {
                ((IPopulatorProvider)((Object)newGenerator.getBaseGenerationPopulator())).addPopulators(newGenerator);
            }
        } else if (newGenerator.getBaseGenerationPopulator() instanceof IPopulatorProvider) {
            ((IPopulatorProvider)((Object)newGenerator.getBaseGenerationPopulator())).addPopulators(newGenerator);
        }
        for (WorldGeneratorModifier modifier : this.getProperties().getGeneratorModifiers()) {
            modifier.modifyWorldGenerator(this.getProperties(), generatorSettings, newGenerator);
        }
        this.spongegen = this.createChunkGenerator(newGenerator);
        this.spongegen.setGenerationPopulators(newGenerator.getGenerationPopulators());
        this.spongegen.setPopulators(newGenerator.getPopulators());
        this.spongegen.setBiomeOverrides(newGenerator.getBiomeSettings());
        ChunkProviderServer chunkProviderServer = this.func_72863_F();
        chunkProviderServer.field_186029_c = this.spongegen;
    }

    @Override
    public SpongeChunkGenerator createChunkGenerator(SpongeWorldGenerator newGenerator) {
        return new SpongeChunkGenerator((net.minecraft.world.World)this, newGenerator.getBaseGenerationPopulator(), newGenerator.getBiomeGenerator());
    }

    @Override
    public SpongeWorldGenerator createWorldGenerator(DataContainer settings) {
        Optional<String> optCustomSettings = settings.getString(DataQueries.WORLD_CUSTOM_SETTINGS);
        if (optCustomSettings.isPresent()) {
            return this.createWorldGenerator(optCustomSettings.get());
        }
        String jsonSettings = "";
        try {
            jsonSettings = DataFormats.JSON.write(settings);
        }
        catch (Exception e) {
            SpongeImpl.getLogger().warn("Failed to convert settings from [{}] for GeneratorType [{}] used by World [{}].", (Object)settings, (Object)((net.minecraft.world.World)this).func_175624_G(), (Object)this, (Object)e);
        }
        return this.createWorldGenerator(jsonSettings);
    }

    @Override
    public SpongeWorldGenerator createWorldGenerator(String settings) {
        BiomeProvider biomeProvider;
        IChunkGenerator chunkGenerator;
        WorldServer worldServer = (WorldServer)this;
        WorldType worldType = worldServer.func_175624_G();
        if (worldType instanceof SpongeWorldType) {
            chunkGenerator = ((SpongeWorldType)worldType).getChunkGenerator((net.minecraft.world.World)worldServer, settings);
            biomeProvider = ((SpongeWorldType)worldType).getBiomeProvider((net.minecraft.world.World)worldServer);
        } else {
            IChunkGenerator currentGenerator = this.func_72863_F().field_186029_c;
            if (currentGenerator != null) {
                chunkGenerator = currentGenerator;
            } else {
                WorldProvider worldProvider = worldServer.field_73011_w;
                ((IMixinWorldProvider)worldProvider).setGeneratorSettings(settings);
                chunkGenerator = worldProvider.func_186060_c();
            }
            biomeProvider = worldServer.field_73011_w.field_76578_c;
        }
        return new SpongeWorldGenerator((net.minecraft.world.World)worldServer, (BiomeGenerator)biomeProvider, SpongeGenerationPopulator.of((net.minecraft.world.World)worldServer, chunkGenerator));
    }

    @Override
    public WorldGenerator getWorldGenerator() {
        return this.spongegen;
    }

    @Override
    public WorldServer asMinecraftWorld() {
        return (WorldServer)this;
    }

    @Override
    public World asSpongeWorld() {
        return this;
    }

    @Override
    @Overwrite
    protected void func_147456_g() {
        this.func_184162_i();
        if (this.field_72986_A.func_76067_t() == WorldType.field_180272_g) {
            Iterator iterator1 = this.field_73063_M.func_187300_b();
            while (iterator1.hasNext()) {
                ((Chunk)iterator1.next()).func_150804_b(false);
            }
            return;
        }
        int i = this.shadow$func_82736_K().func_180263_c("randomTickSpeed");
        boolean flag = this.func_72896_J();
        boolean flag1 = this.func_72911_I();
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        Iterator<Chunk> iterator = SpongeImplHooks.getChunkIterator((WorldServer)this);
        while (iterator.hasNext()) {
            Throwable throwable;
            Object context;
            int k;
            int j;
            net.minecraft.world.World world;
            Chunk chunk;
            block64: {
                chunk = iterator.next();
                world = chunk.func_177412_p();
                j = chunk.field_76635_g * 16;
                k = chunk.field_76647_h * 16;
                this.timings.updateBlocksCheckNextLight.startTiming();
                chunk.func_76594_o();
                this.timings.updateBlocksCheckNextLight.stopTiming();
                this.timings.updateBlocksChunkTick.startTiming();
                chunk.func_150804_b(false);
                this.timings.updateBlocksChunkTick.stopTiming();
                if (!((IMixinChunk)chunk).areNeighborsLoaded()) continue;
                this.timings.updateBlocksThunder.startTiming();
                if (this.weatherThunderEnabled && SpongeImplHooks.canDoLightning(this.field_73011_w, chunk) && flag && flag1 && this.field_73012_v.nextInt(100000) == 0) {
                    context = ((PhaseContext)((PhaseContext)TickPhase.Tick.WEATHER.createPhaseContext()).source(this)).buildAndSwitch();
                    throwable = null;
                    try {
                        this.field_73005_l = this.field_73005_l * 3 + 1013904223;
                        int l = this.field_73005_l >> 2;
                        BlockPos blockpos = this.func_175736_a(new BlockPos(j + (l & 0xF), 0, k + (l >> 8 & 0xF)));
                        if (!this.func_175727_C(blockpos)) break block64;
                        DifficultyInstance difficultyinstance = this.func_175649_E(blockpos);
                        Transform<MixinWorldServer> transform = new Transform<MixinWorldServer>(this, VecHelper.toVector3d(blockpos).toDouble());
                        if (world.func_82736_K().func_82766_b("doMobSpawning") && this.field_73012_v.nextDouble() < (double)difficultyinstance.func_180168_b() * 0.01) {
                            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                                Sponge.getCauseStackManager().pushCause(this.getWeather());
                                Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.WEATHER);
                                ConstructEntityEvent.Pre constructEntityEvent = SpongeEventFactory.createConstructEntityEventPre(Sponge.getCauseStackManager().getCurrentCause(), EntityTypes.HORSE, transform);
                                SpongeImpl.postEvent(constructEntityEvent);
                                if (!constructEntityEvent.isCancelled()) {
                                    EntitySkeletonHorse entityhorse = new EntitySkeletonHorse((net.minecraft.world.World)((WorldServer)this));
                                    entityhorse.func_190691_p(true);
                                    entityhorse.func_70873_a(0);
                                    entityhorse.func_70107_b((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
                                    this.func_72838_d((net.minecraft.entity.Entity)entityhorse);
                                }
                                ConstructEntityEvent.Pre lightning = SpongeEventFactory.createConstructEntityEventPre(Sponge.getCauseStackManager().getCurrentCause(), EntityTypes.LIGHTNING, transform);
                                SpongeImpl.postEvent(lightning);
                                if (!lightning.isCancelled()) {
                                    this.func_72942_c((net.minecraft.entity.Entity)new EntityLightningBolt(world, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), true));
                                }
                                break block64;
                            }
                        }
                        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                            Sponge.getCauseStackManager().pushCause(this.getWeather());
                            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.WEATHER);
                            ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(Sponge.getCauseStackManager().getCurrentCause(), EntityTypes.LIGHTNING, transform);
                            SpongeImpl.postEvent(event);
                            if (!event.isCancelled()) {
                                this.func_72942_c((net.minecraft.entity.Entity)new EntityLightningBolt(world, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), false));
                            }
                        }
                    }
                    catch (Throwable l) {
                        throwable = l;
                        throw l;
                    }
                    finally {
                        if (context != null) {
                            if (throwable != null) {
                                try {
                                    ((PhaseContext)context).close();
                                }
                                catch (Throwable l) {
                                    throwable.addSuppressed(l);
                                }
                            } else {
                                ((PhaseContext)context).close();
                            }
                        }
                    }
                }
            }
            this.timings.updateBlocksThunder.stopTiming();
            this.timings.updateBlocksIceAndSnow.startTiming();
            if (this.weatherIceAndSnowEnabled && SpongeImplHooks.canDoRainSnowIce(this.field_73011_w, chunk) && this.field_73012_v.nextInt(16) == 0) {
                context = ((PhaseContext)((PhaseContext)TickPhase.Tick.WEATHER.createPhaseContext()).source(this)).buildAndSwitch();
                throwable = null;
                try {
                    this.field_73005_l = this.field_73005_l * 3 + 1013904223;
                    int j2 = this.field_73005_l >> 2;
                    BlockPos blockpos1 = this.func_175725_q(new BlockPos(j + (j2 & 0xF), 0, k + (j2 >> 8 & 0xF)));
                    BlockPos blockpos2 = blockpos1.func_177977_b();
                    if (this.func_175662_w(blockpos2)) {
                        this.func_175656_a(blockpos2, Blocks.field_150432_aD.func_176223_P());
                    }
                    if (flag && this.func_175708_f(blockpos1, true)) {
                        this.func_175656_a(blockpos1, Blocks.field_150431_aC.func_176223_P());
                    }
                    if (flag && this.func_180494_b(blockpos2).func_76738_d()) {
                        this.func_180495_p(blockpos2).func_177230_c().func_176224_k((net.minecraft.world.World)((WorldServer)this), blockpos2);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (context != null) {
                        if (throwable != null) {
                            try {
                                ((PhaseContext)context).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((PhaseContext)context).close();
                        }
                    }
                }
            }
            this.timings.updateBlocksIceAndSnow.stopTiming();
            this.timings.updateBlocksRandomTick.startTiming();
            if (i <= 0) continue;
            for (ExtendedBlockStorage extendedblockstorage : chunk.func_76587_i()) {
                if (extendedblockstorage == Chunk.field_186036_a || !extendedblockstorage.func_76675_b()) continue;
                for (int i1 = 0; i1 < i; ++i1) {
                    this.field_73005_l = this.field_73005_l * 3 + 1013904223;
                    int j1 = this.field_73005_l >> 2;
                    int k1 = j1 & 0xF;
                    int i2 = j1 >> 16 & 0xF;
                    int l1 = j1 >> 8 & 0xF;
                    IBlockState iblockstate = extendedblockstorage.func_177485_a(k1, i2, l1);
                    Block block = iblockstate.func_177230_c();
                    if (!block.func_149653_t()) continue;
                    BlockPos pos = new BlockPos(k1 + j, i2 + extendedblockstorage.func_76662_d(), l1 + k);
                    IMixinBlock spongeBlock = (IMixinBlock)block;
                    spongeBlock.getTimingsHandler().startTiming();
                    PhaseData currentTuple = phaseTracker.getCurrentPhaseData();
                    IPhaseState<?> phaseState = currentTuple.state;
                    if (phaseState.alreadyCapturingBlockTicks(currentTuple.context)) {
                        block.func_180645_a(world, pos, iblockstate, this.field_73012_v);
                    } else {
                        TrackingUtil.randomTickBlock(phaseTracker, this, block, pos, iblockstate, this.field_73012_v);
                    }
                    spongeBlock.getTimingsHandler().stopTiming();
                }
            }
        }
        this.timings.updateBlocksRandomTick.stopTiming();
    }

    @Redirect(method={"updateBlockTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer;isAreaLoaded(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean onBlockTickIsAreaLoaded(WorldServer worldIn, BlockPos fromPos, BlockPos toPos) {
        Chunk chunk;
        int posX = fromPos.func_177958_n() + 8;
        int posZ = fromPos.func_177952_p() + 8;
        if (fromPos.equals((Object)toPos)) {
            posX = fromPos.func_177958_n();
            posZ = fromPos.func_177952_p();
        }
        return (chunk = this.mixinChunkProviderServer.getLoadedChunkWithoutMarkingActive(posX >> 4, posZ >> 4)) != null && ((IMixinChunk)chunk).areNeighborsLoaded();
    }

    @Override
    @Overwrite
    public void func_72939_s() {
        TrackingUtil.tickWorldProvider(this);
        super.func_72939_s();
    }

    @Redirect(method={"updateBlockTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;updateTick(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Ljava/util/Random;)V"))
    private void onUpdateBlockTick(Block block, net.minecraft.world.World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.onUpdateTick(block, worldIn, pos, state, rand);
    }

    @Redirect(method={"tickUpdates"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;updateTick(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Ljava/util/Random;)V"))
    private void onUpdateTick(Block block, net.minecraft.world.World worldIn, BlockPos pos, IBlockState state, Random rand) {
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        PhaseData phaseData = phaseTracker.getCurrentPhaseData();
        IPhaseState<?> phaseState = phaseData.state;
        if (phaseState.alreadyCapturingBlockTicks(phaseData.context) || phaseState.ignoresBlockUpdateTick(phaseData)) {
            block.func_180650_b(worldIn, pos, state, rand);
            return;
        }
        IMixinBlock spongeBlock = (IMixinBlock)block;
        spongeBlock.getTimingsHandler().startTiming();
        TrackingUtil.updateTickBlock(this, block, pos, state, rand);
        spongeBlock.getTimingsHandler().stopTiming();
    }

    @Redirect(method={"tickUpdates"}, at=@At(value="INVOKE", target="Lnet/minecraft/crash/CrashReportCategory;addBlockInfo(Lnet/minecraft/crash/CrashReportCategory;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)V"))
    private void onBlockInfo(CrashReportCategory category, BlockPos pos, IBlockState state) {
        try {
            CrashReportCategory.func_175750_a((CrashReportCategory)category, (BlockPos)pos, (IBlockState)state);
        }
        catch (NoClassDefFoundError e) {
            SpongeImpl.getLogger().error("An error occurred while adding crash report info!", (Throwable)e);
            SpongeImpl.getLogger().error("Original caught error:", category.field_85078_a.field_71511_b);
            throw new ReportedException(category.field_85078_a);
        }
    }

    @Redirect(method={"addBlockEvent"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer$ServerBlockEventList;add(Ljava/lang/Object;)Z", remap=false))
    private boolean onAddBlockEvent(WorldServer.ServerBlockEventList list, Object obj, BlockPos pos, Block blockIn, int eventId, int eventParam) {
        BlockEventData blockEventData = (BlockEventData)obj;
        IMixinBlockEventData blockEvent = (IMixinBlockEventData)blockEventData;
        if (blockIn instanceof BlockPistonBase) {
            if (SpongeCommonEventFactory.handlePistonEvent(this, list, obj, pos, blockIn, eventId, eventParam)) {
                return false;
            }
            blockEvent.setCaptureBlocks(false);
        } else if (SpongeCommonEventFactory.callChangeBlockEventPre(this, pos).isCancelled()) {
            return false;
        }
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        PhaseData currentPhase = phaseTracker.getCurrentPhaseData();
        IPhaseState<?> phaseState = currentPhase.state;
        if (phaseState.ignoresBlockEvent()) {
            return list.add((Object)((BlockEventData)obj));
        }
        PhaseContext<?> context = currentPhase.context;
        LocatableBlock locatable = LocatableBlock.builder().location(new Location<World>((World)this, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).state(this.getBlock(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).build();
        blockEvent.setTickBlock(locatable);
        phaseState.addNotifierToBlockEvent(context, this, pos, blockEvent);
        return list.add((Object)((BlockEventData)obj));
    }

    @Redirect(method={"sendQueuedBlockEvents"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer;fireBlockEvent(Lnet/minecraft/block/BlockEventData;)Z"))
    private boolean onFireBlockEvent(WorldServer worldIn, BlockEventData event) {
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        IPhaseState<?> phaseState = phaseTracker.getCurrentState();
        if (phaseState.ignoresBlockEvent()) {
            return this.func_147485_a(event);
        }
        return TrackingUtil.fireMinecraftBlockEvent(worldIn, event);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/IChunkProvider;tick()Z"))
    private boolean onTicktick(IChunkProvider chunkProvider) {
        if (this.chunkGCTickInterval > 0) {
            return false;
        }
        return chunkProvider.func_73156_b();
    }

    @Override
    public void doChunkGC() {
        ++this.chunkGCTickCount;
        ChunkProviderServer chunkProviderServer = this.func_72863_F();
        int chunkLoadCount = this.func_72863_F().func_73152_e();
        if (chunkLoadCount >= this.chunkGCLoadThreshold && this.chunkGCLoadThreshold > 0) {
            chunkLoadCount = 0;
        } else if (this.chunkGCTickCount >= this.chunkGCTickInterval && this.chunkGCTickInterval > 0) {
            this.chunkGCTickCount = 0;
        } else {
            return;
        }
        for (Chunk chunk : chunkProviderServer.func_189548_a()) {
            IMixinChunk spongeChunk = (IMixinChunk)chunk;
            if (chunk.field_189550_d || spongeChunk.isPersistedChunk() || !this.field_73011_w.func_186056_c(chunk.field_76635_g, chunk.field_76647_h) || ((IMixinPlayerChunkMap)this.func_184164_w()).isChunkInUse(chunk.field_76635_g, chunk.field_76647_h)) continue;
            chunkProviderServer.func_189549_a(chunk);
            SpongeHooks.logChunkGCQueueUnload(chunkProviderServer.field_73251_h, chunk);
        }
    }

    @Override
    public boolean save() throws IOException {
        if (!this.func_72863_F().func_73157_c()) {
            return false;
        }
        try {
            WorldManager.saveWorld((WorldServer)this, true);
        }
        catch (MinecraftException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Inject(method={"saveLevel"}, at={@At(value="HEAD")})
    private void onSaveLevel(CallbackInfo ci) {
        for (WorldServer worldServer : this.field_73061_a.field_71305_c) {
            worldServer.field_73011_w.func_186057_q();
        }
    }

    @Redirect(method={"saveAllChunks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/gen/ChunkProviderServer;canSave()Z"))
    private boolean canChunkProviderSave(ChunkProviderServer chunkProviderServer) {
        if (chunkProviderServer.func_73157_c()) {
            Sponge.getEventManager().post(SpongeEventFactory.createSaveWorldEventPre(Sponge.getCauseStackManager().getCurrentCause(), this));
            return true;
        }
        return false;
    }

    @Inject(method={"saveAllChunks"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/gen/ChunkProviderServer;getLoadedChunks()Ljava/util/Collection;")}, cancellable=true)
    private void onSaveAllChunks(boolean saveAllChunks, IProgressUpdate progressCallback, CallbackInfo ci) {
        Sponge.getEventManager().post(SpongeEventFactory.createSaveWorldEventPost(Sponge.getCauseStackManager().getCurrentCause(), this));
        if (this.chunkGCTickInterval > 0) {
            ci.cancel();
        }
    }

    @Redirect(method={"sendQueuedBlockEvents"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/DimensionType;getId()I"), expect=0, require=0)
    private int onGetDimensionIdForBlockEvents(DimensionType dimensionType) {
        return this.getDimensionId();
    }

    @Override
    public Collection<ScheduledBlockUpdate> getScheduledUpdates(int x, int y, int z) {
        BlockPos position = new BlockPos(x, y, z);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (NextTickListEntry sbu : this.field_73065_O) {
            if (!sbu.field_180282_a.equals((Object)position)) continue;
            builder.add((Object)((ScheduledBlockUpdate)sbu));
        }
        return builder.build();
    }

    @Redirect(method={"updateBlockTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/NextTickListEntry;setPriority(I)V"))
    private void onCreateScheduledBlockUpdate(NextTickListEntry sbu, int priority) {
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        IPhaseState<?> phaseState = phaseTracker.getCurrentState();
        if (phaseState.ignoresScheduledUpdates()) {
            this.tmpScheduledObj = sbu;
            return;
        }
        sbu.func_82753_a(priority);
        ((IMixinNextTickListEntry)sbu).setWorld((net.minecraft.world.World)((WorldServer)this));
        this.tmpScheduledObj = sbu;
    }

    @Override
    public ScheduledBlockUpdate addScheduledUpdate(int x, int y, int z, int priority, int ticks) {
        BlockPos pos = new BlockPos(x, y, z);
        this.func_175654_a(pos, this.func_180495_p(pos).func_177230_c(), ticks, priority);
        ScheduledBlockUpdate sbu = (ScheduledBlockUpdate)this.tmpScheduledObj;
        this.tmpScheduledObj = null;
        return sbu;
    }

    @Override
    public void removeScheduledUpdate(int x, int y, int z, ScheduledBlockUpdate update) {
        this.field_73064_N.remove(update);
        this.field_73065_O.remove(update);
    }

    @Redirect(method={"updateAllPlayersSleepingFlag()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;isSpectator()Z"))
    private boolean isSpectatorOrIgnored(EntityPlayer entityPlayer) {
        boolean ignore = entityPlayer instanceof Player && ((Player)entityPlayer).isSleepingIgnored();
        return ignore || entityPlayer.func_175149_v();
    }

    @Redirect(method={"areAllPlayersAsleep()Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;isPlayerFullyAsleep()Z"))
    private boolean isPlayerFullyAsleep(EntityPlayer entityPlayer) {
        boolean ignore = entityPlayer instanceof Player && ((Player)entityPlayer).isSleepingIgnored();
        return ignore || entityPlayer.func_71026_bH();
    }

    @Redirect(method={"areAllPlayersAsleep()Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;isSpectator()Z"))
    private boolean isSpectatorAndNotIgnored(EntityPlayer entityPlayer) {
        boolean ignore = entityPlayer instanceof Player && ((Player)entityPlayer).isSleepingIgnored();
        return !ignore && entityPlayer.func_175149_v();
    }

    @Override
    public Optional<Entity> getEntity(UUID uuid) {
        return Optional.ofNullable((Entity)this.func_175733_a(uuid));
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState blockState, BlockChangeFlag flag) {
        this.checkBlockBounds(x, y, z);
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        PhaseData peek = phaseTracker.getCurrentPhaseData();
        boolean isWorldGen = peek.state.isWorldGeneration();
        boolean handlesOwnCompletion = peek.state.handlesOwnStateCompletion();
        if (!isWorldGen) {
            Preconditions.checkArgument((flag != null ? 1 : 0) != 0, (Object)"BlockChangeFlag cannot be null!");
        }
        try (PhaseContext context = isWorldGen || handlesOwnCompletion ? null : (PhaseContext)PluginPhase.State.BLOCK_WORKER.createPhaseContext().buildAndSwitch();){
            boolean bl = this.setBlockState(new BlockPos(x, y, z), (IBlockState)blockState, flag);
            return bl;
        }
    }

    private void checkBlockBounds(int x, int y, int z) {
        if (!this.containsBlock(x, y, z)) {
            throw new PositionOutOfBoundsException(new Vector3i(x, y, z), BLOCK_MIN, BLOCK_MAX);
        }
    }

    @Override
    public BlockSnapshot createSnapshot(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState currentState = this.func_180495_p(pos);
        return this.createSpongeBlockSnapshot(currentState, currentState.func_185899_b((IBlockAccess)((WorldServer)this), pos), pos, BlockChangeFlags.PHYSICS_OBSERVER);
    }

    @Override
    public Collection<Entity> spawnEntities(Iterable<? extends Entity> entities) {
        NonNullArrayList entitiesToSpawn = new NonNullArrayList();
        entities.forEach(entitiesToSpawn::add);
        SpawnEntityEvent.Custom event = SpongeEventFactory.createSpawnEntityEventCustom(Sponge.getCauseStackManager().getCurrentCause(), entitiesToSpawn);
        if (Sponge.getEventManager().post(event)) {
            return ImmutableList.of();
        }
        for (Entity entity : event.getEntities()) {
            this.forceSpawnEntity(entity);
        }
        return (Collection)event.getEntities().stream().filter(Entity::isLoaded).collect(ImmutableList.toImmutableList());
    }

    @Redirect(method={"addWeatherEffect"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/DimensionType;getId()I"), expect=0, require=0)
    private int getDimensionIdForWeatherEffect(DimensionType id) {
        return this.getDimensionId();
    }

    @Final
    @Inject(method={"loadEntities"}, at={@At(value="HEAD")}, cancellable=true)
    private void spongeLoadEntities(Collection<net.minecraft.entity.Entity> entities, CallbackInfo callbackInfo) {
        if (entities.isEmpty()) {
            callbackInfo.cancel();
            return;
        }
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        for (net.minecraft.entity.Entity entity : entities) {
            if (((IMixinBlockPos)entity.func_180425_c()).isInvalidYPosition()) {
                entity.func_70106_y();
                continue;
            }
            if (!this.func_184165_i(entity)) continue;
            entityList.add((Entity)entity);
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.CHUNK_LOAD);
            Sponge.getCauseStackManager().pushCause(this);
            SpawnEntityEvent.ChunkLoad chunkLoad = SpongeEventFactory.createSpawnEntityEventChunkLoad(Sponge.getCauseStackManager().getCurrentCause(), Lists.newArrayList(entityList));
            SpongeImpl.postEvent(chunkLoad);
            if (!chunkLoad.isCancelled() && chunkLoad.getEntities().size() > 0) {
                for (Entity successful : chunkLoad.getEntities()) {
                    this.field_72996_f.add((net.minecraft.entity.Entity)successful);
                    this.func_72923_a((net.minecraft.entity.Entity)successful);
                }
            }
            for (Entity entity : entityList) {
                if (chunkLoad.getEntities().contains(entity)) continue;
                ((net.minecraft.world.World)this).func_72973_f((net.minecraft.entity.Entity)entity);
            }
            callbackInfo.cancel();
        }
    }

    @Override
    public void triggerExplosion(org.spongepowered.api.world.explosion.Explosion explosion) {
        Preconditions.checkNotNull((Object)explosion, (Object)"explosion");
        Location<World> origin = explosion.getLocation();
        Preconditions.checkNotNull(origin, (Object)"location");
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        try (Object phaseContext = PluginPhase.State.CUSTOM_EXPLOSION.createPhaseContext().explosion(explosion).buildAndSwitch();){
            Explosion mcExplosion;
            try {
                mcExplosion = (Explosion)explosion;
            }
            catch (Exception e) {
                new PrettyPrinter(60).add("Explosion not compatible with this implementation").centre().hr().add("An explosion that was expected to be used for this implementation does not").add("originate from this implementation.").add(e).trace();
                if (phaseContext != null) {
                    if (var5_5 != null) {
                        try {
                            ((PhaseContext)phaseContext).close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        ((PhaseContext)phaseContext).close();
                    }
                }
                return;
            }
            double x = mcExplosion.field_77284_b;
            double y = mcExplosion.field_77285_c;
            double z = mcExplosion.field_77282_d;
            boolean damagesTerrain = mcExplosion.field_82755_b;
            float strength = explosion.getRadius();
            ExplosionEvent.Pre event = SpongeEventFactory.createExplosionEventPre(Sponge.getCauseStackManager().getCurrentCause(), explosion, this);
            if (SpongeImpl.postEvent(event)) {
                this.processingExplosion = false;
                return;
            }
            mcExplosion.func_77278_a();
            mcExplosion.func_77279_a(false);
            if (!damagesTerrain) {
                mcExplosion.func_180342_d();
            }
            for (EntityPlayer entityplayer : this.field_73010_i) {
                if (!(entityplayer.func_70092_e(x, y, z) < 4096.0)) continue;
                ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)new SPacketExplosion(x, y, z, strength, mcExplosion.func_180343_e(), (Vec3d)mcExplosion.func_77277_b().get(entityplayer)));
            }
            this.processingExplosion = false;
        }
    }

    @Override
    public void triggerInternalExplosion(org.spongepowered.api.world.explosion.Explosion explosion) {
        Preconditions.checkNotNull((Object)explosion, (Object)"explosion");
        Location<World> origin = explosion.getLocation();
        Preconditions.checkNotNull(origin, (Object)"location");
        this.func_72885_a(EntityUtil.toNullableNative(explosion.getSourceExplosive().orElse(null)), origin.getX(), origin.getY(), origin.getZ(), explosion.getRadius(), explosion.canCauseFire(), explosion.shouldBreakBlocks());
    }

    @Override
    public boolean func_72838_d(net.minecraft.entity.Entity entity) {
        if (!PhaseTracker.validateEntitySpawn(this, (Entity)entity)) {
            return true;
        }
        return this.func_184165_i(entity) && PhaseTracker.getInstance().spawnEntity(this, EntityUtil.fromNative(entity));
    }

    @Override
    public boolean func_180501_a(BlockPos pos, IBlockState newState, int flags) {
        if (!this.func_175701_a(pos)) {
            return false;
        }
        if (this.field_72986_A.func_76067_t() == WorldType.field_180272_g) {
            return false;
        }
        return PhaseTracker.getInstance().setBlockState((IMixinWorldServer)this, pos.func_185334_h(), newState, flags);
    }

    @Override
    public boolean setBlockState(BlockPos pos, IBlockState state, BlockChangeFlag flag) {
        if (!this.func_175701_a(pos)) {
            return false;
        }
        if (this.field_72986_A.func_76067_t() == WorldType.field_180272_g) {
            return false;
        }
        return PhaseTracker.getInstance().setBlockState((IMixinWorldServer)this, pos.func_185334_h(), state, flag);
    }

    @Override
    public void func_189507_a(BlockPos pos, IBlockState state, Random random) {
        this.field_72999_e = true;
        PhaseData peek = PhaseTracker.getInstance().getCurrentPhaseData();
        if (peek.state.ignoresBlockUpdateTick(peek)) {
            state.func_177230_c().func_180650_b((net.minecraft.world.World)((WorldServer)this), pos, state, random);
            this.field_72999_e = false;
            return;
        }
        TrackingUtil.updateTickBlock(this, state.func_177230_c(), pos, state, random);
        this.field_72999_e = false;
    }

    @Override
    public void func_190524_a(BlockPos pos, Block blockIn, BlockPos otherPos) {
        PhaseTracker.getInstance().notifyBlockOfStateChange(this, pos, blockIn, otherPos);
    }

    @Override
    public void func_175695_a(BlockPos pos, Block blockType, EnumFacing skipSide) {
        if (!this.func_175701_a(pos)) {
            return;
        }
        EnumSet<EnumFacing> directions = EnumSet.copyOf(NOTIFY_DIRECTIONS);
        directions.remove(skipSide);
        NotifyNeighborBlockEvent event = SpongeCommonEventFactory.callNotifyNeighborEvent(this, pos, directions);
        if (event == null || !event.isCancelled()) {
            PhaseTracker phaseTracker = PhaseTracker.getInstance();
            for (EnumFacing facing : EnumFacing.values()) {
                if (event != null) {
                    Direction direction = DirectionFacingProvider.getInstance().getKey(facing).get();
                    if (!event.getNeighbors().keySet().contains((Object)direction)) continue;
                }
                phaseTracker.notifyBlockOfStateChange(this, pos.func_177972_a(facing), blockType, pos);
            }
        }
    }

    @Override
    public void func_175685_c(BlockPos pos, Block blockType, boolean updateObserverBlocks) {
        if (!this.func_175701_a(pos)) {
            return;
        }
        NotifyNeighborBlockEvent event = SpongeCommonEventFactory.callNotifyNeighborEvent(this, pos, NOTIFY_DIRECTIONS);
        if (event == null || !event.isCancelled()) {
            PhaseTracker phaseTracker = PhaseTracker.getInstance();
            for (EnumFacing facing : EnumFacing.values()) {
                if (event != null) {
                    Direction direction = DirectionFacingProvider.getInstance().getKey(facing).get();
                    if (!event.getNeighbors().keySet().contains((Object)direction)) continue;
                }
                phaseTracker.notifyBlockOfStateChange(this, pos.func_177972_a(facing), blockType, pos);
            }
        }
        if (updateObserverBlocks) {
            this.func_190522_c(pos, blockType);
        }
    }

    @Override
    public void onUpdateWeatherEffect(net.minecraft.entity.Entity entityIn) {
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        IPhaseState<?> state = phaseTracker.getCurrentState();
        if (state.alreadyCapturingEntityTicks()) {
            entityIn.func_70071_h_();
            return;
        }
        TrackingUtil.tickEntity(entityIn);
        this.updateRotation(entityIn);
    }

    @Override
    public void onUpdateTileEntities(ITickable tile) {
        this.updateTileEntity(tile);
    }

    private void updateTileEntity(ITickable tile) {
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        IPhaseState<?> state = phaseTracker.getCurrentState();
        if (state.alreadyCapturingTileTicks()) {
            tile.func_73660_a();
            return;
        }
        TrackingUtil.tickTileEntity(this, tile);
    }

    @Override
    public void onCallEntityUpdate(net.minecraft.entity.Entity entity) {
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        IPhaseState<?> state = phaseTracker.getCurrentState();
        if (state.alreadyCapturingEntityTicks()) {
            entity.func_70071_h_();
            return;
        }
        TrackingUtil.tickEntity(entity);
        this.updateRotation(entity);
    }

    @Override
    public void onCallEntityRidingUpdate(net.minecraft.entity.Entity entity) {
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        IPhaseState<?> state = phaseTracker.getCurrentState();
        if (state.alreadyCapturingEntityTicks()) {
            entity.func_70098_U();
            return;
        }
        TrackingUtil.tickRidingEntity(entity);
        this.updateRotation(entity);
    }

    @Redirect(method={"wakeAllPlayers"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;wakeUpPlayer(ZZZ)V"))
    private void spongeWakeUpPlayer(EntityPlayer player, boolean immediately, boolean updateWorldFlag, boolean setSpawn) {
        try (BasicEntityContext basicEntityContext = (BasicEntityContext)((BasicEntityContext)((BasicEntityContext)EntityPhase.State.PLAYER_WAKE_UP.createPhaseContext().source(player)).addCaptures()).buildAndSwitch();){
            player.func_70999_a(immediately, updateWorldFlag, setSpawn);
        }
    }

    @Override
    public void spongeNotifyNeighborsPostBlockChange(BlockPos pos, IBlockState oldState, IBlockState newState, BlockChangeFlag flags) {
        if (flags.updateNeighbors()) {
            this.func_175722_b(pos, newState.func_177230_c(), true);
            if (newState.func_185912_n()) {
                this.func_175666_e(pos, newState.func_177230_c());
            }
        }
    }

    @Override
    public void addEntityRotationUpdate(net.minecraft.entity.Entity entity, Vector3d rotation) {
        this.rotationUpdates.put(entity, rotation);
    }

    @Override
    public void updateRotation(net.minecraft.entity.Entity entityIn) {
        Vector3d rotationUpdate = this.rotationUpdates.get(entityIn);
        if (rotationUpdate != null) {
            entityIn.field_70125_A = (float)rotationUpdate.getX();
            entityIn.field_70177_z = (float)rotationUpdate.getY();
        }
        this.rotationUpdates.remove(entityIn);
    }

    @Override
    public void onSpongeEntityAdded(net.minecraft.entity.Entity entity) {
        this.func_72923_a(entity);
        ((IMixinEntity)entity).onJoinWorld();
    }

    @Override
    public void onSpongeEntityRemoved(net.minecraft.entity.Entity entity) {
        this.func_72847_b(entity);
    }

    @Override
    public boolean spawnEntity(Entity entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"The entity cannot be null!");
        if (!PhaseTracker.validateEntitySpawn(this, entity)) {
            return true;
        }
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        IPhaseState<?> state = phaseTracker.getCurrentState();
        if (!state.alreadyCapturingEntitySpawns()) {
            try (BasicPluginContext context = (BasicPluginContext)((BasicPluginContext)PluginPhase.State.CUSTOM_SPAWN.createPhaseContext().addCaptures()).buildAndSwitch();){
                phaseTracker.spawnEntityWithCause(this, entity);
                boolean bl = true;
                return bl;
            }
        }
        return phaseTracker.spawnEntityWithCause(this, entity);
    }

    @Override
    public boolean forceSpawnEntity(Entity entity) {
        net.minecraft.entity.Entity minecraftEntity = (net.minecraft.entity.Entity)entity;
        int x = minecraftEntity.func_180425_c().func_177958_n();
        int z = minecraftEntity.func_180425_c().func_177952_p();
        return this.forceSpawnEntity(minecraftEntity, x >> 4, z >> 4);
    }

    private boolean forceSpawnEntity(net.minecraft.entity.Entity entity, int chunkX, int chunkZ) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            this.field_73010_i.add(entityplayer);
            this.func_72854_c();
        }
        if (entity instanceof EntityLightningBolt) {
            this.func_72942_c(entity);
            return true;
        }
        this.func_72964_e(chunkX, chunkZ).func_76612_a(entity);
        this.field_72996_f.add(entity);
        this.onSpongeEntityAdded(entity);
        return true;
    }

    @Override
    public SpongeBlockSnapshot createSpongeBlockSnapshot(IBlockState state, IBlockState extended, BlockPos pos, BlockChangeFlag updateFlag) {
        TileEntity te;
        this.builder.reset();
        this.builder.blockState((BlockState)state).extendedState((BlockState)extended).worldId(this.getUniqueId()).position(VecHelper.toVector3i(pos));
        Optional<UUID> creator = this.getCreator(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        Optional<UUID> notifier = this.getNotifier(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (creator.isPresent()) {
            this.builder.creator(creator.get());
        }
        if (notifier.isPresent()) {
            this.builder.notifier(notifier.get());
        }
        if (state.func_177230_c() instanceof ITileEntityProvider && (te = this.func_175625_s(pos)) != null) {
            org.spongepowered.api.block.tileentity.TileEntity tile = (org.spongepowered.api.block.tileentity.TileEntity)te;
            for (DataManipulator<?, ?> manipulator : ((IMixinCustomDataHolder)((Object)tile)).getCustomManipulators()) {
                this.builder.add((DataManipulator)manipulator);
            }
            NBTTagCompound nbt = new NBTTagCompound();
            try {
                te.func_189515_b(nbt);
                this.builder.unsafeNbt(nbt);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new SpongeBlockSnapshot(this.builder, (SpongeBlockChangeFlag)updateFlag);
    }

    @Override
    @Overwrite
    public Explosion func_72885_a(@Nullable net.minecraft.entity.Entity entityIn, double x, double y, double z, float strength, boolean isFlaming, boolean isSmoking) {
        Explosion explosion = new Explosion((net.minecraft.world.World)((WorldServer)this), entityIn, x, y, z, strength, isFlaming, isSmoking);
        try (ExplosionContext context = (ExplosionContext)GeneralPhase.State.EXPLOSION.createPhaseContext().potentialExplosionSource((WorldServer)this, entityIn).explosion(explosion).buildAndSwitch();){
            this.processingExplosion = true;
            ExplosionEvent.Pre event = SpongeEventFactory.createExplosionEventPre(Sponge.getCauseStackManager().getCurrentCause(), (org.spongepowered.api.world.explosion.Explosion)explosion, this);
            if (SpongeImpl.postEvent(event)) {
                this.processingExplosion = false;
                Explosion explosion2 = explosion;
                return explosion2;
            }
            explosion.func_77278_a();
            explosion.func_77279_a(false);
            if (!isSmoking) {
                explosion.func_180342_d();
            }
            for (EntityPlayer entityplayer : this.field_73010_i) {
                if (!(entityplayer.func_70092_e(x, y, z) < 4096.0)) continue;
                ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)new SPacketExplosion(x, y, z, strength, explosion.func_180343_e(), (Vec3d)explosion.func_77277_b().get(entityplayer)));
            }
            this.processingExplosion = false;
            Explosion explosion3 = explosion;
            return explosion3;
        }
    }

    @Override
    public IBlockState func_180495_p(BlockPos pos) {
        if (((IMixinBlockPos)pos).isInvalidYPosition()) {
            return Blocks.field_150350_a.func_176223_P();
        }
        boolean forceChunkRequests = this.mixinChunkProviderServer.getForceChunkRequests();
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        IPhaseState<?> currentState = phaseTracker.getCurrentState();
        if (currentState == TickPhase.Tick.TILE_ENTITY) {
            ((IMixinChunkProviderServer)this.func_72863_F()).setForceChunkRequests(true);
        }
        Chunk chunk = this.func_175726_f(pos);
        this.mixinChunkProviderServer.setForceChunkRequests(forceChunkRequests);
        return chunk.func_177435_g(pos);
    }

    @Override
    public boolean spongeIsAreaLoadedForCheckingLight(net.minecraft.world.World thisWorld, BlockPos pos, int radius, boolean allowEmtpy, EnumSkyBlock lightType, BlockPos samePosition) {
        Chunk chunk = this.mixinChunkProviderServer.getLoadedChunkWithoutMarkingActive(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        return chunk != null && ((IMixinChunk)chunk).areNeighborsLoaded();
    }

    @Override
    public int func_175699_k(BlockPos pos) {
        Chunk chunk;
        if (pos.func_177956_o() < 0) {
            return 0;
        }
        if (pos.func_177956_o() >= 256) {
            pos = new BlockPos(pos.func_177958_n(), 255, pos.func_177952_p());
        }
        return (chunk = this.mixinChunkProviderServer.getLoadedChunkWithoutMarkingActive(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) == null ? 0 : chunk.func_177443_a(pos, 0);
    }

    @Override
    public int func_175721_c(BlockPos pos, boolean checkNeighbors) {
        if (((IMixinBlockPos)pos).isValidXZPosition()) {
            Chunk chunk;
            if (checkNeighbors && this.func_180495_p(pos).func_185916_f()) {
                int i1 = this.func_175721_c(pos.func_177984_a(), false);
                int i = this.func_175721_c(pos.func_177974_f(), false);
                int j = this.func_175721_c(pos.func_177976_e(), false);
                int k = this.func_175721_c(pos.func_177968_d(), false);
                int l = this.func_175721_c(pos.func_177978_c(), false);
                if (i > i1) {
                    i1 = i;
                }
                if (j > i1) {
                    i1 = j;
                }
                if (k > i1) {
                    i1 = k;
                }
                if (l > i1) {
                    i1 = l;
                }
                return i1;
            }
            if (pos.func_177956_o() < 0) {
                return 0;
            }
            if (pos.func_177956_o() >= 256) {
                pos = new BlockPos(pos.func_177958_n(), 255, pos.func_177952_p());
            }
            return (chunk = this.mixinChunkProviderServer.getLoadedChunkWithoutMarkingActive(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) == null ? 0 : chunk.func_177443_a(pos, this.func_175657_ab());
        }
        return 15;
    }

    @Override
    public int func_175642_b(EnumSkyBlock type, BlockPos pos) {
        if (pos.func_177956_o() < 0) {
            pos = new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
        }
        if (!((IMixinBlockPos)pos).isValidPosition()) {
            return type.field_77198_c;
        }
        Chunk chunk = this.mixinChunkProviderServer.getLoadedChunkWithoutMarkingActive(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        if (chunk == null) {
            return type.field_77198_c;
        }
        return chunk.func_177413_a(type, pos);
    }

    @Override
    public boolean isLightLevel(Chunk chunk, BlockPos pos, int level) {
        if (((IMixinBlockPos)pos).isValidPosition()) {
            if (this.func_180495_p(pos).func_185916_f()) {
                if (this.func_175721_c(pos.func_177984_a(), false) >= level) {
                    return true;
                }
                if (this.func_175721_c(pos.func_177974_f(), false) >= level) {
                    return true;
                }
                if (this.func_175721_c(pos.func_177976_e(), false) >= level) {
                    return true;
                }
                if (this.func_175721_c(pos.func_177968_d(), false) >= level) {
                    return true;
                }
                return this.func_175721_c(pos.func_177978_c(), false) >= level;
            }
            if (pos.func_177956_o() >= 256) {
                pos = new BlockPos(pos.func_177958_n(), 255, pos.func_177952_p());
            }
            return chunk.func_177443_a(pos, this.func_175657_ab()) >= level;
        }
        return true;
    }

    @Override
    public boolean func_175663_a(int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd, boolean allowEmpty) {
        if (yEnd < 0 || yStart > 255) {
            return false;
        }
        xEnd >>= 4;
        zEnd >>= 4;
        Chunk base = this.mixinChunkProviderServer.getLoadedChunkWithoutMarkingActive(xStart >>= 4, zStart >>= 4);
        if (base == null) {
            return false;
        }
        IMixinChunk currentColumn = (IMixinChunk)base;
        for (int i = xStart; i <= xEnd; ++i) {
            if (currentColumn == null) {
                return false;
            }
            IMixinChunk currentRow = (IMixinChunk)currentColumn.getNeighborChunk(1);
            for (int j = zStart; j <= zEnd; ++j) {
                if (currentRow == null) {
                    return false;
                }
                if (!allowEmpty && ((Chunk)currentRow).func_76621_g()) {
                    return false;
                }
                currentRow = (IMixinChunk)currentRow.getNeighborChunk(1);
            }
            currentColumn = (IMixinChunk)currentColumn.getNeighborChunk(2);
        }
        return true;
    }

    @Override
    public WorldStorage getWorldStorage() {
        return (WorldStorage)((WorldServer)this).func_72863_F();
    }

    @Override
    public PortalAgent getPortalAgent() {
        return (PortalAgent)this.field_85177_Q;
    }

    @Redirect(method={"canAddEntity"}, at=@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", remap=false))
    private void onCanAddEntityLogWarn(Logger logger, String message, Object param1, Object param2) {
    }

    @Overwrite
    protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
        IMixinChunk spongeChunk = (IMixinChunk)this.mixinChunkProviderServer.getLoadedChunkWithoutMarkingActive(x, z);
        return spongeChunk != null && (!spongeChunk.isQueuedForUnload() || spongeChunk.isPersistedChunk());
    }

    @Override
    public void func_175646_b(BlockPos pos, TileEntity unusedTileEntity) {
        if (unusedTileEntity == null) {
            super.func_175646_b(pos, unusedTileEntity);
            return;
        }
        IMixinTileEntity spongeTileEntity = (IMixinTileEntity)unusedTileEntity;
        IMixinChunk chunk = spongeTileEntity.getActiveChunk();
        if (chunk != null) {
            chunk.markChunkDirty();
        }
    }

    @Override
    public void startEntityGlobalTimings() {
        this.timings.entityTick.startTiming();
        TimingHistory.entityTicks += (long)this.field_72996_f.size();
    }

    @Override
    public void stopTimingForWeatherEntityTickCrash(net.minecraft.entity.Entity updatingEntity) {
        EntityUtil.toMixin(updatingEntity).getTimingsHandler().stopTiming();
    }

    @Override
    public void stopEntityTickTimingStartEntityRemovalTiming() {
        this.timings.entityTick.stopTiming();
        this.timings.entityRemoval.startTiming();
    }

    @Override
    public void stopEntityRemovalTiming() {
        this.timings.entityRemoval.stopTiming();
    }

    @Override
    public void startEntityTickTiming() {
        this.timings.entityTick.startTiming();
    }

    @Override
    public void stopTimingTickEntityCrash(net.minecraft.entity.Entity updatingEntity) {
        EntityUtil.toMixin(updatingEntity).getTimingsHandler().stopTiming();
    }

    @Override
    public void stopEntityTickSectionBeforeRemove() {
        this.timings.entityTick.stopTiming();
    }

    @Override
    public void startEntityRemovalTick() {
        this.timings.entityRemoval.startTiming();
    }

    @Override
    public void startTileTickTimer() {
        this.timings.tileEntityTick.startTiming();
    }

    @Override
    public void stopTimingTickTileEntityCrash(TileEntity updatingTileEntity) {
        ((IMixinTileEntity)updatingTileEntity).getTimingsHandler().stopTiming();
    }

    @Override
    public void stopTileEntityAndStartRemoval() {
        this.timings.tileEntityTick.stopTiming();
        this.timings.tileEntityRemoval.startTiming();
    }

    @Override
    public void stopTileEntityRemovelInWhile() {
        this.timings.tileEntityRemoval.stopTiming();
    }

    @Override
    public void startPendingTileEntityTimings() {
        this.timings.tileEntityPending.startTiming();
    }

    @Override
    public void endPendingTileEntities() {
        this.timings.tileEntityPending.stopTiming();
        TimingHistory.tileEntityTicks += (long)this.field_147482_g.size();
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/Profiler;endStartSection(Ljava/lang/String;)V", args={"ldc=tickPending"})})
    private void onBeginTickBlockUpdate(CallbackInfo ci) {
        this.timings.scheduledBlocks.startTiming();
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/Profiler;endStartSection(Ljava/lang/String;)V", args={"ldc=tickBlocks"})})
    private void onAfterTickBlockUpdate(CallbackInfo ci) {
        this.timings.scheduledBlocks.stopTiming();
        this.timings.updateBlocks.startTiming();
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/Profiler;endStartSection(Ljava/lang/String;)V", args={"ldc=chunkMap"})})
    private void onBeginUpdateBlocks(CallbackInfo ci) {
        this.timings.updateBlocks.stopTiming();
        this.timings.doChunkMap.startTiming();
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/Profiler;endStartSection(Ljava/lang/String;)V", args={"ldc=village"})})
    private void onBeginUpdateVillage(CallbackInfo ci) {
        this.timings.doChunkMap.stopTiming();
        this.timings.doVillages.startTiming();
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/Profiler;endStartSection(Ljava/lang/String;)V", args={"ldc=portalForcer"})})
    private void onBeginUpdatePortal(CallbackInfo ci) {
        this.timings.doVillages.stopTiming();
        this.timings.doPortalForcer.startTiming();
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/profiler/Profiler;endSection()V")})
    private void onEndUpdatePortal(CallbackInfo ci) {
        this.timings.doPortalForcer.stopTiming();
    }

    @Inject(method={"tickUpdates"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/Profiler;startSection(Ljava/lang/String;)V", args={"ldc=cleaning"})})
    private void onTickUpdatesCleanup(boolean flag, CallbackInfoReturnable<Boolean> cir) {
        this.timings.scheduledBlocksCleanup.startTiming();
    }

    @Inject(method={"tickUpdates"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/Profiler;startSection(Ljava/lang/String;)V", args={"ldc=ticking"})})
    private void onTickUpdatesTickingStart(boolean flag, CallbackInfoReturnable<Boolean> cir) {
        this.timings.scheduledBlocksCleanup.stopTiming();
        this.timings.scheduledBlocksTicking.startTiming();
    }

    @Inject(method={"tickUpdates"}, at={@At(value="RETURN")})
    private void onTickUpdatesTickingEnd(CallbackInfoReturnable<Boolean> cir) {
        this.timings.scheduledBlocksTicking.stopTiming();
    }

    @Override
    public WorldTimingsHandler getTimingsHandler() {
        return this.timings;
    }

    @Override
    public void playSound(SoundType sound, SoundCategory category, Vector3d position, double volume) {
        this.playSound(sound, category, position, volume, 1.0);
    }

    @Override
    public void playSound(SoundType sound, SoundCategory category, Vector3d position, double volume, double pitch) {
        this.playSound(sound, category, position, volume, pitch, 0.0);
    }

    @Override
    public void playSound(SoundType sound, SoundCategory category, Vector3d position, double volume, double pitch, double minVolume) {
        SoundEvent event;
        try {
            event = SoundEvents.func_187510_a((String)sound.getId());
        }
        catch (IllegalStateException e) {
            this.playCustomSound(null, position.getX(), position.getY(), position.getZ(), sound.getId(), (net.minecraft.util.SoundCategory)category, (float)Math.max(minVolume, volume), (float)pitch);
            return;
        }
        this.func_184148_a(null, position.getX(), position.getY(), position.getZ(), event, (net.minecraft.util.SoundCategory)category, (float)Math.max(minVolume, volume), (float)pitch);
    }

    @Override
    public void playCustomSound(@Nullable EntityPlayer player, double x, double y, double z, String soundIn, net.minecraft.util.SoundCategory category, float volume, float pitch) {
        if (player instanceof IMixinEntity && ((IMixinEntity)player).isVanished()) {
            return;
        }
        this.field_73021_x.stream().filter(listener -> listener instanceof IMixinServerWorldEventHandler).map(listener -> (IMixinServerWorldEventHandler)listener).forEach(listener -> listener.playCustomSoundToAllNearExcept(null, soundIn, category, x, y, z, volume, pitch));
    }

    @Override
    public void stopSounds() {
        this.stopSounds0(null, null);
    }

    @Override
    public void stopSounds(SoundType sound) {
        this.stopSounds0((SoundType)Preconditions.checkNotNull((Object)sound, (Object)"sound"), null);
    }

    @Override
    public void stopSounds(SoundCategory category) {
        this.stopSounds0(null, (SoundCategory)Preconditions.checkNotNull((Object)category, (Object)"category"));
    }

    @Override
    public void stopSounds(SoundType sound, SoundCategory category) {
        this.stopSounds0((SoundType)Preconditions.checkNotNull((Object)sound, (Object)"sound"), (SoundCategory)Preconditions.checkNotNull((Object)category, (Object)"category"));
    }

    private void stopSounds0(@Nullable SoundType sound, @Nullable SoundCategory category) {
        this.field_73061_a.func_184103_al().func_148537_a((Packet)SoundEffectHelper.createStopSoundPacket(sound, category), this.getDimensionId().intValue());
    }

    @Override
    public void spawnParticles(ParticleEffect particleEffect, Vector3d position) {
        this.spawnParticles(particleEffect, position, Integer.MAX_VALUE);
    }

    @Override
    public void spawnParticles(ParticleEffect particleEffect, Vector3d position, int radius) {
        Preconditions.checkNotNull((Object)particleEffect, (Object)"The particle effect cannot be null!");
        Preconditions.checkNotNull((Object)position, (Object)"The position cannot be null");
        Preconditions.checkArgument((radius > 0 ? 1 : 0) != 0, (Object)"The radius has to be greater then zero!");
        List<Packet<?>> packets = SpongeParticleHelper.toPackets((SpongeParticleEffect)particleEffect, position);
        if (!packets.isEmpty()) {
            PlayerList playerList = this.field_73061_a.func_184103_al();
            double x = position.getX();
            double y = position.getY();
            double z = position.getZ();
            for (Packet<?> packet : packets) {
                playerList.func_148543_a(null, x, y, z, (double)radius, this.getDimensionId().intValue(), packet);
            }
        }
    }

    @Override
    public void playRecord(Vector3i position, RecordType recordType) {
        this.playRecord0(position, (RecordType)Preconditions.checkNotNull((Object)recordType, (Object)"recordType"));
    }

    @Override
    public void stopRecord(Vector3i position) {
        this.playRecord0(position, null);
    }

    private void playRecord0(Vector3i position, @Nullable RecordType recordType) {
        this.field_73061_a.func_184103_al().func_148537_a((Packet)SpongeRecordType.createPacket(position, recordType), this.getDimensionId().intValue());
    }

    @Override
    public Weather getWeather() {
        if (this.field_72986_A.func_76061_m()) {
            return Weathers.THUNDER_STORM;
        }
        if (this.field_72986_A.func_76059_o()) {
            return Weathers.RAIN;
        }
        return Weathers.CLEAR;
    }

    @Override
    public long getRemainingDuration() {
        Weather weather = this.getWeather();
        if (weather.equals(Weathers.CLEAR)) {
            if (this.field_72986_A.func_176133_A() > 0) {
                return this.field_72986_A.func_176133_A();
            }
            return Math.min(this.field_72986_A.func_76071_n(), this.field_72986_A.func_76083_p());
        }
        if (weather.equals(Weathers.THUNDER_STORM)) {
            return this.field_72986_A.func_76071_n();
        }
        if (weather.equals(Weathers.RAIN)) {
            return this.field_72986_A.func_76083_p();
        }
        return 0L;
    }

    @Override
    public long getRunningDuration() {
        return this.field_72986_A.func_82573_f() - this.weatherStartTime;
    }

    @Override
    public void setWeather(Weather weather) {
        if (weather.equals(Weathers.CLEAR)) {
            this.setWeather(weather, (300 + this.field_73012_v.nextInt(600)) * 20);
        } else {
            this.setWeather(weather, 0L);
        }
    }

    @Override
    public void setWeather(Weather weather, long duration) {
        if (weather.equals(Weathers.CLEAR)) {
            this.field_72986_A.func_176142_i((int)duration);
            this.field_72986_A.func_76080_g(0);
            this.field_72986_A.func_76090_f(0);
            this.field_72986_A.func_76084_b(false);
            this.field_72986_A.func_76069_a(false);
        } else if (weather.equals(Weathers.RAIN)) {
            this.field_72986_A.func_176142_i(0);
            this.field_72986_A.func_76080_g((int)duration);
            this.field_72986_A.func_76090_f((int)duration);
            this.field_72986_A.func_76084_b(true);
            this.field_72986_A.func_76069_a(false);
        } else if (weather.equals(Weathers.THUNDER_STORM)) {
            this.field_72986_A.func_176142_i(0);
            this.field_72986_A.func_76080_g((int)duration);
            this.field_72986_A.func_76090_f((int)duration);
            this.field_72986_A.func_76084_b(true);
            this.field_72986_A.func_76069_a(true);
        }
    }

    @Inject(method={"updateWeather"}, at={@At(value="RETURN")})
    private void onUpdateWeatherReturn(CallbackInfo ci) {
        Weather weather = this.getWeather();
        int duration = (int)this.getRemainingDuration();
        if (this.prevWeather != weather && duration > 0) {
            Sponge.getCauseStackManager().pushCause(this);
            ChangeWorldWeatherEvent event = SpongeEventFactory.createChangeWorldWeatherEvent(Sponge.getCauseStackManager().getCurrentCause(), duration, duration, weather, weather, this.prevWeather, this);
            SpongeImpl.postEvent(event);
            Sponge.getCauseStackManager().popCause();
            if (event.isCancelled()) {
                this.setWeather(this.prevWeather);
            } else {
                this.prevWeather = event.getWeather();
                this.weatherStartTime = this.field_72986_A.func_82573_f();
            }
        }
    }

    @Override
    public long getWeatherStartTime() {
        return this.weatherStartTime;
    }

    @Override
    public void setWeatherStartTime(long weatherStartTime) {
        this.weatherStartTime = weatherStartTime;
    }

    @Override
    public int getChunkGCTickInterval() {
        return this.chunkGCTickInterval;
    }

    @Override
    public long getChunkUnloadDelay() {
        return this.chunkUnloadDelay;
    }

    @Override
    public int getViewDistance() {
        return this.field_73063_M.field_72698_e;
    }

    @Override
    public void setViewDistance(int viewDistance) {
        this.setMemoryViewDistance(viewDistance);
        SpongeConfig<? extends GeneralConfigBase> config = this.getActiveConfig();
        config.getConfig().getWorld().setViewDistance(this.field_73063_M.field_72698_e);
        config.save();
    }

    private void setMemoryViewDistance(int viewDistance) {
        this.field_73063_M.func_152622_a(viewDistance);
    }

    @Override
    public void resetViewDistance() {
        this.setViewDistance(this.chooseViewDistanceValue(-1));
    }

    private int chooseViewDistanceValue(int value) {
        if (value == -1) {
            return this.field_73061_a.func_184103_al().func_72395_o();
        }
        return value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("LevelName", (Object)this.field_72986_A.func_76065_j()).add("DimensionId", this.field_73011_w.func_186058_p().func_186068_a()).add("DimensionType", (Object)((org.spongepowered.api.world.DimensionType)this.field_73011_w.func_186058_p()).getId()).toString();
    }
}

