/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.projectile.FishHook;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;

@Mixin(value={ItemFishingRod.class})
public abstract class MixinItemFishingRod
extends Item {
    @Nullable
    private EntityFishHook fishHook;

    @Inject(method={"onItemRightClick"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/entity/projectile/EntityFishHook;handleHookRetraction()I")}, cancellable=true)
    private void cancelHookRetraction(World world, EntityPlayer player, EnumHand hand, CallbackInfoReturnable<ActionResult<ItemStack>> cir) {
        if (player.field_71104_cf != null) {
            cir.setReturnValue((ActionResult<ItemStack>)new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand)));
        }
    }

    @Inject(method={"onItemRightClick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;playSound(Lnet/minecraft/entity/player/EntityPlayer;DDDLnet/minecraft/util/SoundEvent;Lnet/minecraft/util/SoundCategory;FF)V", ordinal=1)}, cancellable=true)
    private void onThrowEvent(World world, EntityPlayer player, EnumHand hand, CallbackInfoReturnable<ActionResult<ItemStack>> cir) {
        if (world.field_72995_K) {
            return;
        }
        EntityFishHook fishHook = new EntityFishHook(world, player);
        Sponge.getCauseStackManager().pushCause(player);
        if (SpongeImpl.postEvent(SpongeEventFactory.createFishingEventStart(Sponge.getCauseStackManager().getCurrentCause(), (FishHook)fishHook))) {
            fishHook.func_70106_y();
            cir.setReturnValue((ActionResult<ItemStack>)new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand)));
        } else {
            this.fishHook = fishHook;
        }
        Sponge.getCauseStackManager().popCause();
    }

    @Redirect(method={"onItemRightClick"}, at=@At(value="NEW", target="net/minecraft/entity/projectile/EntityFishHook"))
    private EntityFishHook onNewEntityFishHook(World world, EntityPlayer player) {
        EntityFishHook fishHook = this.fishHook;
        this.fishHook = null;
        return fishHook;
    }
}

