/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.living.human.EntityHuman;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={EntityTracker.class})
public abstract class MixinEntityTracker {
    @Shadow
    @Final
    private WorldServer field_72795_a;

    @Shadow
    public abstract void func_72791_a(Entity var1, int var2, int var3);

    @Inject(method={"track(Lnet/minecraft/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onTrackEntity(Entity entityIn, CallbackInfo ci) {
        if (entityIn instanceof EntityHuman) {
            this.func_72791_a(entityIn, 512, 2);
            ci.cancel();
        }
    }

    @Redirect(method={"track(Lnet/minecraft/entity/Entity;IIZ)V"}, at=@At(value="NEW", args={"class=java/lang/IllegalStateException"}, remap=false))
    private IllegalStateException reportEntityAlreadyTrackedWithWorld(String string, Entity entityIn, int trackingRange, int updateFrequency, boolean sendVelocityUpdates) {
        IllegalStateException exception = new IllegalStateException(String.format("Entity %s is already tracked for world: %s", entityIn, ((World)this.field_72795_a).getName()));
        if (PhaseTracker.getInstance().verboseErrors) {
            PhaseTracker.getInstance().printMessageWithCaughtException("Exception tracking entity", "An entity that was already tracked was added to the tracker!", exception);
        }
        return exception;
    }

    @Inject(method={"track(Lnet/minecraft/entity/Entity;IIZ)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onAddEntityToTracker(Entity entityIn, int trackingRange, int updateFrequency, boolean sendVelocityUpdates, CallbackInfo ci) {
        if (!SpongeImpl.getServer().func_152345_ab()) {
            Thread.dumpStack();
            SpongeImpl.getLogger().error("Detected attempt to add entity '" + entityIn + "' to tracker asynchronously.\n This is very bad as it can cause ConcurrentModificationException's during a server tick.\n Skipping...");
            ci.cancel();
        }
    }

    @Inject(method={"untrack"}, at={@At(value="HEAD")}, cancellable=true)
    public void onUntrackEntity(Entity entityIn, CallbackInfo ci) {
        if (!SpongeImpl.getServer().func_152345_ab()) {
            Thread.dumpStack();
            SpongeImpl.getLogger().error("Detected attempt to untrack entity '" + entityIn + "' asynchronously.\nThis is very bad as it can cause ConcurrentModificationException's during a server tick.\n Skipping...");
            ci.cancel();
        }
    }
}

