/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.blockcapturing;

import net.minecraft.block.Block;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.category.BlockCapturingCategory;
import org.spongepowered.common.config.category.BlockCapturingModCategory;
import org.spongepowered.common.config.type.GeneralConfigBase;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.mixin.plugin.blockcapturing.IModData_BlockCapturing;

@Mixin(value={Block.class})
public abstract class MixinBlock_BlockCapturing
implements IModData_BlockCapturing,
BlockType {
    private boolean processTickChangesImmediately;
    private boolean refreshCache = true;

    @Override
    public boolean processTickChangesImmediately() {
        return this.processTickChangesImmediately;
    }

    @Override
    public void initializeBlockCapturingState(World worldIn) {
        SpongeConfig<? extends GeneralConfigBase> activeConfig = ((IMixinWorldServer)worldIn).getActiveConfig();
        BlockCapturingCategory blockCapturing = activeConfig.getConfig().getBlockCapturing();
        String[] ids = this.getId().split(":");
        String modId = ids[0];
        String name = ids[1];
        BlockCapturingModCategory modCapturing = blockCapturing.getModMappings().get(modId);
        if (modCapturing == null && blockCapturing.autoPopulateData()) {
            modCapturing = new BlockCapturingModCategory();
            blockCapturing.getModMappings().put(modId.toLowerCase(), modCapturing);
            modCapturing.getBlockMap().put(name.toLowerCase(), false);
            if (blockCapturing.autoPopulateData()) {
                activeConfig.save();
            }
            return;
        }
        if (modCapturing != null) {
            if (!modCapturing.isEnabled()) {
                this.processTickChangesImmediately = false;
                return;
            }
            Boolean processImmediately = modCapturing.getBlockMap().get(name.toLowerCase());
            if (processImmediately != null) {
                this.processTickChangesImmediately = processImmediately;
            }
        }
        if (blockCapturing.autoPopulateData()) {
            activeConfig.save();
        }
    }

    @Override
    public boolean requiresBlockCapturingRefresh() {
        return this.refreshCache;
    }

    @Override
    public void requiresBlockCapturingRefresh(boolean refresh) {
        this.refreshCache = refresh;
    }
}

