/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.comp;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.entity.ArmorEquipable;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.api.item.inventory.property.EquipmentSlotType;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.comp.EquipmentInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.comp.EquipmentInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.comp.OrderedInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.slots.EquipmentSlotLensImpl;

public class EquipmentInventoryLensImpl
extends OrderedInventoryLensImpl
implements EquipmentInventoryLens<IInventory, ItemStack> {
    final ArmorEquipable carrier;

    public EquipmentInventoryLensImpl(ArmorEquipable carrier, int base, int size, int stride, SlotProvider<IInventory, ItemStack> slots) {
        super(base, size, stride, EquipmentInventoryAdapter.class, slots);
        this.carrier = carrier;
    }

    @Override
    protected void init(SlotProvider<IInventory, ItemStack> slots) {
        super.init(slots);
        int index = this.base;
        this.addChild(new EquipmentSlotLensImpl(index, i -> true, t -> true, e -> e == EquipmentTypes.BOOTS), EquipmentSlotType.of(EquipmentTypes.BOOTS));
        this.addChild(new EquipmentSlotLensImpl(++index, i -> true, t -> true, e -> e == EquipmentTypes.LEGGINGS), EquipmentSlotType.of(EquipmentTypes.LEGGINGS));
        this.addChild(new EquipmentSlotLensImpl(++index, i -> true, t -> true, e -> e == EquipmentTypes.CHESTPLATE), EquipmentSlotType.of(EquipmentTypes.CHESTPLATE));
        this.addChild(new EquipmentSlotLensImpl(++index, i -> true, t -> true, e -> e == EquipmentTypes.HEADWEAR), EquipmentSlotType.of(EquipmentTypes.HEADWEAR));
    }

    @Override
    public InventoryAdapter<IInventory, ItemStack> getAdapter(Fabric<IInventory> inv, Inventory parent) {
        return new EquipmentInventoryAdapter(this.carrier, inv, this, parent);
    }
}

