/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inject;

import com.google.common.reflect.TypeToken;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.DependencyAndSource;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProvisionListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nullable;
import org.spongepowered.common.inject.SpongeInjectionPoint;

public final class InjectionPointProvider
extends AbstractMatcher<Binding<?>>
implements Module,
ProvisionListener,
Provider<SpongeInjectionPoint> {
    @Nullable
    private SpongeInjectionPoint injectionPoint;

    @Override
    @Nullable
    public SpongeInjectionPoint get() {
        return this.injectionPoint;
    }

    @Override
    public boolean matches(Binding<?> binding) {
        return binding instanceof ProviderInstanceBinding && ((ProviderInstanceBinding)binding).getUserSuppliedProvider() == this;
    }

    @Override
    public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
        try {
            this.injectionPoint = InjectionPointProvider.findInjectionPoint(provision.getDependencyChain());
            provision.provision();
        }
        finally {
            this.injectionPoint = null;
        }
    }

    @Nullable
    private static SpongeInjectionPoint findInjectionPoint(List<DependencyAndSource> dependencyChain) {
        if (dependencyChain.size() < 3) {
            throw new AssertionError((Object)"Provider is not included in the dependency chain");
        }
        for (int i = dependencyChain.size() - 2; i >= 0; --i) {
            Dependency<?> dependency = dependencyChain.get(i).getDependency();
            if (dependency == null) {
                return null;
            }
            InjectionPoint spiInjectionPoint = dependency.getInjectionPoint();
            if (spiInjectionPoint == null) continue;
            TypeToken source = TypeToken.of((Type)spiInjectionPoint.getDeclaringType().getType());
            Member member = spiInjectionPoint.getMember();
            if (member instanceof Field) {
                Field field = (Field)member;
                return new SpongeInjectionPoint(source, TypeToken.of((Type)field.getGenericType()), field.getAnnotations());
            }
            if (member instanceof Executable) {
                Executable executable = (Executable)member;
                Annotation[][] parameterAnnotations = executable.getParameterAnnotations();
                Type[] parameterTypes = executable.getGenericParameterTypes();
                int index = dependency.getParameterIndex();
                return new SpongeInjectionPoint(source, TypeToken.of((Type)parameterTypes[index]), parameterAnnotations[index]);
            }
            throw new IllegalStateException("Unsupported Member type: " + member.getClass().getName());
        }
        return null;
    }

    @Override
    public void configure(Binder binder) {
        binder.bind(SpongeInjectionPoint.class).toProvider(this);
        binder.bindListener(this, this);
    }
}

