/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.ArrayList;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.TickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;

class WeatherTickPhaseState
extends TickPhaseState<TickContext.General> {
    WeatherTickPhaseState() {
    }

    @Override
    public TickContext.General createPhaseContext() {
        return (TickContext.General)new TickContext.General(this).addCaptures();
    }

    @Override
    public void unwind(TickContext.General phaseContext) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.WEATHER);
            phaseContext.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
                SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), entities);
                SpongeImpl.postEvent(spawnEntityEvent);
                for (Entity entity : spawnEntityEvent.getEntities()) {
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            });
            phaseContext.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blockSnapshots -> TrackingUtil.processBlockCaptures(blockSnapshots, this, phaseContext));
        }
    }

    @Override
    public boolean spawnEntityOrCapture(TickContext.General context, Entity entity, int chunkX, int chunkZ) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.WEATHER);
            ArrayList<Entity> capturedEntities = new ArrayList<Entity>();
            capturedEntities.add(entity);
            SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), capturedEntities);
            SpongeImpl.postEvent(spawnEntityEvent);
            if (!spawnEntityEvent.isCancelled()) {
                for (Entity anEntity : spawnEntityEvent.getEntities()) {
                    EntityUtil.getMixinWorld(anEntity).forceSpawnEntity(anEntity);
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return "WeatherTickPhase";
    }
}

