/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import com.flowpowered.math.vector.Vector3d;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.network.Packet;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.ItemDropData;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.interfaces.IMixinContainer;
import org.spongepowered.common.item.inventory.util.ContainerUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;
import org.spongepowered.common.util.VecHelper;

final class InteractionPacketState
extends BasicPacketState {
    InteractionPacketState() {
    }

    @Override
    public boolean isInteraction() {
        return true;
    }

    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, BasicPacketContext context) {
        ItemStack stack = ItemStackUtil.cloneDefensive(playerMP.func_184614_ca());
        if (stack != null) {
            context.itemUsed(stack);
        }
    }

    @Override
    public boolean shouldCaptureEntity() {
        return true;
    }

    @Override
    public boolean doesCaptureEntityDrops() {
        return true;
    }

    @Override
    public boolean canSwitchTo(IPhaseState<?> state) {
        return state == BlockPhase.State.BLOCK_DECAY || state == BlockPhase.State.BLOCK_DROP_ITEMS;
    }

    @Override
    public boolean tracksBlockSpecificDrops() {
        return true;
    }

    @Override
    public boolean tracksEntitySpecificDrops() {
        return true;
    }

    @Override
    public boolean alreadyCapturingItemSpawns() {
        return true;
    }

    @Override
    public void unwind(BasicPacketContext phaseContext) {
        EntityPlayerMP player = phaseContext.getPacketPlayer();
        ItemStack usedStack = phaseContext.getItemUsed();
        ItemStackSnapshot usedSnapshot = ItemStackUtil.snapshotOf(usedStack);
        org.spongepowered.api.entity.Entity spongePlayer = EntityUtil.fromNative((Entity)player);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            BlockSnapshot firstBlockChange;
            Sponge.getCauseStackManager().pushCause(spongePlayer);
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.DROPPED_ITEM);
            boolean hasBlocks = !phaseContext.getCapturedBlockSupplier().isEmpty();
            List<BlockSnapshot> capturedBlcoks = phaseContext.getCapturedBlocks();
            BlockSnapshot blockSnapshot = firstBlockChange = hasBlocks ? capturedBlcoks.get(0) : null;
            if (hasBlocks) {
                if (!TrackingUtil.processBlockCaptures(capturedBlcoks, this, phaseContext)) {
                    return;
                }
            } else {
                phaseContext.getBlockItemDropSupplier().acceptIfNotEmpty(map -> {
                    if (ShouldFire.DROP_ITEM_EVENT_DESTRUCT) {
                        for (BlockSnapshot blockChange : capturedBlcoks) {
                            Location<World> location = blockChange.getLocation().get();
                            Vector3d position = location.getPosition();
                            BlockPos blockPos = VecHelper.toBlockPos(position);
                            List entityItems = map.get((Object)blockPos);
                            if (entityItems.isEmpty()) continue;
                            List items = entityItems.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
                            DropItemEvent.Destruct event = SpongeEventFactory.createDropItemEventDestruct(Sponge.getCauseStackManager().getCurrentCause(), items);
                            SpongeImpl.postEvent(event);
                            if (event.isCancelled()) continue;
                            InteractionPacketState.processSpawnedEntities(player, event);
                        }
                    } else {
                        for (BlockSnapshot blockChange : capturedBlcoks) {
                            Location<World> location = blockChange.getLocation().get();
                            Vector3d position = location.getPosition();
                            BlockPos blockPos = VecHelper.toBlockPos(position);
                            List entityItems = map.get((Object)blockPos);
                            if (entityItems.isEmpty()) continue;
                            InteractionPacketState.processEntities(player, entityItems);
                        }
                    }
                });
            }
            phaseContext.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
                ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>();
                for (EntityItem item : items) {
                    entities.add(EntityUtil.fromNative((Entity)item));
                }
                DropItemEvent.Dispense dispense = SpongeEventFactory.createDropItemEventDispense(Sponge.getCauseStackManager().getCurrentCause(), entities);
                SpongeImpl.postEvent(dispense);
                if (!dispense.isCancelled()) {
                    InteractionPacketState.processSpawnedEntities(player, dispense);
                }
            });
            phaseContext.getCapturedEntityDropSupplier().acceptIfNotEmpty(map -> {
                if (map.isEmpty()) {
                    return;
                }
                PrettyPrinter printer = new PrettyPrinter(80);
                printer.add("Processing Interaction").centre().hr();
                printer.add("The item stacks captured are: ");
                for (Map.Entry entry : map.asMap().entrySet()) {
                    printer.add("  - Entity with UUID: %s", entry.getKey());
                    for (ItemDropData stack : (Collection)entry.getValue()) {
                        printer.add("    - %s", stack);
                    }
                }
                printer.trace(System.err);
            });
            phaseContext.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(arg_0 -> InteractionPacketState.lambda$unwind$3(usedSnapshot, player, firstBlockChange, arg_0));
            IMixinContainer mixinContainer = ContainerUtil.toMixin(player.field_71070_bA);
            mixinContainer.setCaptureInventory(false);
            mixinContainer.getCapturedTransactions().clear();
        }
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$unwind$3(ItemStackSnapshot usedSnapshot, EntityPlayerMP player, @Nullable BlockSnapshot firstBlockChange, List entities) {
        projectiles = new ArrayList<org.spongepowered.api.entity.Entity>(entities.size());
        spawnEggs = new ArrayList<org.spongepowered.api.entity.Entity>(entities.size());
        normalPlacement = new ArrayList<org.spongepowered.api.entity.Entity>(entities.size());
        items = new ArrayList<org.spongepowered.api.entity.Entity>(entities.size());
        for (org.spongepowered.api.entity.Entity entity : entities) {
            if (entity instanceof Projectile || entity instanceof EntityThrowable) {
                projectiles.add(entity);
                continue;
            }
            if (usedSnapshot.getType() == ItemTypes.SPAWN_EGG) {
                spawnEggs.add(entity);
                continue;
            }
            if (entity instanceof EntityItem) {
                items.add(entity);
                continue;
            }
            normalPlacement.add(entity);
        }
        if (!projectiles.isEmpty()) {
            if (ShouldFire.SPAWN_ENTITY_EVENT) {
                frame2 = Sponge.getCauseStackManager().pushCauseFrame();
                var9_9 = null;
                try {
                    Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.PROJECTILE);
                    Sponge.getCauseStackManager().pushCause(usedSnapshot);
                    event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), projectiles);
                    if (SpongeImpl.postEvent(event)) ** GOTO lbl49
                    InteractionPacketState.processSpawnedEntities(player, event);
                }
                catch (Throwable event) {
                    var9_9 = event;
                    throw event;
                }
                finally {
                    if (frame2 != null) {
                        if (var9_9 != null) {
                            try {
                                frame2.close();
                            }
                            catch (Throwable event) {
                                var9_9.addSuppressed(event);
                            }
                        } else {
                            frame2.close();
                        }
                    }
                }
            } else {
                InteractionPacketState.processEntities(player, projectiles);
            }
        }
lbl49:
        // 5 sources

        if (!spawnEggs.isEmpty()) {
            if (ShouldFire.SPAWN_ENTITY_EVENT) {
                frame2 = Sponge.getCauseStackManager().pushCauseFrame();
                var9_9 = null;
                try {
                    Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.PROJECTILE);
                    Sponge.getCauseStackManager().pushCause(usedSnapshot);
                    event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), spawnEggs);
                    if (SpongeImpl.postEvent(event)) ** GOTO lbl77
                    InteractionPacketState.processSpawnedEntities(player, event);
                }
                catch (Throwable event) {
                    var9_9 = event;
                    throw event;
                }
                finally {
                    if (frame2 != null) {
                        if (var9_9 != null) {
                            try {
                                frame2.close();
                            }
                            catch (Throwable event) {
                                var9_9.addSuppressed(event);
                            }
                        } else {
                            frame2.close();
                        }
                    }
                }
            } else {
                InteractionPacketState.processEntities(player, spawnEggs);
            }
        }
lbl77:
        // 5 sources

        if (!items.isEmpty()) {
            if (ShouldFire.DROP_ITEM_EVENT_DISPENSE) {
                dispense = SpongeEventFactory.createDropItemEventDispense(Sponge.getCauseStackManager().getCurrentCause(), items);
                if (!SpongeImpl.postEvent(dispense)) {
                    InteractionPacketState.processSpawnedEntities(player, dispense);
                }
            } else {
                InteractionPacketState.processEntities(player, items);
            }
        }
        if (!normalPlacement.isEmpty()) {
            if (ShouldFire.SPAWN_ENTITY_EVENT) {
                stackFrame = Sponge.getCauseStackManager().pushCauseFrame();
                var9_9 = null;
                try {
                    if (firstBlockChange != null) {
                        stackFrame.pushCause(firstBlockChange);
                    }
                    if (SpongeImpl.postEvent(event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), normalPlacement))) ** GOTO lbl110
                    InteractionPacketState.processSpawnedEntities(player, event);
                }
                catch (Throwable var10_16) {
                    var9_9 = var10_16;
                    throw var10_16;
                }
                finally {
                    if (stackFrame != null) {
                        if (var9_9 != null) {
                            try {
                                stackFrame.close();
                            }
                            catch (Throwable var10_15) {
                                var9_9.addSuppressed(var10_15);
                            }
                        } else {
                            stackFrame.close();
                        }
                    }
                }
            } else {
                InteractionPacketState.processEntities(player, normalPlacement);
            }
        }
lbl110:
        // 5 sources

    }
}

