/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.Location;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.CapturedMultiMapSupplier;
import org.spongepowered.common.event.tracking.context.CapturedSupplier;
import org.spongepowered.common.event.tracking.context.GeneralizedContext;
import org.spongepowered.common.event.tracking.context.ItemDropData;
import org.spongepowered.common.event.tracking.phase.TrackingPhase;
import org.spongepowered.common.event.tracking.phase.general.CommandPhaseContext;
import org.spongepowered.common.event.tracking.phase.general.CommandState;
import org.spongepowered.common.event.tracking.phase.general.CompletePhase;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.general.ExplosionState;
import org.spongepowered.common.event.tracking.phase.general.PostState;
import org.spongepowered.common.event.tracking.phase.general.UnwindingPhaseContext;
import org.spongepowered.common.event.tracking.phase.general.WorldUnload;
import org.spongepowered.common.interfaces.world.IMixinLocation;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.common.world.SpongeProxyBlockAccess;

public final class GeneralPhase
extends TrackingPhase {
    public static GeneralPhase getInstance() {
        return Holder.INSTANCE;
    }

    private GeneralPhase() {
    }

    public static void processBlockTransactionListsPost(PhaseContext<?> postContext, List<BlockSnapshot> snapshotsToProcess, IPhaseState<?> unwindingState, PhaseContext<?> unwinding) {
        ArrayList<Transaction> invalidTransactions = new ArrayList<Transaction>();
        ImmutableList[] transactionArrays = new ImmutableList[5];
        ImmutableList.Builder[] transactionBuilders = new ImmutableList.Builder[5];
        for (int i = 0; i < 5; ++i) {
            transactionBuilders[i] = new ImmutableList.Builder();
        }
        ArrayList<ChangeBlockEvent> blockEvents = new ArrayList<ChangeBlockEvent>();
        for (BlockSnapshot snapshot : snapshotsToProcess) {
            TrackingUtil.TRANSACTION_PROCESSOR.apply(transactionBuilders).accept(TrackingUtil.TRANSACTION_CREATION.apply(snapshot));
        }
        for (int i = 0; i < 5; ++i) {
            transactionArrays[i] = transactionBuilders[i].build();
        }
        postContext.getCapturedBlocksOrEmptyList().clear();
        ChangeBlockEvent[] mainEvents = new ChangeBlockEvent[BlockChange.values().length];
        TrackingUtil.iterateChangeBlockEvents(transactionArrays, blockEvents, mainEvents);
        ChangeBlockEvent.Post postEvent = TrackingUtil.throwMultiEventsAndCreatePost(transactionArrays, blockEvents, mainEvents);
        if (postEvent == null) {
            return;
        }
        for (ChangeBlockEvent changeBlockEvent : blockEvents) {
            if (!changeBlockEvent.isCancelled()) continue;
            for (Transaction transaction : Lists.reverse(changeBlockEvent.getTransactions())) {
                transaction.setValid(false);
            }
        }
        if (postEvent.isCancelled()) {
            for (Transaction transaction : postEvent.getTransactions()) {
                transaction.setValid(false);
            }
        }
        for (Transaction transaction : postEvent.getTransactions()) {
            if (transaction.isValid()) continue;
            invalidTransactions.add(transaction);
        }
        if (!invalidTransactions.isEmpty()) {
            for (Transaction transaction : Lists.reverse(invalidTransactions)) {
                Location location;
                ((BlockSnapshot)transaction.getOriginal()).restore(true, BlockChangeFlags.NONE);
                if (!unwindingState.tracksBlockSpecificDrops() || (location = (Location)((BlockSnapshot)transaction.getOriginal()).getLocation().orElse(null)) == null) continue;
                BlockPos pos = ((IMixinLocation)((Object)location)).getBlockPos();
                postContext.getBlockDropSupplier().removeAllIfNotEmpty(pos);
            }
            invalidTransactions.clear();
        }
        GeneralPhase.performPostBlockAdditions(postContext, postEvent.getTransactions(), unwindingState, unwinding);
    }

    private static void performPostBlockAdditions(PhaseContext<?> postContext, List<Transaction<BlockSnapshot>> transactions, IPhaseState<?> unwindingState, PhaseContext<?> unwindingPhaseContext) {
        SpongeProxyBlockAccess proxyBlockAccess = new SpongeProxyBlockAccess(transactions);
        CapturedMultiMapSupplier<BlockPos, ItemDropData> capturedBlockDrops = postContext.getBlockDropSupplier();
        CapturedMultiMapSupplier<BlockPos, EntityItem> capturedBlockItemEntityDrops = postContext.getBlockItemDropSupplier();
        for (Transaction<BlockSnapshot> transaction : transactions) {
            if (!transaction.isValid()) continue;
            if (transaction.getCustom().isPresent()) {
                transaction.getFinal().restore(true, BlockChangeFlags.ALL);
            }
            SpongeBlockSnapshot oldBlockSnapshot = (SpongeBlockSnapshot)transaction.getOriginal();
            SpongeBlockSnapshot newBlockSnapshot = (SpongeBlockSnapshot)transaction.getFinal();
            Location<org.spongepowered.api.world.World> worldLocation = oldBlockSnapshot.getLocation().get();
            IMixinWorldServer mixinWorldServer = (IMixinWorldServer)((Object)worldLocation.getExtent());
            BlockPos pos = ((IMixinLocation)((Object)worldLocation)).getBlockPos();
            capturedBlockDrops.acceptAndRemoveIfPresent(pos, items -> TrackingUtil.spawnItemDataForBlockDrops(items, oldBlockSnapshot, unwindingPhaseContext, unwindingState));
            capturedBlockItemEntityDrops.acceptAndRemoveIfPresent(pos, items -> TrackingUtil.spawnItemEntitiesForBlockDrops(items, oldBlockSnapshot, unwindingPhaseContext, unwindingState));
            WorldServer worldServer = mixinWorldServer.asMinecraftWorld();
            SpongeHooks.logBlockAction((World)worldServer, oldBlockSnapshot.blockChange, transaction);
            SpongeBlockChangeFlag spongeFlag = oldBlockSnapshot.getChangeFlag();
            int updateFlag = spongeFlag.getRawFlag();
            IBlockState originalState = (IBlockState)oldBlockSnapshot.getState();
            IBlockState newState = (IBlockState)newBlockSnapshot.getState();
            CapturedSupplier<BlockSnapshot> capturedBlockSupplier = postContext.getCapturedBlockSupplier();
            if (spongeFlag.performBlockPhysics() && originalState.func_177230_c() != newState.func_177230_c() && !SpongeImplHooks.hasBlockTileEntity(newState.func_177230_c(), newState)) {
                newState.func_177230_c().func_176213_c((World)worldServer, pos, newState);
                postContext.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
                    ArrayList<Entity> capturedEntities = new ArrayList<Entity>((Collection<Entity>)entities);
                    unwindingState.postProcessSpawns(unwindingPhaseContext, capturedEntities);
                });
                capturedBlockSupplier.acceptAndClearIfNotEmpty(blocks -> {
                    ArrayList<BlockSnapshot> blockSnapshots = new ArrayList<BlockSnapshot>((Collection<BlockSnapshot>)blocks);
                    GeneralPhase.processBlockTransactionListsPost(postContext, blockSnapshots, unwindingState, unwindingPhaseContext);
                });
            }
            proxyBlockAccess.proceed();
            unwindingState.handleBlockChangeWithUser(oldBlockSnapshot.blockChange, transaction, unwindingPhaseContext);
            if (spongeFlag.isNotifyClients()) {
                worldServer.func_184138_a(pos, originalState, newState, updateFlag);
            }
            if (spongeFlag.updateNeighbors()) {
                mixinWorldServer.spongeNotifyNeighborsPostBlockChange(pos, originalState, newState, spongeFlag);
            } else if (spongeFlag.notifyObservers()) {
                worldServer.func_190522_c(pos, newState.func_177230_c());
            }
            capturedBlockSupplier.acceptAndClearIfNotEmpty(blocks -> {
                ArrayList<BlockSnapshot> blockSnapshots = new ArrayList<BlockSnapshot>((Collection<BlockSnapshot>)blocks);
                blocks.clear();
                GeneralPhase.processBlockTransactionListsPost(postContext, blockSnapshots, unwindingState, unwindingPhaseContext);
            });
        }
    }

    private static final class Holder {
        static final GeneralPhase INSTANCE = new GeneralPhase();

        private Holder() {
        }
    }

    public static final class Post {
        public static final IPhaseState<UnwindingPhaseContext> UNWINDING = new PostState();

        private Post() {
        }
    }

    public static final class State {
        public static final IPhaseState<CommandPhaseContext> COMMAND = new CommandState();
        public static final IPhaseState<ExplosionContext> EXPLOSION = new ExplosionState();
        public static final IPhaseState<GeneralizedContext> COMPLETE = new CompletePhase();
        public static final IPhaseState<?> WORLD_UNLOAD = new WorldUnload();

        private State() {
        }
    }
}

