/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.BlockItemDropsSupplier;
import org.spongepowered.common.event.tracking.context.BlockItemEntityDropsSupplier;
import org.spongepowered.common.event.tracking.context.CaptureBlockPos;
import org.spongepowered.common.event.tracking.context.CapturedBlockEntitySpawnSupplier;
import org.spongepowered.common.event.tracking.context.CapturedBlocksSupplier;
import org.spongepowered.common.event.tracking.context.CapturedEntitiesSupplier;
import org.spongepowered.common.event.tracking.context.CapturedItemStackSupplier;
import org.spongepowered.common.event.tracking.context.CapturedItemsSupplier;
import org.spongepowered.common.event.tracking.context.CapturedMultiMapSupplier;
import org.spongepowered.common.event.tracking.context.CapturedSupplier;
import org.spongepowered.common.event.tracking.context.EntityItemDropsSupplier;
import org.spongepowered.common.event.tracking.context.EntityItemEntityDropsSupplier;
import org.spongepowered.common.event.tracking.context.ItemDropData;

public class PhaseContext<P extends PhaseContext<P>>
implements AutoCloseable {
    final IPhaseState<? extends P> state;
    protected boolean isCompleted = false;
    @Nullable
    private CapturedBlocksSupplier blocksSupplier;
    @Nullable
    private BlockItemDropsSupplier blockItemDropsSupplier;
    @Nullable
    private BlockItemEntityDropsSupplier blockItemEntityDropsSupplier;
    @Nullable
    private CapturedItemsSupplier capturedItemsSupplier;
    @Nullable
    private CapturedEntitiesSupplier capturedEntitiesSupplier;
    @Nullable
    private CapturedItemStackSupplier capturedItemStackSupplier;
    @Nullable
    private EntityItemDropsSupplier entityItemDropsSupplier;
    @Nullable
    private EntityItemEntityDropsSupplier entityItemEntityDropsSupplier;
    @Nullable
    private CapturedMultiMapSupplier<BlockPos, Entity> blockEntitySpawnSupplier;
    @Nullable
    private CaptureBlockPos captureBlockPos;
    @Nullable
    protected User owner;
    @Nullable
    protected User notifier;
    private boolean processImmediately;
    @Nullable
    private Object source;

    public P source(Object owner) {
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        this.source = owner;
        return (P)this;
    }

    public P owner(Supplier<Optional<User>> supplier) {
        supplier.get().ifPresent(this::owner);
        return (P)this;
    }

    public P owner(User owner) {
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        if (this.owner != null) {
            throw new IllegalStateException("Owner for this phase context is already set!");
        }
        this.owner = (User)Preconditions.checkNotNull((Object)owner, (Object)"Owner cannot be null!");
        return (P)this;
    }

    public P notifier(Supplier<Optional<User>> supplier) {
        supplier.get().ifPresent(this::notifier);
        return (P)this;
    }

    public P notifier(User notifier) {
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        if (this.notifier != null) {
            throw new IllegalStateException("Notifier for this phase context is already set!");
        }
        this.notifier = (User)Preconditions.checkNotNull((Object)notifier, (Object)"Notifier cannot be null!");
        return (P)this;
    }

    private void checkBlockSuppliers() {
        Preconditions.checkState((this.blocksSupplier == null ? 1 : 0) != 0, (Object)"BlocksSuppler is already set!");
        Preconditions.checkState((this.blockItemEntityDropsSupplier == null ? 1 : 0) != 0, (Object)"BlockItemEntityDropsSupplier is already set!");
        Preconditions.checkState((this.blockItemDropsSupplier == null ? 1 : 0) != 0, (Object)"BlockItemDropsSupplier is already set!");
        Preconditions.checkState((this.blockEntitySpawnSupplier == null ? 1 : 0) != 0, (Object)"BlockEntitySpawnSupplier is already set!");
        Preconditions.checkState((this.captureBlockPos == null ? 1 : 0) != 0, (Object)"CaptureBlockPos is already set!");
    }

    public P addBlockCaptures() {
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        this.checkBlockSuppliers();
        this.blocksSupplier = new CapturedBlocksSupplier();
        this.blockItemEntityDropsSupplier = new BlockItemEntityDropsSupplier();
        this.blockItemDropsSupplier = new BlockItemDropsSupplier();
        this.blockEntitySpawnSupplier = new CapturedBlockEntitySpawnSupplier();
        this.captureBlockPos = new CaptureBlockPos();
        return (P)this;
    }

    public P addCaptures() {
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        this.checkBlockSuppliers();
        Preconditions.checkState((this.capturedItemsSupplier == null ? 1 : 0) != 0, (Object)"CapturedItemsSupplier is already set!");
        Preconditions.checkState((this.capturedEntitiesSupplier == null ? 1 : 0) != 0, (Object)"CapturedEntitiesSupplier is already set!");
        Preconditions.checkState((this.capturedItemStackSupplier == null ? 1 : 0) != 0, (Object)"CapturedItemStackSupplier is already set!");
        this.blocksSupplier = new CapturedBlocksSupplier();
        this.blockItemEntityDropsSupplier = new BlockItemEntityDropsSupplier();
        this.blockItemDropsSupplier = new BlockItemDropsSupplier();
        this.capturedItemsSupplier = new CapturedItemsSupplier();
        this.capturedEntitiesSupplier = new CapturedEntitiesSupplier();
        this.capturedItemStackSupplier = new CapturedItemStackSupplier();
        this.blockEntitySpawnSupplier = new CapturedBlockEntitySpawnSupplier();
        return (P)this;
    }

    public P addEntityCaptures() {
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        Preconditions.checkState((this.capturedItemsSupplier == null ? 1 : 0) != 0, (Object)"CapturedItemsSupplier is already set!");
        Preconditions.checkState((this.capturedEntitiesSupplier == null ? 1 : 0) != 0, (Object)"CapturedEntitiesSupplier is already set!");
        Preconditions.checkState((this.capturedItemStackSupplier == null ? 1 : 0) != 0, (Object)"CapturedItemStackSupplier is already set!");
        this.capturedItemsSupplier = new CapturedItemsSupplier();
        this.capturedEntitiesSupplier = new CapturedEntitiesSupplier();
        this.capturedItemStackSupplier = new CapturedItemStackSupplier();
        return (P)this;
    }

    public P addEntityDropCaptures() {
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        Preconditions.checkState((this.entityItemDropsSupplier == null ? 1 : 0) != 0, (Object)"EntityItemDropsSupplier is already set!");
        Preconditions.checkState((this.entityItemEntityDropsSupplier == null ? 1 : 0) != 0, (Object)"EntityItemEntityDropsSupplier is already set!");
        this.entityItemDropsSupplier = new EntityItemDropsSupplier();
        this.entityItemEntityDropsSupplier = new EntityItemEntityDropsSupplier();
        return (P)this;
    }

    public P buildAndSwitch() {
        this.isCompleted = true;
        PhaseTracker.getInstance().switchToPhase(this.state, this);
        return (P)this;
    }

    public boolean isComplete() {
        return this.isCompleted;
    }

    public PrettyPrinter printCustom(PrettyPrinter printer) {
        printer.add("    - %s: %s", "Owner", this.owner).add("    - %s: %s", "Notifier", this.notifier).add("    - %s: %s", "Source", this.source).add("    - %s: %s", "CapturedBlocks", this.blocksSupplier).add("    - %s: %s", "BlockItemDrops", this.blockItemDropsSupplier).add("    - %s: %s", "BlockItemEntityDrops", this.blockItemEntityDropsSupplier).add("    - %s: %s", "CapturedItems", this.capturedItemsSupplier).add("    - %s: %s", "CapturedEntities", this.capturedEntitiesSupplier).add("    - %s: %s", "CapturedItemStack", this.capturedItemStackSupplier).add("    - %s: %s", "EntityItemDrops", this.entityItemDropsSupplier).add("    - %s: %s", "EntityItemEntityDrops", this.entityItemEntityDropsSupplier).add("    - %s: %s", "BlockEntitySpawns", this.blockEntitySpawnSupplier).add("    - %s: %s", "CapturedBlockPosition", this.captureBlockPos);
        return printer;
    }

    public boolean shouldProcessImmediately() {
        return this.processImmediately;
    }

    public void setProcessImmediately(boolean state) {
        this.processImmediately = state;
    }

    public <T> Optional<T> getSource(Class<T> sourceClass) {
        if (this.source == null) {
            return Optional.empty();
        }
        if (sourceClass.isInstance(this.source)) {
            return Optional.of(this.source);
        }
        return Optional.empty();
    }

    public <T> T requireSource(Class<T> targetClass) {
        return this.getSource(targetClass).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over at a location!", this));
    }

    public Optional<User> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    public Optional<User> getNotifier() {
        return Optional.ofNullable(this.notifier);
    }

    public List<org.spongepowered.api.entity.Entity> getCapturedEntities() throws IllegalStateException {
        if (this.capturedEntitiesSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to capture entity spawns!", this).get();
        }
        return this.capturedEntitiesSupplier.get();
    }

    public CapturedSupplier<org.spongepowered.api.entity.Entity> getCapturedEntitySupplier() throws IllegalStateException {
        if (this.capturedEntitiesSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to capture entity spawns!", this).get();
        }
        return this.capturedEntitiesSupplier;
    }

    public List<EntityItem> getCapturedItems() throws IllegalStateException {
        if (this.capturedItemsSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to capture dropped item entities!", this).get();
        }
        return this.capturedItemsSupplier.get();
    }

    public CapturedSupplier<EntityItem> getCapturedItemsSupplier() throws IllegalStateException {
        if (this.capturedItemsSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to capture dropped item entities!", this).get();
        }
        return this.capturedItemsSupplier;
    }

    public List<BlockSnapshot> getCapturedBlocks() throws IllegalStateException {
        if (this.blocksSupplier == null) {
            throw TrackingUtil.throwWithContext("Expected to be capturing blocks, but we're not capturing them!", this).get();
        }
        return this.blocksSupplier.get();
    }

    public CapturedSupplier<BlockSnapshot> getCapturedBlockSupplier() throws IllegalStateException {
        if (this.blocksSupplier == null) {
            throw TrackingUtil.throwWithContext("Expected to be capturing blocks, but we're not capturing them!", this).get();
        }
        return this.blocksSupplier;
    }

    public Multimap<BlockPos, ItemDropData> getCapturedBlockDrops() throws IllegalStateException {
        if (this.blockItemDropsSupplier == null) {
            throw TrackingUtil.throwWithContext("Expected to be capturing block drops!", this).get();
        }
        return this.blockItemDropsSupplier.get();
    }

    public CapturedMultiMapSupplier<BlockPos, ItemDropData> getBlockDropSupplier() throws IllegalStateException {
        if (this.blockItemDropsSupplier == null) {
            throw TrackingUtil.throwWithContext("Expected to be capturing block drops!", this).get();
        }
        return this.blockItemDropsSupplier;
    }

    public CapturedMultiMapSupplier<BlockPos, EntityItem> getBlockItemDropSupplier() throws IllegalStateException {
        if (this.blockItemEntityDropsSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to track block item drops!", this).get();
        }
        return this.blockItemEntityDropsSupplier;
    }

    public CapturedMultiMapSupplier<UUID, ItemDropData> getCapturedEntityDropSupplier() throws IllegalStateException {
        if (this.entityItemDropsSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to capture entity drops!", this).get();
        }
        return this.entityItemDropsSupplier;
    }

    public CapturedMultiMapSupplier<UUID, EntityItem> getCapturedEntityItemDropSupplier() throws IllegalStateException {
        if (this.entityItemEntityDropsSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to capture entity drops!", this).get();
        }
        return this.entityItemEntityDropsSupplier;
    }

    public CapturedSupplier<ItemDropData> getCapturedItemStackSupplier() throws IllegalStateException {
        if (this.capturedItemStackSupplier == null) {
            throw TrackingUtil.throwWithContext("Expected to be capturing ItemStack drops from entities!", this).get();
        }
        return this.capturedItemStackSupplier;
    }

    public CapturedMultiMapSupplier<BlockPos, Entity> getBlockEntitySpawnSupplier() throws IllegalStateException {
        if (this.blockEntitySpawnSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to track block entity spawns!", this).get();
        }
        return this.blockEntitySpawnSupplier;
    }

    public CaptureBlockPos getCaptureBlockPos() throws IllegalStateException {
        if (this.captureBlockPos == null) {
            throw TrackingUtil.throwWithContext("Intended to capture a block position!", this).get();
        }
        return this.captureBlockPos;
    }

    public Optional<BlockPos> getBlockPosition() {
        return this.getCaptureBlockPos().getPos();
    }

    public void addNotifierAndOwnerToCauseStack() {
        if (this.owner != null) {
            Sponge.getCauseStackManager().addContext(EventContextKeys.OWNER, this.owner);
        }
        if (this.notifier != null) {
            Sponge.getCauseStackManager().addContext(EventContextKeys.NOTIFIER, this.notifier);
        }
    }

    protected PhaseContext(IPhaseState<? extends P> state) {
        this.state = state;
    }

    public int hashCode() {
        return Objects.hash(this.isCompleted);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PhaseContext other = (PhaseContext)obj;
        return Objects.equals(this.isCompleted, other.isCompleted);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("isCompleted", this.isCompleted).toString();
    }

    public P markEmpty() {
        this.isCompleted = true;
        return (P)this;
    }

    @Override
    public void close() {
        PhaseTracker.getInstance().completePhase(this.state);
    }

    public List<BlockSnapshot> getCapturedBlocksOrEmptyList() {
        return this.blocksSupplier != null ? this.blocksSupplier.orEmptyList() : Collections.emptyList();
    }

    public List<org.spongepowered.api.entity.Entity> getCapturedEntitiesOrEmptyList() {
        return this.capturedEntitiesSupplier != null ? this.capturedEntitiesSupplier.orEmptyList() : Collections.emptyList();
    }

    public List<EntityItem> getCapturedItemsOrEmptyList() {
        return this.capturedItemsSupplier != null ? this.capturedItemsSupplier.orEmptyList() : Collections.emptyList();
    }
}

