/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableSneakingData;
import org.spongepowered.api.data.manipulator.mutable.entity.SneakingData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeSneakingData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SneakingDataProcessor
extends AbstractEntitySingleDataProcessor<Entity, Boolean, Value<Boolean>, SneakingData, ImmutableSneakingData> {
    public SneakingDataProcessor() {
        super(Entity.class, Keys.IS_SNEAKING);
    }

    @Override
    protected SneakingData createManipulator() {
        return new SpongeSneakingData();
    }

    @Override
    protected boolean set(Entity entity, Boolean value) {
        entity.func_70095_a(value.booleanValue());
        return true;
    }

    @Override
    protected Optional<Boolean> getVal(Entity entity) {
        return Optional.of(entity.func_70093_af());
    }

    @Override
    protected Value<Boolean> constructValue(Boolean sneaking) {
        return new SpongeValue<Boolean>(Keys.IS_SNEAKING, false, sneaking);
    }

    @Override
    protected ImmutableValue<Boolean> constructImmutableValue(Boolean value) {
        return ImmutableSpongeValue.cachedOf(Keys.IS_SNEAKING, false, value);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

