/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableTameableData;
import org.spongepowered.api.data.manipulator.mutable.entity.TameableData;
import org.spongepowered.api.data.value.mutable.OptionalValue;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeTameableData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.mutable.SpongeOptionalValue;

public class SpongeTameableData
extends AbstractData<TameableData, ImmutableTameableData>
implements TameableData {
    @Nullable
    private UUID owner;

    public SpongeTameableData(@Nullable UUID owner) {
        super(TameableData.class);
        this.owner = owner;
        this.registerGettersAndSetters();
    }

    public SpongeTameableData() {
        this((UUID)null);
    }

    @Override
    public OptionalValue<UUID> owner() {
        return new SpongeOptionalValue<UUID>(Keys.TAMED_OWNER, Optional.ofNullable(this.owner));
    }

    @Override
    public TameableData copy() {
        return new SpongeTameableData(this.owner);
    }

    @Override
    public ImmutableTameableData asImmutable() {
        return ImmutableSpongeTameableData.create(this.owner);
    }

    @Override
    public DataContainer toContainer() {
        String uuid = this.owner == null ? "none" : this.owner.toString();
        return super.toContainer().set(Keys.TAMED_OWNER.getQuery(), (Object)uuid);
    }

    public Optional<UUID> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    public SpongeTameableData setOwner(Optional<UUID> owner) {
        this.owner = owner.orElse(null);
        return this;
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.TAMED_OWNER, this::getOwner);
        this.registerFieldSetter(Keys.TAMED_OWNER, this::setOwner);
        this.registerKeyValue(Keys.TAMED_OWNER, this::owner);
    }
}

