/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import java.time.Instant;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableJoinData;
import org.spongepowered.api.data.manipulator.mutable.entity.JoinData;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeJoinData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public class ImmutableSpongeJoinData
extends AbstractImmutableData<ImmutableJoinData, JoinData>
implements ImmutableJoinData {
    private final Instant firstJoined;
    private final Instant lastJoined;
    private final ImmutableSpongeValue<Instant> firstJoinedValue;
    private final ImmutableSpongeValue<Instant> lastJoinedValue;

    public ImmutableSpongeJoinData(Instant firstJoined, Instant lastJoined) {
        super(ImmutableJoinData.class);
        this.firstJoined = firstJoined;
        this.firstJoinedValue = new ImmutableSpongeValue<Instant>(Keys.FIRST_DATE_PLAYED, Instant.EPOCH, this.firstJoined);
        this.lastJoined = lastJoined;
        this.lastJoinedValue = new ImmutableSpongeValue<Instant>(Keys.LAST_DATE_PLAYED, Instant.EPOCH, this.lastJoined);
        this.registerGetters();
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.FIRST_DATE_PLAYED, () -> this.firstJoined);
        this.registerKeyValue(Keys.FIRST_DATE_PLAYED, this::firstPlayed);
        this.registerFieldGetter(Keys.LAST_DATE_PLAYED, () -> this.lastJoined);
        this.registerKeyValue(Keys.LAST_DATE_PLAYED, this::lastPlayed);
    }

    @Override
    public ImmutableValue<Instant> firstPlayed() {
        return this.firstJoinedValue;
    }

    @Override
    public ImmutableValue<Instant> lastPlayed() {
        return this.lastJoinedValue;
    }

    @Override
    public JoinData asMutable() {
        return new SpongeJoinData(this.firstJoined, this.lastJoined);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.FIRST_DATE_PLAYED.getQuery(), (Object)this.firstJoined.toEpochMilli()).set(Keys.LAST_DATE_PLAYED.getQuery(), (Object)this.lastJoined.toEpochMilli());
    }
}

