/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.block.tileentity;

import java.util.List;
import java.util.Optional;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import org.spongepowered.api.block.tileentity.carrier.TileEntityCarrier;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.common.data.builder.block.tileentity.AbstractTileBuilder;
import org.spongepowered.common.data.util.DataQueries;

public class SpongeLockableBuilder<T extends TileEntityCarrier>
extends AbstractTileBuilder<T> {
    protected SpongeLockableBuilder(Class<T> clazz, int version) {
        super(clazz, version);
    }

    @Override
    protected Optional<T> buildContent(DataView container) throws InvalidDataException {
        return super.buildContent(container).flatMap(lockable -> {
            if (!container.contains(DataQueries.BLOCK_ENTITY_ITEM_CONTENTS)) {
                ((TileEntity)lockable).func_145843_s();
                return Optional.empty();
            }
            List<DataView> contents = container.getViewList(DataQueries.BLOCK_ENTITY_ITEM_CONTENTS).get();
            for (DataView content : contents) {
                net.minecraft.item.ItemStack stack = (net.minecraft.item.ItemStack)content.getSerializable(DataQueries.BLOCK_ENTITY_SLOT_ITEM, ItemStack.class).get();
                ((IInventory)lockable).func_70299_a(content.getInt(DataQueries.BLOCK_ENTITY_SLOT).get().intValue(), stack);
            }
            if (container.contains(Keys.LOCK_TOKEN.getQuery())) {
                lockable.offer(Keys.LOCK_TOKEN, container.getString(Keys.LOCK_TOKEN.getQuery()).get());
            }
            return Optional.of(lockable);
        });
    }
}

