/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.effect.Viewer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.context.ContextSource;
import org.spongepowered.api.text.channel.ChatTypeMessageReceiver;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.api.world.ChunkPreGenerate;
import org.spongepowered.api.world.Dimension;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.PortalAgent;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.WorldBorder;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.extent.worker.MutableBiomeVolumeWorker;
import org.spongepowered.api.world.extent.worker.MutableBlockVolumeWorker;
import org.spongepowered.api.world.gen.WorldGenerator;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.api.world.storage.WorldStorage;
import org.spongepowered.api.world.weather.WeatherUniverse;

public interface World
extends Extent,
WeatherUniverse,
Viewer,
ContextSource,
MessageReceiver,
ChatTypeMessageReceiver {
    public Collection<Player> getPlayers();

    default public Location<World> getLocation(Vector3i position) {
        return new Location<World>(this, position);
    }

    default public Location<World> getLocation(int x, int y, int z) {
        return this.getLocation(new Vector3i(x, y, z));
    }

    default public Location<World> getLocation(Vector3d position) {
        return new Location<World>(this, position);
    }

    default public Location<World> getLocation(double x, double y, double z) {
        return this.getLocation(new Vector3d(x, y, z));
    }

    default public LocatableBlock getLocatableBlock(Vector3i position) {
        return LocatableBlock.builder().world(this).position(position).build();
    }

    default public LocatableBlock getLocatableBlock(int x, int y, int z) {
        return LocatableBlock.builder().world(this).position(x, y, z).build();
    }

    default public Optional<Chunk> getChunkAtBlock(Vector3i blockPosition) {
        return this.getChunkAtBlock(blockPosition.getX(), blockPosition.getY(), blockPosition.getZ());
    }

    default public Optional<Chunk> getChunkAtBlock(int bx, int by, int bz) {
        return this.getChunk(Sponge.getServer().getChunkLayout().forceToChunk(bx, by, bz));
    }

    default public Optional<Chunk> getChunk(Vector3i chunkPosition) {
        return this.getChunk(chunkPosition.getX(), chunkPosition.getY(), chunkPosition.getZ());
    }

    public Optional<Chunk> getChunk(int var1, int var2, int var3);

    default public Optional<Chunk> loadChunk(Vector3i chunkPosition, boolean shouldGenerate) {
        return this.loadChunk(chunkPosition.getX(), chunkPosition.getY(), chunkPosition.getZ(), shouldGenerate);
    }

    public Optional<Chunk> loadChunk(int var1, int var2, int var3, boolean var4);

    default public CompletableFuture<Optional<Chunk>> loadChunkAsync(Vector3i chunkPosition, boolean shouldGenerate) {
        return this.loadChunkAsync(chunkPosition.getX(), chunkPosition.getY(), chunkPosition.getZ(), shouldGenerate);
    }

    default public CompletableFuture<Optional<Chunk>> loadChunkAsync(int cx, int cy, int cz, boolean shouldGenerate) {
        return CompletableFuture.completedFuture(this.loadChunk(cx, cy, cz, shouldGenerate));
    }

    public boolean unloadChunk(Chunk var1);

    public Iterable<Chunk> getLoadedChunks();

    @Override
    public Optional<Entity> getEntity(UUID var1);

    public WorldBorder getWorldBorder();

    public ChunkPreGenerate.Builder newChunkPreGenerate(Vector3d var1, double var2);

    public Dimension getDimension();

    public WorldGenerator getWorldGenerator();

    public WorldProperties getProperties();

    public Path getDirectory();

    @Override
    default public UUID getUniqueId() {
        return this.getProperties().getUniqueId();
    }

    default public String getName() {
        return this.getProperties().getWorldName();
    }

    default public Difficulty getDifficulty() {
        return this.getProperties().getDifficulty();
    }

    default public Optional<String> getGameRule(String gameRule) {
        return this.getProperties().getGameRule(gameRule);
    }

    default public Map<String, String> getGameRules() {
        return this.getProperties().getGameRules();
    }

    default public boolean doesKeepSpawnLoaded() {
        return this.getProperties().doesKeepSpawnLoaded();
    }

    default public void setKeepSpawnLoaded(boolean keepLoaded) {
        this.getProperties().setKeepSpawnLoaded(keepLoaded);
    }

    default public Location<World> getSpawnLocation() {
        return new Location<World>(this, this.getProperties().getSpawnPosition());
    }

    default public SerializationBehavior getSerializationBehavior() {
        return this.getProperties().getSerializationBehavior();
    }

    default public void setSerializationBehavior(SerializationBehavior behavior) {
        this.getProperties().setSerializationBehavior(behavior);
    }

    public WorldStorage getWorldStorage();

    public void triggerExplosion(Explosion var1);

    public PortalAgent getPortalAgent();

    public int getSeaLevel();

    @Override
    public MutableBiomeVolumeWorker<World> getBiomeWorker();

    @Override
    public MutableBlockVolumeWorker<World> getBlockWorker();

    public boolean save() throws IOException;

    public int getViewDistance();

    public void setViewDistance(int var1);

    public void resetViewDistance();
}

