/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.service.permission;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectReference;

public interface SubjectCollection {
    public String getIdentifier();

    public Predicate<String> getIdentifierValidityPredicate();

    public CompletableFuture<Subject> loadSubject(String var1);

    public Optional<Subject> getSubject(String var1);

    public CompletableFuture<Boolean> hasSubject(String var1);

    public CompletableFuture<Map<String, Subject>> loadSubjects(Set<String> var1);

    public Collection<Subject> getLoadedSubjects();

    public CompletableFuture<Set<String>> getAllIdentifiers();

    public SubjectReference newSubjectReference(String var1);

    default public CompletableFuture<Void> applyToAll(Consumer<Subject> action) {
        Preconditions.checkNotNull(action, (Object)"action");
        return CompletableFuture.runAsync(() -> {
            Set<String> identifiers = this.getAllIdentifiers().join();
            this.applyToAll(action, identifiers).join();
        });
    }

    default public CompletableFuture<Void> applyToAll(Consumer<Subject> action, Set<String> identifiers) {
        Preconditions.checkNotNull(action, (Object)"action");
        Preconditions.checkNotNull(identifiers, (Object)"identifiers");
        return CompletableFuture.runAsync(() -> {
            for (String id : identifiers) {
                Subject subject = this.loadSubject(id).join();
                action.accept(subject);
                this.suggestUnload(subject.getIdentifier());
            }
        });
    }

    public CompletableFuture<Map<SubjectReference, Boolean>> getAllWithPermission(String var1);

    public CompletableFuture<Map<SubjectReference, Boolean>> getAllWithPermission(Set<Context> var1, String var2);

    public Map<Subject, Boolean> getLoadedWithPermission(String var1);

    public Map<Subject, Boolean> getLoadedWithPermission(Set<Context> var1, String var2);

    public Subject getDefaults();

    public void suggestUnload(String var1);
}

