/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.inventory.property;

import org.spongepowered.api.data.Property;
import org.spongepowered.api.item.inventory.property.AbstractInventoryProperty;
import org.spongepowered.api.util.Coerce;

public class StringProperty
extends AbstractInventoryProperty<String, String> {
    public StringProperty(String value) {
        super(value);
    }

    public StringProperty(String value, Property.Operator operator) {
        super(value, operator);
    }

    public StringProperty(Object value, Property.Operator operator) {
        super(Coerce.toString(value), operator);
    }

    @Override
    public int compareTo(Property<?, ?> other) {
        if (other == null) {
            return 1;
        }
        return ((String)this.getValue()).compareTo(Coerce.toString(other.getValue()));
    }

    public static StringProperty of(Object value) {
        return new StringProperty(value, Property.Operator.EQUAL);
    }

    public static StringProperty not(Object value) {
        return new StringProperty(value, Property.Operator.NOTEQUAL);
    }

    public static StringProperty greaterThan(Object value) {
        return new StringProperty(value, Property.Operator.GREATER);
    }

    public static StringProperty greaterThanOrEqual(Object value) {
        return new StringProperty(value, Property.Operator.GEQUAL);
    }

    public static StringProperty lessThan(Object value) {
        return new StringProperty(value, Property.Operator.LESS);
    }

    public static StringProperty lessThanOrEqual(Object value) {
        return new StringProperty(value, Property.Operator.LEQUAL);
    }
}

