/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.inventory.property;

import org.spongepowered.api.data.Property;
import org.spongepowered.api.item.inventory.property.AbstractInventoryProperty;
import org.spongepowered.api.util.Coerce;

public class IntProperty
extends AbstractInventoryProperty<String, Integer> {
    public IntProperty(int value) {
        super(Coerce.toInteger(value));
    }

    public IntProperty(int value, Property.Operator operator) {
        super(value, operator);
    }

    public IntProperty(Object value, Property.Operator operator) {
        super(Coerce.toInteger(value), operator);
    }

    @Override
    public int compareTo(Property<?, ?> other) {
        return ((Integer)this.getValue()).compareTo(other == null ? 1 : Coerce.toInteger(other.getValue()));
    }

    public static IntProperty of(Object value) {
        return new IntProperty(value, Property.Operator.EQUAL);
    }

    public static IntProperty not(Object value) {
        return new IntProperty(value, Property.Operator.NOTEQUAL);
    }

    public static IntProperty greaterThan(Object value) {
        return new IntProperty(value, Property.Operator.GREATER);
    }

    public static IntProperty greaterThanOrEqual(Object value) {
        return new IntProperty(value, Property.Operator.GEQUAL);
    }

    public static IntProperty lessThan(Object value) {
        return new IntProperty(value, Property.Operator.LESS);
    }

    public static IntProperty lessThanOrEqual(Object value) {
        return new IntProperty(value, Property.Operator.LEQUAL);
    }
}

