/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.Timing;
import co.aikar.timings.TimingData;
import co.aikar.timings.TimingIdentifier;
import co.aikar.timings.Timings;
import co.aikar.timings.TimingsManager;
import co.aikar.util.LoadingIntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.spongepowered.api.Sponge;
import org.spongepowered.common.SpongeImpl;

class TimingHandler
implements Timing {
    private static int idPool = 1;
    final int id = idPool++;
    final String name;
    private final boolean verbose;
    final Int2ObjectMap<TimingData> children = new LoadingIntMap<TimingData>(TimingData.LOADER);
    final TimingData record;
    private final TimingHandler groupHandler;
    private long start = 0L;
    private int timingDepth = 0;
    private boolean added;
    boolean timed;
    boolean enabled;
    private TimingHandler parent;

    TimingHandler(TimingIdentifier id) {
        if (id.name.startsWith("##")) {
            this.verbose = true;
            this.name = id.name.substring(3);
        } else {
            this.name = id.name;
            this.verbose = false;
        }
        this.record = new TimingData(this.id);
        this.groupHandler = id.groupHandler;
        TimingIdentifier.getGroup((String)id.group).handlers.add(this);
        this.checkEnabled();
    }

    final void checkEnabled() {
        this.enabled = Timings.isTimingsEnabled() && (!this.verbose || Timings.isVerboseTimingsEnabled());
    }

    void processTick(boolean violated) {
        if (this.timingDepth != 0 || this.record.curTickCount == 0) {
            this.timingDepth = 0;
            this.start = 0L;
            return;
        }
        this.record.processTick(violated);
        for (TimingData handler : this.children.values()) {
            handler.processTick(violated);
        }
    }

    @Override
    public void startTimingIfSync() {
        if (!this.enabled || SpongeImpl.getGame().getPlatform().getExecutionType().isClient()) {
            return;
        }
        if (Sponge.isServerAvailable() && SpongeImpl.getServer().func_152345_ab()) {
            this.startTiming();
        }
    }

    @Override
    public void stopTimingIfSync() {
        if (!this.enabled || SpongeImpl.getGame().getPlatform().getExecutionType().isClient()) {
            return;
        }
        if (Sponge.isServerAvailable() && SpongeImpl.getServer().func_152345_ab()) {
            this.stopTiming();
        }
    }

    @Override
    public TimingHandler startTiming() {
        if (!this.enabled || SpongeImpl.getGame().getPlatform().getExecutionType().isClient()) {
            return this;
        }
        if (++this.timingDepth == 1) {
            this.start = System.nanoTime();
            this.parent = TimingsManager.CURRENT;
            TimingsManager.CURRENT = this;
        }
        return this;
    }

    @Override
    public void stopTiming() {
        if (!this.enabled || SpongeImpl.getGame().getPlatform().getExecutionType().isClient()) {
            return;
        }
        if (--this.timingDepth == 0 && this.start != 0L) {
            if (!SpongeImpl.getServer().func_152345_ab()) {
                SpongeImpl.getLogger().fatal("stopTiming called async for " + this.name);
                new Throwable().printStackTrace();
                this.start = 0L;
                return;
            }
            this.addDiff(System.nanoTime() - this.start);
            this.start = 0L;
        }
    }

    @Override
    public void abort() {
        if (this.enabled && this.timingDepth > 0) {
            this.start = 0L;
        }
    }

    void addDiff(long diff) {
        if (TimingsManager.CURRENT == this) {
            TimingsManager.CURRENT = this.parent;
            if (this.parent != null) {
                ((TimingData)this.parent.children.get(this.id)).add(diff);
            }
        }
        this.record.add(diff);
        if (!this.added) {
            this.added = true;
            this.timed = true;
            TimingsManager.HANDLERS.add(this);
        }
        if (this.groupHandler != null) {
            this.groupHandler.addDiff(diff);
            ((TimingData)this.groupHandler.children.get(this.id)).add(diff);
        }
    }

    void reset(boolean full) {
        this.record.reset();
        if (full) {
            this.timed = false;
        }
        this.start = 0L;
        this.timingDepth = 0;
        this.added = false;
        this.children.clear();
        this.checkEnabled();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public void close() {
        this.stopTimingIfSync();
    }

    public boolean isSpecial() {
        return this == TimingsManager.FULL_SERVER_TICK || this == TimingsManager.TIMINGS_TICK;
    }
}

